/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.refactoring;

import com.intellij.CommonBundle;
import com.intellij.ide.TitledHandler;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.refactoring.DartRenameDialog;
import com.jetbrains.lang.dart.ide.refactoring.ServerRenameRefactoring;
import com.jetbrains.lang.dart.ide.refactoring.status.RefactoringStatus;
import org.jetbrains.annotations.NotNull;

public class DartServerRenameHandler
implements RenameHandler,
TitledHandler {
    public String getActionTitle() {
        return "Dart Rename Refactoring";
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext context) {
        if (project == null) {
            DartServerRenameHandler.$$$reportNull$$$0(0);
        }
        DartServerRenameHandler.showRenameDialog(project, editor, context);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext context) {
        if (project == null) {
            DartServerRenameHandler.$$$reportNull$$$0(1);
        }
        if (elements == null) {
            DartServerRenameHandler.$$$reportNull$$$0(2);
        }
    }

    public boolean isAvailableOnDataContext(@NotNull DataContext dataContext) {
        Editor editor;
        if (dataContext == null) {
            DartServerRenameHandler.$$$reportNull$$$0(3);
        }
        if ((editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext)) == null) {
            return false;
        }
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(dataContext);
        if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) {
            return false;
        }
        PsiElement psiElement = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext);
        if (psiElement != null) {
            return psiElement.getLanguage() == DartLanguage.INSTANCE && !(psiElement instanceof PsiFile);
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        PsiElement elementAtOffset = psiFile == null ? null : psiFile.findElementAt(editor.getCaretModel().getOffset());
        return elementAtOffset != null && elementAtOffset.getLanguage() == DartLanguage.INSTANCE;
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }

    private static void showRenameDialog(@NotNull Project project, @NotNull Editor editor, DataContext context) {
        int offset;
        if (project == null) {
            DartServerRenameHandler.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            DartServerRenameHandler.$$$reportNull$$$0(5);
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        VirtualFile virtualFile = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
        if (psiFile == null || virtualFile == null) {
            return;
        }
        Caret caret = (Caret)CommonDataKeys.CARET.getData(context);
        PsiElement element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context);
        if (caret != null) {
            offset = caret.getOffset();
        } else if (element != null) {
            offset = element.getTextOffset();
        } else {
            return;
        }
        ServerRenameRefactoring refactoring = new ServerRenameRefactoring(project, virtualFile, offset, 0);
        RefactoringStatus initialStatus = refactoring.checkInitialConditions();
        if (initialStatus == null) {
            return;
        }
        if (initialStatus.hasError()) {
            String message = initialStatus.getMessage();
            assert (message != null);
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)CommonBundle.getErrorTitle(), null);
            return;
        }
        new DartRenameDialog(project, editor, refactoring).show();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/refactoring/DartServerRenameHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isAvailableOnDataContext";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showRenameDialog";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

