/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.moveCode;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.editorActions.moveUpDown.LineMover;
import com.intellij.codeInsight.editorActions.moveUpDown.LineRange;
import com.intellij.codeInsight.editorActions.moveUpDown.StatementUpDownMover;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.psi.DartClassBody;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartLibraryStatement;
import com.jetbrains.lang.dart.psi.DartUriBasedDirective;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartComponentMover
extends LineMover {
    public boolean checkAvailable(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
        if (editor == null) {
            DartComponentMover.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DartComponentMover.$$$reportNull$$$0(1);
        }
        if (info == null) {
            DartComponentMover.$$$reportNull$$$0(2);
        }
        if (!(file instanceof DartFile)) {
            return false;
        }
        if (!super.checkAvailable(editor, file, info, down)) {
            return false;
        }
        CodeMover codeMover = new CodeMover(editor, file, info, down);
        codeMover.findSourceComponents();
        if (!codeMover.hasSourceComponents()) {
            return false;
        }
        codeMover.findSourceLineRange();
        if (!codeMover.hasSourceLineRange()) {
            return false;
        }
        codeMover.findTargetComponents();
        if (!codeMover.hasTargetComponents()) {
            return info.toMove2 == null;
        }
        codeMover.findTargetLineRange();
        if (!codeMover.hasTargetLineRange()) {
            return info.toMove2 == null;
        }
        if (codeMover.areTargetsAtSameLevel()) {
            info.indentTarget = false;
        }
        info.toMove = codeMover.sourceRange;
        info.toMove2 = codeMover.targetRange;
        return true;
    }

    @VisibleForTesting
    static Pair<PsiElement, PsiElement> findCommentRange(@NotNull PsiElement element) {
        if (element == null) {
            DartComponentMover.$$$reportNull$$$0(3);
        }
        return CodeMover.findCommentRange(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkAvailable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findCommentRange";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CodeMover {
        @NotNull
        final Editor editor;
        @NotNull
        final PsiFile file;
        @NotNull
        final StatementUpDownMover.MoveInfo info;
        final boolean isMovingDown;
        Pair<PsiElement, PsiElement> sourceComponents;
        Pair<PsiElement, PsiElement> targetComponents;
        LineRange sourceRange;
        LineRange targetRange;

        CodeMover(@NotNull Editor editor, @NotNull PsiFile file, @NotNull StatementUpDownMover.MoveInfo info, boolean down) {
            if (editor == null) {
                CodeMover.$$$reportNull$$$0(0);
            }
            if (file == null) {
                CodeMover.$$$reportNull$$$0(1);
            }
            if (info == null) {
                CodeMover.$$$reportNull$$$0(2);
            }
            this.editor = editor;
            this.file = file;
            this.info = info;
            this.isMovingDown = down;
        }

        @Nullable
        static Pair<PsiElement, PsiElement> findCommentRange(@NotNull PsiElement element) {
            if (element == null) {
                CodeMover.$$$reportNull$$$0(3);
            }
            if (!CodeMover.isComment(element) && !(element instanceof PsiWhiteSpace)) {
                return null;
            }
            PsiElement first = CodeMover.findFinalComment(element, false);
            PsiElement last = CodeMover.findFinalComment(element, true);
            if (CodeMover.commentTypeOf(first) != CodeMover.commentTypeOf(last)) {
                last = element.getPrevSibling();
            }
            return Pair.create((Object)first, (Object)last);
        }

        boolean hasSourceComponents() {
            return this.sourceComponents != null && this.sourceComponents.first != null;
        }

        void findSourceComponents() {
            PsiElement next;
            PsiElement lastMember;
            Pair psiRange = DartComponentMover.getElementRange((Editor)this.editor, (PsiFile)this.file, (LineRange)this.info.toMove);
            if (psiRange == null) {
                return;
            }
            PsiElement firstMember = CodeMover.getDeclarationParent(CodeMover.firstMoveableComponent((PsiElement)psiRange.first));
            if (firstMember == null) {
                return;
            }
            if (CodeMover.isComment(firstMember)) {
                lastMember = CodeMover.findAttachedDeclaration(firstMember);
                if (lastMember == firstMember) {
                    lastMember = CodeMover.getDeclarationParent((PsiElement)psiRange.second);
                }
            } else {
                lastMember = firstMember;
                if ((firstMember = CodeMover.findAttachedComment(firstMember)) == lastMember && !this.isMovingDown && lastMember.getParent() instanceof DartClassMembers) {
                    DartClassMembers members = (DartClassMembers)lastMember.getParent();
                    next = CodeMover.nextSib((PsiElement)members, false);
                    if (next instanceof PsiWhiteSpace && !CodeMover.isCommentSeparator(next)) {
                        next = CodeMover.nextSib(next, false);
                    }
                    if (CodeMover.isComment(next)) {
                        firstMember = next;
                    }
                }
            }
            if (lastMember == null) {
                return;
            }
            PsiElement sibling = lastMember.getNextSibling();
            if (!CodeMover.isCommentSeparator(sibling)) {
                next = DartComponentMover.firstNonWhiteElement((PsiElement)lastMember.getNextSibling(), (boolean)true);
                if (CodeMover.isSemicolon(next)) {
                    lastMember = next;
                }
                if (this.isMovingDown) {
                    next = lastMember.getNextSibling();
                    if (next == null && lastMember.getParent() instanceof DartClassMembers) {
                        DartClassMembers members = (DartClassMembers)lastMember.getParent();
                        next = CodeMover.nextSib((PsiElement)members, true);
                    }
                    if (next instanceof PsiWhiteSpace && !StringUtil.containsLineBreak((CharSequence)next.getText())) {
                        next = next.getNextSibling();
                    }
                    if (next != null && CodeMover.isLineComment(next)) {
                        lastMember = next;
                    }
                }
            }
            this.sourceComponents = Pair.create((Object)firstMember, (Object)lastMember);
        }

        boolean hasSourceLineRange() {
            return this.sourceRange != null;
        }

        void findSourceLineRange() {
            LineRange range;
            if (this.sourceComponents.first == this.sourceComponents.second) {
                range = this.memberRange((PsiElement)this.sourceComponents.first);
                if (range == null) {
                    return;
                }
                range.firstElement = range.lastElement = (PsiElement)this.sourceComponents.first;
            } else {
                PsiElement parent = PsiTreeUtil.findCommonParent((PsiElement)((PsiElement)this.sourceComponents.first), (PsiElement)((PsiElement)this.sourceComponents.second));
                if (parent == null) {
                    return;
                }
                if (parent instanceof DartClassBody) {
                    return;
                }
                Pair combinedRange = DartComponentMover.getElementRange((PsiElement)parent, (PsiElement)((PsiElement)this.sourceComponents.first), (PsiElement)((PsiElement)this.sourceComponents.second));
                if (combinedRange == null) {
                    return;
                }
                LineRange lineRange1 = this.memberRange((PsiElement)combinedRange.first);
                if (lineRange1 == null) {
                    return;
                }
                LineRange lineRange2 = this.memberRange((PsiElement)combinedRange.second);
                if (lineRange2 == null) {
                    return;
                }
                range = new LineRange(lineRange1.startLine, lineRange2.endLine);
                range.firstElement = (PsiElement)combinedRange.first;
                range.lastElement = (PsiElement)combinedRange.second;
            }
            this.sourceRange = range;
        }

        boolean hasTargetComponents() {
            return this.targetComponents != null && this.targetComponents.first != null;
        }

        void findTargetComponents() {
            PsiElement lastElement;
            PsiElement firstElement;
            PsiElement next;
            PsiElement ref = this.isMovingDown ? this.sourceRange.lastElement : this.sourceRange.firstElement;
            PsiElement sibling = CodeMover.nextSib(ref, this.isMovingDown);
            if (sibling instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)sibling.getText()) == 0 && CodeMover.isLineComment(next = sibling.getNextSibling())) {
                sibling = next.getNextSibling();
            }
            if (sibling == null && ref.getParent() instanceof DartClassMembers) {
                DartClassMembers members = (DartClassMembers)ref.getParent();
                sibling = CodeMover.nextSib((PsiElement)members, this.isMovingDown);
            }
            if ((firstElement = DartComponentMover.firstNonWhiteElement((PsiElement)sibling, (boolean)this.isMovingDown)) == null) {
                PsiElement psiElement = firstElement = sibling == null ? ref : sibling;
            }
            if (CodeMover.isComment(firstElement)) {
                lastElement = CodeMover.isCommentSeparator(sibling) ? firstElement : CodeMover.findAttachedDeclaration(firstElement);
            } else {
                PsiElement psiElement = lastElement = this.isMovingDown ? firstElement : CodeMover.findAttachedComment(firstElement);
            }
            if (firstElement instanceof PsiWhiteSpace || lastElement instanceof PsiWhiteSpace) {
                this.info.prohibitMove();
                return;
            }
            this.targetComponents = this.isMovingDown ? Pair.create((Object)firstElement, (Object)lastElement) : Pair.create((Object)lastElement, (Object)firstElement);
        }

        boolean hasTargetLineRange() {
            return this.targetRange != null;
        }

        void findTargetLineRange() {
            PsiElement target;
            PsiElement source = this.isMovingDown ? this.sourceRange.lastElement : this.sourceRange.firstElement;
            PsiElement psiElement = target = this.isMovingDown ? (PsiElement)this.targetComponents.first : (PsiElement)this.targetComponents.second;
            if (CodeMover.crossesHeaderBoundary(source, target)) {
                this.info.prohibitMove();
                return;
            }
            this.targetRange = new LineRange((PsiElement)this.targetComponents.first, (PsiElement)this.targetComponents.second, this.editor.getDocument());
        }

        boolean areTargetsAtSameLevel() {
            return ((PsiElement)this.sourceComponents.second).getParent() == ((PsiElement)this.targetComponents.second).getParent();
        }

        private LineRange memberRange(@NotNull PsiElement member) {
            if (member == null) {
                CodeMover.$$$reportNull$$$0(4);
            }
            TextRange textRange = member.getTextRange();
            if (this.editor.getDocument().getTextLength() < textRange.getEndOffset()) {
                return null;
            }
            LogicalPosition startPosition = this.editor.offsetToLogicalPosition(textRange.getStartOffset());
            LogicalPosition endPosition = this.editor.offsetToLogicalPosition(textRange.getEndOffset());
            int endLine = endPosition.line + 1;
            return new LineRange(startPosition.line, endLine);
        }

        @NotNull
        private static PsiElement findAttachedDeclaration(@NotNull PsiElement element) {
            PsiElement commentEnd;
            if (element == null) {
                CodeMover.$$$reportNull$$$0(5);
            }
            if (CodeMover.isCommentSeparator((commentEnd = CodeMover.findFinalComment(element, true)).getNextSibling())) {
                PsiElement psiElement = commentEnd;
                if (psiElement == null) {
                    CodeMover.$$$reportNull$$$0(6);
                }
                return psiElement;
            }
            PsiElement next = PsiTreeUtil.skipWhitespacesForward((PsiElement)commentEnd);
            PsiElement psiElement = next == null ? element : (CodeMover.isComment(next) ? element : next);
            if (psiElement == null) {
                CodeMover.$$$reportNull$$$0(7);
            }
            return psiElement;
        }

        @NotNull
        private static PsiElement findAttachedComment(@NotNull PsiElement element) {
            if (element == null) {
                CodeMover.$$$reportNull$$$0(8);
            }
            PsiElement sib = CodeMover.isComment(element) ? element : element.getPrevSibling();
            PsiElement commentStart = CodeMover.findFinalComment(sib == null ? element : sib, false);
            PsiElement psiElement = commentStart == sib && commentStart instanceof PsiWhiteSpace ? element : commentStart;
            if (psiElement == null) {
                CodeMover.$$$reportNull$$$0(9);
            }
            return psiElement;
        }

        private static PsiElement nextSib(@NotNull PsiElement element, boolean isForward) {
            if (element == null) {
                CodeMover.$$$reportNull$$$0(10);
            }
            return isForward ? element.getNextSibling() : element.getPrevSibling();
        }

        private static boolean isCommentSeparator(@Nullable PsiElement element) {
            return element instanceof PsiWhiteSpace && StringUtil.countNewLines((CharSequence)element.getText()) > 1;
        }

        @NotNull
        private static PsiElement findFinalComment(@NotNull PsiElement element, boolean isForward) {
            if (element == null) {
                CodeMover.$$$reportNull$$$0(11);
            }
            PsiElement target = element;
            PsiElement sib = element;
            CommentType groupType = null;
            while (sib != null) {
                if (sib instanceof PsiWhiteSpace) {
                    if (CodeMover.isCommentSeparator(sib)) break;
                    sib = CodeMover.nextSib(sib, isForward);
                    continue;
                }
                CommentType type = CodeMover.commentTypeOf(sib);
                switch (type) {
                    case INVALID: {
                        PsiElement parent = sib.getParent();
                        if (parent instanceof DartFile) {
                            PsiElement psiElement = sib;
                            if (psiElement == null) {
                                CodeMover.$$$reportNull$$$0(12);
                            }
                            return psiElement;
                        }
                        PsiElement psiElement = CodeMover.findFinalComment(parent, isForward);
                        if (psiElement == null) {
                            CodeMover.$$$reportNull$$$0(13);
                        }
                        return psiElement;
                    }
                    case MULTI_LINE_DOC_COMMENT: {
                        PsiElement psiElement = sib;
                        if (psiElement == null) {
                            CodeMover.$$$reportNull$$$0(14);
                        }
                        return psiElement;
                    }
                    case MULTI_LINE_COMMENT: 
                    case SINGLE_LINE_DOC_COMMENT: 
                    case SINGLE_LINE_COMMENT: {
                        if (groupType == null) {
                            groupType = type;
                        }
                        if (groupType == type) {
                            target = sib;
                            sib = CodeMover.nextSib(sib, isForward);
                            break;
                        }
                        sib = null;
                        break;
                    }
                    case NONE: {
                        sib = null;
                    }
                }
            }
            PsiElement psiElement = target;
            if (psiElement == null) {
                CodeMover.$$$reportNull$$$0(15);
            }
            return psiElement;
        }

        private static boolean isLineComment(@NotNull PsiElement element) {
            if (element == null) {
                CodeMover.$$$reportNull$$$0(16);
            }
            switch (CodeMover.commentTypeOf(element)) {
                case SINGLE_LINE_DOC_COMMENT: 
                case SINGLE_LINE_COMMENT: {
                    return true;
                }
            }
            return false;
        }

        @NotNull
        private static CommentType commentTypeOf(@NotNull PsiElement element) {
            IElementType type;
            if (element == null) {
                CodeMover.$$$reportNull$$$0(17);
            }
            if ((type = element.getNode().getElementType()) == DartTokenTypesSets.SINGLE_LINE_COMMENT) {
                CommentType commentType = CommentType.SINGLE_LINE_COMMENT;
                if (commentType == null) {
                    CodeMover.$$$reportNull$$$0(18);
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.MULTI_LINE_COMMENT) {
                CommentType commentType = CommentType.MULTI_LINE_COMMENT;
                if (commentType == null) {
                    CodeMover.$$$reportNull$$$0(19);
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
                CommentType commentType = CommentType.SINGLE_LINE_DOC_COMMENT;
                if (commentType == null) {
                    CodeMover.$$$reportNull$$$0(20);
                }
                return commentType;
            }
            if (type == DartTokenTypesSets.MULTI_LINE_DOC_COMMENT) {
                CommentType commentType = CommentType.MULTI_LINE_DOC_COMMENT;
                if (commentType == null) {
                    CodeMover.$$$reportNull$$$0(21);
                }
                return commentType;
            }
            if (DartTokenTypesSets.DOC_COMMENT_CONTENTS.contains(type)) {
                CommentType commentType = CommentType.INVALID;
                if (commentType == null) {
                    CodeMover.$$$reportNull$$$0(22);
                }
                return commentType;
            }
            CommentType commentType = CommentType.NONE;
            if (commentType == null) {
                CodeMover.$$$reportNull$$$0(23);
            }
            return commentType;
        }

        private static PsiElement getDeclarationParent(PsiElement element) {
            if (CodeMover.isComment(element)) {
                return element;
            }
            PsiElement parent = CodeMover.getHeaderParent(element);
            if (parent != null) {
                return parent;
            }
            parent = PsiTreeUtil.getParentOfType((PsiElement)element, DartVarDeclarationList.class, (boolean)false);
            if (parent != null && (parent.getParent() instanceof DartFile || parent.getParent() instanceof DartClassMembers)) {
                return parent;
            }
            if (element instanceof LeafPsiElement && (element.getParent() instanceof DartFile || element.getParent() instanceof DartClassMembers)) {
                return element;
            }
            if (element instanceof DartClassMembers) {
                PsiElement last = element.getLastChild();
                if ((last = PsiTreeUtil.skipSiblingsBackward((PsiElement)last, (Class[])new Class[]{LeafPsiElement.class, PsiWhiteSpace.class})) != null) {
                    return last;
                }
            }
            return PsiTreeUtil.getParentOfType((PsiElement)element, DartComponent.class, (boolean)false);
        }

        private static boolean crossesHeaderBoundary(PsiElement base, PsiElement sibling) {
            if (CodeMover.isComment(base) || CodeMover.isComment(sibling)) {
                return false;
            }
            PsiElement baseType = CodeMover.getHeaderParent(base);
            PsiElement sibType = CodeMover.getHeaderParent(sibling);
            if (baseType == null && sibType == null) {
                return false;
            }
            if (baseType == null || sibType == null) {
                return true;
            }
            if (baseType instanceof DartLibraryStatement && sibType instanceof DartLibraryStatement) {
                return false;
            }
            return baseType instanceof DartLibraryStatement || sibType instanceof DartLibraryStatement;
        }

        private static PsiElement getHeaderParent(PsiElement element) {
            return PsiTreeUtil.getNonStrictParentOfType((PsiElement)element, (Class[])new Class[]{DartUriBasedDirective.class, DartLibraryStatement.class});
        }

        private static boolean isComment(@NotNull PsiElement element) {
            IElementType type;
            if (element == null) {
                CodeMover.$$$reportNull$$$0(24);
            }
            return DartTokenTypesSets.COMMENTS.contains(type = element.getNode().getElementType()) || DartTokenTypesSets.DOC_COMMENT_CONTENTS.contains(type);
        }

        private static boolean isSemicolon(PsiElement element) {
            return element instanceof LeafPsiElement;
        }

        private static PsiElement firstMoveableComponent(PsiElement element) {
            if (element instanceof DartClassMembers) {
                return element.getFirstChild();
            }
            return element;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "info";
                    break;
                }
                case 3: 
                case 5: 
                case 8: 
                case 10: 
                case 11: 
                case 16: 
                case 17: 
                case 24: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "member";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/moveCode/DartComponentMover$CodeMover";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAttachedDeclaration";
                    break;
                }
                case 9: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findAttachedComment";
                    break;
                }
                case 12: 
                case 13: 
                case 14: 
                case 15: {
                    objectArray = objectArray2;
                    objectArray2[1] = "findFinalComment";
                    break;
                }
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    objectArray = objectArray2;
                    objectArray2[1] = "commentTypeOf";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "findCommentRange";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "memberRange";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "findAttachedDeclaration";
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    break;
                }
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "findAttachedComment";
                    break;
                }
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "nextSib";
                    break;
                }
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "findFinalComment";
                    break;
                }
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "isLineComment";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "commentTypeOf";
                    break;
                }
                case 24: {
                    objectArray = objectArray;
                    objectArray[2] = "isComment";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: 
                case 9: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static enum CommentType {
        SINGLE_LINE_COMMENT,
        MULTI_LINE_COMMENT,
        SINGLE_LINE_DOC_COMMENT,
        MULTI_LINE_DOC_COMMENT,
        INVALID,
        NONE;

    }
}

