/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.marker;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.codeInsight.daemon.impl.PsiElementListNavigator;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.DefaultPsiElementCellRenderer;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.actions.DartInheritorsSearcher;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.ListCellRenderer;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerImplementationsMarkerProvider
implements LineMarkerProvider {
    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(0);
        }
        if (result == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(1);
        }
    }

    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(2);
        }
        if (!(element instanceof DartComponentName)) {
            return null;
        }
        DartComponentName name = (DartComponentName)element;
        return DartServerImplementationsMarkerProvider.createMarker(name);
    }

    @Nullable
    private static LineMarkerInfo createMarker(@NotNull DartComponentName name) {
        if (name == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(3);
        }
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(name.getProject());
        VirtualFile file = name.getContainingFile().getVirtualFile();
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        int nameOffset = name.getTextRange().getStartOffset();
        int nameLength = name.getTextLength();
        if ("Object".equals(name.getName())) {
            return null;
        }
        for (DartServerData.DartRegion implementedClassRegion : service.getImplementedClasses(file)) {
            if (implementedClassRegion.getOffset() != nameOffset || implementedClassRegion.getLength() != nameLength) continue;
            return DartServerImplementationsMarkerProvider.createMarkerClass(name);
        }
        for (DartServerData.DartRegion implementedMemberRegion : service.getImplementedMembers(file)) {
            if (implementedMemberRegion.getOffset() != nameOffset || implementedMemberRegion.getLength() != nameLength) continue;
            return DartServerImplementationsMarkerProvider.createMarkerMember(name);
        }
        return null;
    }

    @NotNull
    private static LineMarkerInfo createMarkerClass(@NotNull DartComponentName name) {
        if (name == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(4);
        }
        VirtualFile file = name.getContainingFile().getVirtualFile();
        int nameOffset = name.getTextRange().getStartOffset();
        PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)name);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor, anchor.getTextRange(), AllIcons.Gutter.OverridenMethod, 11, element -> DaemonBundle.message((String)"class.is.subclassed.too.many", (Object[])new Object[0]), (e, __) -> {
            List<TypeHierarchyItem> items;
            if (name == null) {
                DartServerImplementationsMarkerProvider.$$$reportNull$$$0(9);
            }
            if ((items = DartAnalysisServerService.getInstance(name.getProject()).search_getTypeHierarchy(file, nameOffset, false)).isEmpty()) {
                return;
            }
            List<DartComponent> components = DartInheritorsSearcher.getSubClasses(name.getProject(), (SearchScope)GlobalSearchScope.allScope((Project)name.getProject()), items);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])DartResolveUtil.getComponentNameArray(components), (String)DaemonBundle.message((String)"navigation.title.subclass", (Object[])new Object[]{name.getName(), components.size(), ""}), (String)("Subclasses of " + name.getName()), (ListCellRenderer)new DefaultPsiElementCellRenderer());
        }, GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(5);
        }
        return lineMarkerInfo;
    }

    @NotNull
    private static LineMarkerInfo createMarkerMember(@NotNull DartComponentName name) {
        if (name == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(6);
        }
        VirtualFile file = name.getContainingFile().getVirtualFile();
        int nameOffset = name.getTextRange().getStartOffset();
        PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)name);
        LineMarkerInfo lineMarkerInfo = new LineMarkerInfo(anchor, anchor.getTextRange(), AllIcons.Gutter.OverridenMethod, 11, element -> DaemonBundle.message((String)"method.is.overridden.too.many", (Object[])new Object[0]), (e, __) -> {
            List<TypeHierarchyItem> items;
            if (name == null) {
                DartServerImplementationsMarkerProvider.$$$reportNull$$$0(8);
            }
            if ((items = DartAnalysisServerService.getInstance(name.getProject()).search_getTypeHierarchy(file, nameOffset, false)).isEmpty()) {
                return;
            }
            List<DartComponent> components = DartInheritorsSearcher.getSubMembers(name.getProject(), (SearchScope)GlobalSearchScope.allScope((Project)name.getProject()), items);
            PsiElementListNavigator.openTargets((MouseEvent)e, (NavigatablePsiElement[])DartResolveUtil.getComponentNameArray(components), (String)DaemonBundle.message((String)"navigation.title.overrider.method", (Object[])new Object[]{name.getName(), components.size()}), (String)("Overriding methods of " + name.getName()), (ListCellRenderer)new DefaultPsiElementCellRenderer());
        }, GutterIconRenderer.Alignment.RIGHT);
        if (lineMarkerInfo == null) {
            DartServerImplementationsMarkerProvider.$$$reportNull$$$0(7);
        }
        return lineMarkerInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/marker/DartServerImplementationsMarkerProvider";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkerClass";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createMarkerMember";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createMarker";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createMarkerClass";
                break;
            }
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createMarkerMember";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMarkerMember$3";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createMarkerClass$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

