/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.marker;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzerSettings;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProvider;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBody;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartIncompleteDeclaration;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import com.jetbrains.lang.dart.psi.impl.AbstractDartMethodDeclarationImpl;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartMethodLineMarkerProvider
implements LineMarkerProvider {
    private final DaemonCodeAnalyzerSettings myDaemonSettings;
    private final EditorColorsManager myColorsManager;

    public DartMethodLineMarkerProvider(DaemonCodeAnalyzerSettings daemonSettings, EditorColorsManager colorsManager) {
        this.myDaemonSettings = daemonSettings;
        this.myColorsManager = colorsManager;
    }

    @Nullable
    public LineMarkerInfo getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            DartMethodLineMarkerProvider.$$$reportNull$$$0(0);
        }
        if (!this.myDaemonSettings.SHOW_METHOD_SEPARATORS) {
            return null;
        }
        if (DartMethodLineMarkerProvider.isMarkableElement(element)) {
            if (PsiTreeUtil.findFirstParent((PsiElement)element, (boolean)true, DartMethodLineMarkerProvider::isMarkableElement) != null) {
                return null;
            }
            PsiElement markerLocation = element;
            while (markerLocation.getPrevSibling() != null && (markerLocation.getPrevSibling() instanceof PsiComment || markerLocation.getPrevSibling() instanceof PsiWhiteSpace && markerLocation.getPrevSibling().getPrevSibling() != null && markerLocation.getPrevSibling().getPrevSibling() instanceof PsiComment)) {
                markerLocation = markerLocation.getPrevSibling();
            }
            PsiElement prevElement = markerLocation;
            while (prevElement.getPrevSibling() != null && prevElement.getPrevSibling() instanceof PsiWhiteSpace) {
                prevElement = prevElement.getPrevSibling();
            }
            if (prevElement.getPrevSibling() == null) {
                return null;
            }
            PsiElement anchor = PsiTreeUtil.getDeepestFirst((PsiElement)markerLocation);
            LineMarkerInfo info = new LineMarkerInfo(anchor, anchor.getTextRange(), null, 11, (Function)FunctionUtil.nullConstant(), null, GutterIconRenderer.Alignment.RIGHT);
            EditorColorsScheme scheme = this.myColorsManager.getGlobalScheme();
            info.separatorColor = scheme.getColor(CodeInsightColors.METHOD_SEPARATORS_COLOR);
            info.separatorPlacement = SeparatorPlacement.TOP;
            return info;
        }
        return null;
    }

    private static boolean isMarkableElement(@NotNull PsiElement element) {
        if (element == null) {
            DartMethodLineMarkerProvider.$$$reportNull$$$0(1);
        }
        return element instanceof DartMethodDeclaration || element instanceof DartFunctionDeclarationWithBody || element instanceof DartFunctionDeclarationWithBodyOrNative || element instanceof DartGetterDeclaration || element instanceof DartSetterDeclaration || element instanceof DartFactoryConstructorDeclaration || element instanceof AbstractDartMethodDeclarationImpl || element instanceof DartNamedConstructorDeclaration || element instanceof DartIncompleteDeclaration;
    }

    public void collectSlowLineMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<LineMarkerInfo> result) {
        if (elements == null) {
            DartMethodLineMarkerProvider.$$$reportNull$$$0(2);
        }
        if (result == null) {
            DartMethodLineMarkerProvider.$$$reportNull$$$0(3);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/marker/DartMethodLineMarkerProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLineMarkerInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMarkableElement";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "collectSlowLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

