/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.inspections;

import com.intellij.CommonBundle;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.PlatformUtils;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartProjectComponent;
import com.jetbrains.lang.dart.ide.actions.DartPubGetAction;
import com.jetbrains.lang.dart.psi.PubspecYamlReferenceContributor;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import javax.swing.Icon;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLKeyValue;

public class DartPathPackageReferenceInspection
extends LocalInspectionTool {
    private static final String GROUP_DISPLAY_ID = "pubspec.yaml inspection";

    @NotNull
    public String getGroupDisplayName() {
        String string = DartBundle.message("inspections.group.name", new Object[0]);
        if (string == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = DartBundle.message("path.package.reference.inspection.name", new Object[0]);
        if (string == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(2);
        }
        if (!"pubspec.yaml".equals(holder.getFile().getName())) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                DartPathPackageReferenceInspection.$$$reportNull$$$0(3);
            }
            return psiElementVisitor;
        }
        final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)holder.getFile());
        DartSdk sdk = DartSdk.getDartSdk(holder.getProject());
        if (module == null || sdk == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            PsiElementVisitor psiElementVisitor = super.buildVisitor(holder, isOnTheFly);
            if (psiElementVisitor == null) {
                DartPathPackageReferenceInspection.$$$reportNull$$$0(4);
            }
            return psiElementVisitor;
        }
        PsiElementVisitor psiElementVisitor = new PsiElementVisitor(){

            public void visitElement(PsiElement element) {
                ProgressIndicatorProvider.checkCanceled();
                if (!(element instanceof YAMLKeyValue) || !PubspecYamlReferenceContributor.isPathPackageDefinition((YAMLKeyValue)element) || ((YAMLKeyValue)element).getValue() == null) {
                    return;
                }
                VirtualFile packageDir = DartPathPackageReferenceInspection.checkReferences(holder, (YAMLKeyValue)element);
                if (packageDir == null) {
                    return;
                }
                if (packageDir.findChild("pubspec.yaml") == null) {
                    String message = DartBundle.message("pubspec.yaml.not.found.in", FileUtil.toSystemDependentName((String)packageDir.getPath()));
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), message, new LocalQuickFix[0]);
                    return;
                }
                VirtualFile file = DartResolveUtil.getRealVirtualFile(element.getContainingFile());
                if (file != null && packageDir.equals(file.getParent())) {
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), DartBundle.message("path.package.reference.to.itself", new Object[0]), new LocalQuickFix[0]);
                    return;
                }
                VirtualFile libDir = packageDir.findChild("lib");
                if (libDir != null && libDir.isDirectory() && !ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex().isInContent(libDir)) {
                    String message = DartBundle.message("folder.0.not.in.project.content", FileUtil.toSystemDependentName((String)packageDir.getPath()));
                    holder.registerProblem((PsiElement)((YAMLKeyValue)element).getValue(), message, new LocalQuickFix[]{new AddContentRootFix(module, packageDir)});
                }
            }
        };
        if (psiElementVisitor == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(5);
        }
        return psiElementVisitor;
    }

    @Nullable
    private static VirtualFile checkReferences(@NotNull ProblemsHolder holder, @NotNull YAMLKeyValue element) {
        if (holder == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(6);
        }
        if (element == null) {
            DartPathPackageReferenceInspection.$$$reportNull$$$0(7);
        }
        for (PsiReference reference : element.getReferences()) {
            VirtualFile dir;
            if (!(reference instanceof FileReference) || reference.isSoft()) continue;
            PsiFileSystemItem resolve = ((FileReference)reference).resolve();
            if (resolve == null) {
                holder.registerProblem(reference.getElement(), ((FileReference)reference).getUnresolvedMessagePattern(), ProblemHighlightType.GENERIC_ERROR, reference.getRangeInElement(), new LocalQuickFix[0]);
                return null;
            }
            if (!((FileReference)reference).isLast() || (dir = resolve.getVirtualFile()) == null || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    private static void openProjectRootsConfigurable(Module module) {
        if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm() || PlatformUtils.isPyCharm() || PlatformUtils.isRubyMine()) {
            ShowSettingsUtil.getInstance().showSettingsDialog(module.getProject(), DartPathPackageReferenceInspection.getProjectRootsConfigurableName());
        } else {
            ProjectSettingsService.getInstance((Project)module.getProject()).openContentEntriesSettings(module);
        }
    }

    private static String getProjectRootsConfigurableName() {
        if (PlatformUtils.isWebStorm() || PlatformUtils.isPhpStorm()) {
            return "Directories";
        }
        if (PlatformUtils.isRubyMine()) {
            return "Project Structure";
        }
        if (PlatformUtils.isPyCharm()) {
            return "Project Structure";
        }
        return "Project Structure";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupDisplayName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildVisitor";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "checkReferences";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class AddContentRootFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final Module myModule;
        @NotNull
        private final VirtualFile myContentRoot;

        private AddContentRootFix(@NotNull Module module, @NotNull VirtualFile contentRoot) {
            if (module == null) {
                AddContentRootFix.$$$reportNull$$$0(0);
            }
            if (contentRoot == null) {
                AddContentRootFix.$$$reportNull$$$0(1);
            }
            this.myModule = module;
            this.myContentRoot = contentRoot;
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("configure.folder.0.as.content.root", FileUtil.toSystemDependentName((String)this.myContentRoot.getPath()));
            if (string == null) {
                AddContentRootFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = DartBundle.message("configure.folder.as.content.root", new Object[0]);
            if (string == null) {
                AddContentRootFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void applyFix(@NotNull Project project, PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                AddContentRootFix.$$$reportNull$$$0(4);
            }
            try {
                AddContentRootFix.checkCanAddContentRoot(this.myModule, this.myContentRoot);
            }
            catch (Exception e) {
                AddContentRootFix.showErrorDialog(this.myModule, e);
                return;
            }
            ModifiableRootModel modifiableModel = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            try {
                modifiableModel.addContentEntry(this.myContentRoot);
                ApplicationManager.getApplication().runWriteAction(() -> ((ModifiableRootModel)modifiableModel).commit());
                VirtualFile otherPubspec = this.myContentRoot.findChild("pubspec.yaml");
                if (otherPubspec != null) {
                    DartProjectComponent.excludeBuildAndPackagesFolders(this.myModule, otherPubspec);
                    AnAction pubGetAction = ActionManager.getInstance().getAction("Dart.pub.get");
                    if (pubGetAction instanceof DartPubGetAction) {
                        ((DartPubGetAction)pubGetAction).performPubAction(this.myModule, otherPubspec, false);
                    }
                }
                AddContentRootFix.showSuccessNotification(this.myModule, this.myContentRoot);
            }
            catch (Exception e) {
                AddContentRootFix.showErrorDialog(this.myModule, e);
            }
            finally {
                if (!modifiableModel.isDisposed()) {
                    modifiableModel.dispose();
                }
            }
            VirtualFile yamlFile = DartResolveUtil.getRealVirtualFile(psiFile);
            if (yamlFile != null && "pubspec.yaml".equals(yamlFile.getName())) {
                DartProjectComponent.excludeBuildAndPackagesFolders(this.myModule, yamlFile);
            }
        }

        private static void showSuccessNotification(final @NotNull Module module, @NotNull VirtualFile root) {
            if (module == null) {
                AddContentRootFix.$$$reportNull$$$0(5);
            }
            if (root == null) {
                AddContentRootFix.$$$reportNull$$$0(6);
            }
            String title = DartBundle.message("content.root.added.title", new Object[0]);
            String message = DartSdkLibUtil.isIdeWithMultipleModuleSupport() ? DartBundle.message("content.root.added.to.module", module.getName(), FileUtil.toSystemDependentName((String)root.getPath())) : DartBundle.message("content.root.added.to.project", FileUtil.toSystemDependentName((String)root.getPath()), CommonBundle.settingsTitle(), DartPathPackageReferenceInspection.getProjectRootsConfigurableName());
            Notifications.Bus.notify((Notification)new Notification(DartPathPackageReferenceInspection.GROUP_DISPLAY_ID, title, message, NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    DartPathPackageReferenceInspection.openProjectRootsConfigurable(module);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            }));
        }

        private static void showErrorDialog(@NotNull Module module, @NotNull Exception e) {
            if (module == null) {
                AddContentRootFix.$$$reportNull$$$0(7);
            }
            if (e == null) {
                AddContentRootFix.$$$reportNull$$$0(8);
            }
            String message = DartBundle.message("can.not.add.content.root", e.getMessage());
            String title = DartBundle.message("add.content.root.title", new Object[0]);
            String okText = DartBundle.message("configure.project.roots", new Object[0]);
            String cancelText = CommonBundle.getCancelButtonText();
            int choice = Messages.showOkCancelDialog((Project)module.getProject(), (String)message, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getWarningIcon());
            if (choice == 0) {
                DartPathPackageReferenceInspection.openProjectRootsConfigurable(module);
            }
        }

        private static void checkCanAddContentRoot(@NotNull Module module, @NotNull VirtualFile contentRoot) throws Exception {
            if (module == null) {
                AddContentRootFix.$$$reportNull$$$0(9);
            }
            if (contentRoot == null) {
                AddContentRootFix.$$$reportNull$$$0(10);
            }
            for (VirtualFile virtualFile : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
                if (virtualFile.equals(contentRoot)) {
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.already.exists.error", (Object[])new Object[]{contentRoot.getPresentableUrl()}));
                }
                if (VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)contentRoot, (boolean)true)) {
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.intersect.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getPresentableUrl()}));
                }
                if (!VfsUtilCore.isAncestor((VirtualFile)contentRoot, (VirtualFile)virtualFile, (boolean)true)) continue;
                throw new Exception(ProjectBundle.message((String)"module.paths.add.content.dominate.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getPresentableUrl()}));
            }
            for (VirtualFile virtualFile : ModuleManager.getInstance((Project)module.getProject()).getModules()) {
                if (module.equals(virtualFile)) continue;
                for (VirtualFile moduleContentRoot : ModuleRootManager.getInstance((Module)virtualFile).getContentRoots()) {
                    if (!contentRoot.equals(moduleContentRoot)) continue;
                    throw new Exception(ProjectBundle.message((String)"module.paths.add.content.duplicate.error", (Object[])new Object[]{contentRoot.getPresentableUrl(), virtualFile.getName()}));
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "module";
                    break;
                }
                case 1: 
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "contentRoot";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartPathPackageReferenceInspection$AddContentRootFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "showSuccessNotification";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "showErrorDialog";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "checkCanAddContentRoot";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

