/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.inspections;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.IntentionAndQuickFixAction;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.flutter.FlutterUtil;
import com.jetbrains.lang.dart.ide.actions.DartPubActionBase;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import gnu.trove.THashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartOutdatedDependenciesInspection
extends LocalInspectionTool {
    private final Set<String> myIgnoredPubspecPaths = new THashSet();

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile psiFile, @NotNull InspectionManager manager, boolean isOnTheFly) {
        if (psiFile == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(1);
        }
        if (!isOnTheFly) {
            return null;
        }
        if (!(psiFile instanceof DartFile)) {
            return null;
        }
        if (DartPubActionBase.isInProgress()) {
            return null;
        }
        VirtualFile file = DartResolveUtil.getRealVirtualFile(psiFile);
        if (file == null || !file.isInLocalFileSystem()) {
            return null;
        }
        Project project = psiFile.getProject();
        if (!ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) {
            return null;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
        if (module == null || sdk == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            return null;
        }
        if (FlutterUtil.isFlutterPluginInstalled() && FlutterUtil.isFlutterModule(module)) {
            return null;
        }
        VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
        if (pubspecFile == null || this.myIgnoredPubspecPaths.contains(pubspecFile.getPath())) {
            return null;
        }
        String projectName = PubspecYamlUtil.getDartProjectName(pubspecFile);
        if (projectName == null || !StringUtil.isJavaIdentifier((String)projectName)) {
            return null;
        }
        VirtualFile dotPackagesFile = pubspecFile.getParent().findChild(".packages");
        if (dotPackagesFile == null) {
            return this.createProblemDescriptors(manager, psiFile, pubspecFile, DartBundle.message("pub.get.never.done", new Object[0]));
        }
        if (FileDocumentManager.getInstance().isFileModified(pubspecFile) || pubspecFile.getTimeStamp() > dotPackagesFile.getTimeStamp()) {
            return this.createProblemDescriptors(manager, psiFile, pubspecFile, DartBundle.message("pubspec.edited", new Object[0]));
        }
        return null;
    }

    @NotNull
    private ProblemDescriptor[] createProblemDescriptors(@NotNull InspectionManager manager, @NotNull PsiFile psiFile, @NotNull VirtualFile pubspecFile, @NotNull String errorMessage) {
        if (manager == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(2);
        }
        if (psiFile == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(3);
        }
        if (pubspecFile == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(4);
        }
        if (errorMessage == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(5);
        }
        LocalQuickFix[] fixes = new LocalQuickFix[]{new RunPubFix(DartBundle.message("get.dependencies", new Object[0]), "Dart.pub.get"), new RunPubFix(DartBundle.message("upgrade.dependencies", new Object[0]), "Dart.pub.upgrade"), new OpenPubspecFix(), new IgnoreWarningFix(this.myIgnoredPubspecPaths, pubspecFile.getPath())};
        ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{manager.createProblemDescriptor((PsiElement)psiFile, errorMessage, true, fixes, ProblemHighlightType.GENERIC_ERROR_OR_WARNING)};
        if (problemDescriptorArray == null) {
            DartOutdatedDependenciesInspection.$$$reportNull$$$0(6);
        }
        return problemDescriptorArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pubspecFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProblemDescriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkFile";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProblemDescriptors";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class IgnoreWarningFix
    extends IntentionAndQuickFixAction {
        @NotNull
        private final Set<String> myIgnoredPubspecPaths;
        @NotNull
        private final String myPubspecPath;

        public IgnoreWarningFix(@NotNull Set<String> ignoredPubspecPaths, @NotNull String pubspecPath) {
            if (ignoredPubspecPaths == null) {
                IgnoreWarningFix.$$$reportNull$$$0(0);
            }
            if (pubspecPath == null) {
                IgnoreWarningFix.$$$reportNull$$$0(1);
            }
            this.myIgnoredPubspecPaths = ignoredPubspecPaths;
            this.myPubspecPath = pubspecPath;
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("ignore.warning", new Object[0]);
            if (string == null) {
                IgnoreWarningFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                IgnoreWarningFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            if (project == null) {
                IgnoreWarningFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                IgnoreWarningFix.$$$reportNull$$$0(5);
            }
            this.myIgnoredPubspecPaths.add(this.myPubspecPath);
            DaemonCodeAnalyzer.getInstance((Project)project).restart();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignoredPubspecPaths";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pubspecPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$IgnoreWarningFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class OpenPubspecFix
    extends IntentionAndQuickFixAction {
        private OpenPubspecFix() {
        }

        @NotNull
        public String getName() {
            String string = DartBundle.message("open.pubspec", new Object[0]);
            if (string == null) {
                OpenPubspecFix.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                OpenPubspecFix.$$$reportNull$$$0(1);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            VirtualFile file;
            if (project == null) {
                OpenPubspecFix.$$$reportNull$$$0(2);
            }
            if (psiFile == null) {
                OpenPubspecFix.$$$reportNull$$$0(3);
            }
            if ((file = DartResolveUtil.getRealVirtualFile(psiFile)) == null || !file.isInLocalFileSystem()) {
                return;
            }
            VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
            if (pubspecFile == null) {
                return;
            }
            new OpenFileDescriptor(project, pubspecFile).navigate(true);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$OpenPubspecFix";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static class RunPubFix
    extends IntentionAndQuickFixAction {
        private final String myFixName;
        private final String myActionId;

        private RunPubFix(@NotNull String fixName, @NotNull String actionId) {
            if (fixName == null) {
                RunPubFix.$$$reportNull$$$0(0);
            }
            if (actionId == null) {
                RunPubFix.$$$reportNull$$$0(1);
            }
            this.myFixName = fixName;
            this.myActionId = actionId;
        }

        @NotNull
        public String getName() {
            String string = this.myFixName;
            if (string == null) {
                RunPubFix.$$$reportNull$$$0(2);
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                RunPubFix.$$$reportNull$$$0(3);
            }
            return string;
        }

        public boolean startInWriteAction() {
            return false;
        }

        public void applyFix(@NotNull Project project, @NotNull PsiFile psiFile, @Nullable Editor editor) {
            VirtualFile file;
            if (project == null) {
                RunPubFix.$$$reportNull$$$0(4);
            }
            if (psiFile == null) {
                RunPubFix.$$$reportNull$$$0(5);
            }
            if ((file = DartResolveUtil.getRealVirtualFile(psiFile)) == null || !file.isInLocalFileSystem()) {
                return;
            }
            VirtualFile pubspecFile = PubspecYamlUtil.findPubspecYamlFile(project, file);
            if (pubspecFile == null) {
                return;
            }
            Module module = ModuleUtilCore.findModuleForFile((VirtualFile)file, (Project)project);
            if (module == null) {
                return;
            }
            AnAction pubGetAction = ActionManager.getInstance().getAction(this.myActionId);
            if (pubGetAction instanceof DartPubActionBase) {
                ((DartPubActionBase)pubGetAction).performPubAction(module, pubspecFile, false);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fixName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "actionId";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "psiFile";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/inspections/DartOutdatedDependenciesInspection$RunPubFix";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "applyFix";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

