/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.info;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.info.DartFunctionDescription;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartMetadata;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartParameterInfoHandler
implements ParameterInfoHandler<PsiElement, DartFunctionDescription> {
    private String myParametersListPresentableText = "";

    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        PsiElement element;
        DartComponentType type;
        Object o = item.getObject();
        if (o instanceof PsiElement && ((type = DartComponentType.typeOf((element = (PsiElement)o).getParent())) == DartComponentType.METHOD || type == DartComponentType.CONSTRUCTOR)) {
            return new Object[]{element.getParent()};
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public Object[] getParametersForDocumentation(DartFunctionDescription p, ParameterInfoContext context) {
        return p.getParameters();
    }

    @Nullable
    public PsiElement findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(0);
        }
        PsiElement contextElement = context.getFile().findElementAt(context.getEditor().getCaretModel().getOffset());
        return DartParameterInfoHandler.findElementForParameterInfo(contextElement);
    }

    @Nullable
    public static PsiElement findElementForParameterInfo(@Nullable PsiElement contextElement) {
        PsiElement parent;
        DartArguments arguments = (DartArguments)PsiTreeUtil.getParentOfType((PsiElement)contextElement, DartArguments.class);
        PsiElement psiElement = parent = arguments == null ? null : arguments.getParent();
        if (parent instanceof DartCallExpression || parent instanceof DartNewExpression || parent instanceof DartMetadata) {
            return parent;
        }
        return null;
    }

    public PsiElement findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(1);
        }
        return context.getFile().findElementAt(context.getEditor().getCaretModel().getOffset());
    }

    public void showParameterInfo(@NotNull PsiElement element, @NotNull CreateParameterInfoContext context) {
        DartReferenceExpression refExpression;
        PsiElement target;
        if (element == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (context == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(3);
        }
        DartFunctionDescription functionDescription = null;
        if (element instanceof DartCallExpression) {
            functionDescription = DartFunctionDescription.tryGetDescription((DartCallExpression)element);
        } else if (element instanceof DartNewExpression) {
            PsiElement target2;
            DartNewExpression newExpression = (DartNewExpression)element;
            DartType type = newExpression.getType();
            DartClassResolveResult classResolveResult = DartResolveUtil.resolveClassByType(type);
            DartReferenceExpression psiElement = ((DartNewExpression)element).getReferenceExpression();
            psiElement = psiElement == null && type != null ? type.getReferenceExpression() : psiElement;
            PsiElement psiElement2 = target2 = psiElement != null ? ((DartReference)psiElement).resolve() : null;
            if (target2 instanceof DartComponentName) {
                functionDescription = DartFunctionDescription.createDescription((DartComponent)target2.getParent(), classResolveResult);
            }
        } else if (element instanceof DartMetadata && (target = (refExpression = ((DartMetadata)element).getReferenceExpression()).resolve()) instanceof DartComponentName) {
            functionDescription = DartFunctionDescription.createDescription((DartComponent)target.getParent(), refExpression.resolveDartClass());
        }
        if (functionDescription != null) {
            context.setItemsToShow(new Object[]{functionDescription});
            context.showHint(element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
    }

    public void updateParameterInfo(@NotNull PsiElement place, @NotNull UpdateParameterInfoContext context) {
        if (place == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(5);
        }
        int parameterIndex = DartResolveUtil.getArgumentIndex(place);
        context.setCurrentParameter(parameterIndex);
        if (context.getParameterOwner() == null) {
            context.setParameterOwner(place);
        } else if (context.getParameterOwner() != DartParameterInfoHandler.findElementForParameterInfo(place)) {
            context.removeHint();
            return;
        }
        Object[] objects = context.getObjectsToView();
        for (int i = 0; i < objects.length; ++i) {
            context.setUIComponentEnabled(i, true);
        }
    }

    public String getParameterCloseChars() {
        return ",){}";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(DartFunctionDescription p, @NotNull ParameterInfoUIContext context) {
        if (context == null) {
            DartParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (p == null) {
            context.setUIComponentEnabled(false);
            return;
        }
        this.myParametersListPresentableText = p.getParametersListPresentableText();
        if (this.myParametersListPresentableText != null && this.myParametersListPresentableText.length() == 0) {
            this.myParametersListPresentableText = CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
        }
        context.setupUIComponentPresentation(this.myParametersListPresentableText, p.getParameterRange(context.getCurrentParameterIndex()).getStartOffset(), p.getParameterRange(context.getCurrentParameterIndex()).getEndOffset(), !context.isUIComponentEnabled(), false, false, context.getDefaultParameterColor());
    }

    public String getParametersListPresentableText() {
        assert (ApplicationManager.getApplication().isUnitTestMode());
        return this.myParametersListPresentableText;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/info/DartParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

