/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.info;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartDefaultFormalNamedParameter;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFormalParameterList;
import com.jetbrains.lang.dart.psi.DartOptionalFormalParameters;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartOptionalParameterDescription {
    private final String myText;
    @Nullable
    private final String myValue;
    private boolean myIsPositional;

    public DartOptionalParameterDescription(@NotNull String text, @Nullable String value, boolean isPositional) {
        if (text == null) {
            DartOptionalParameterDescription.$$$reportNull$$$0(0);
        }
        this.myText = text;
        this.myValue = value;
        this.myIsPositional = isPositional;
    }

    public static DartOptionalParameterDescription[] getParameters(DartComponent element, DartGenericSpecialization specialization) {
        DartOptionalFormalParameters optionalFormalParameters;
        DartFormalParameterList parameterList = (DartFormalParameterList)PsiTreeUtil.getChildOfType((PsiElement)element, DartFormalParameterList.class);
        DartOptionalFormalParameters dartOptionalFormalParameters = optionalFormalParameters = parameterList == null ? null : parameterList.getOptionalFormalParameters();
        if (optionalFormalParameters == null) {
            return new DartOptionalParameterDescription[0];
        }
        List<DartDefaultFormalNamedParameter> list = optionalFormalParameters.getDefaultFormalNamedParameterList();
        DartOptionalParameterDescription[] result = new DartOptionalParameterDescription[list.size()];
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            DartDefaultFormalNamedParameter formalNamedParameter = list.get(i);
            String normalFormalParameter = DartPresentableUtil.getPresentableNormalFormalParameter(formalNamedParameter.getNormalFormalParameter(), specialization);
            DartExpression valueElement = formalNamedParameter.getExpression();
            result[i] = new DartOptionalParameterDescription(normalFormalParameter, valueElement == null ? null : valueElement.getText(), DartOptionalParameterDescription.isPositional(formalNamedParameter));
        }
        return result;
    }

    private static boolean isPositional(DartDefaultFormalNamedParameter parameter) {
        DartOptionalFormalParameters formalParameters = (DartOptionalFormalParameters)PsiTreeUtil.getParentOfType((PsiElement)parameter, DartOptionalFormalParameters.class);
        if (formalParameters == null) {
            return false;
        }
        PsiElement firstChild = formalParameters.getFirstChild();
        return firstChild != null && "[".equals(firstChild.getText());
    }

    public String toString() {
        if (this.myValue == null) {
            return this.myText;
        }
        return this.myText + (this.isPositional() ? " = " : ": ") + this.myValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DartOptionalParameterDescription that = (DartOptionalParameterDescription)o;
        return !this.myText.equals(that.myText);
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isPositional() {
        return this.myIsPositional;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/jetbrains/lang/dart/ide/info/DartOptionalParameterDescription", "<init>"));
    }
}

