/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.info;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.ide.info.DartOptionalParameterDescription;
import com.jetbrains.lang.dart.ide.info.DartParameterDescription;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.util.DartClassResolveResult;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartFunctionDescription {
    private final String name;
    private final String returnType;
    @NotNull
    private final DartParameterDescription[] myParameters;
    @NotNull
    private final DartOptionalParameterDescription[] myOptionalParameters;

    public DartFunctionDescription(String name, String type, @NotNull DartParameterDescription[] parameters, @NotNull DartOptionalParameterDescription[] optionalParameters) {
        if (parameters == null) {
            DartFunctionDescription.$$$reportNull$$$0(0);
        }
        if (optionalParameters == null) {
            DartFunctionDescription.$$$reportNull$$$0(1);
        }
        this.name = name;
        this.returnType = type;
        this.myParameters = parameters;
        this.myOptionalParameters = optionalParameters;
    }

    public String getName() {
        return this.name;
    }

    public String getReturnType() {
        return this.returnType;
    }

    @NotNull
    public DartParameterDescription[] getParameters() {
        if (this.myParameters == null) {
            DartFunctionDescription.$$$reportNull$$$0(2);
        }
        return this.myParameters;
    }

    public String getParametersListPresentableText() {
        StringBuilder result = new StringBuilder();
        for (DartParameterDescription parameterDescription : this.myParameters) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(parameterDescription.toString());
        }
        if (this.myOptionalParameters.length > 0) {
            String[] stringArray;
            if (this.myOptionalParameters[0].isPositional()) {
                String[] stringArray2 = new String[2];
                stringArray2[0] = "[";
                stringArray = stringArray2;
                stringArray2[1] = "]";
            } else {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "{";
                stringArray = stringArray3;
                stringArray3[1] = "}";
            }
            String[] braces = stringArray;
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(braces[0]);
            int length = this.myOptionalParameters.length;
            for (int i = 0; i < length; ++i) {
                DartOptionalParameterDescription namedParameterDescription = this.myOptionalParameters[i];
                if (i > 0) {
                    result.append(", ");
                }
                result.append(namedParameterDescription.toString());
            }
            result.append(braces[1]);
        }
        return result.toString();
    }

    public TextRange getParameterRange(int index) {
        int i;
        if (index == -1) {
            return new TextRange(0, 0);
        }
        int startOffset = 0;
        int length = this.myParameters.length;
        for (i = 0; i < length; ++i) {
            if (i == index) {
                int shift = i == 0 ? 0 : ", ".length();
                return new TextRange(startOffset + shift, startOffset + shift + this.myParameters[i].toString().length());
            }
            if (i > 0) {
                startOffset += ", ".length();
            }
            startOffset += this.myParameters[i].toString().length();
        }
        startOffset += this.myParameters.length > 0 ? ", [".length() : "[".length();
        length = this.myOptionalParameters.length;
        for (i = 0; i < length; ++i) {
            if (i + this.myParameters.length == index) {
                int shift = i == 0 ? 0 : ", ".length();
                return new TextRange(startOffset + shift, startOffset + shift + this.myOptionalParameters[i].toString().length());
            }
            if (i > 0) {
                startOffset += ", ".length();
            }
            startOffset += this.myOptionalParameters[i].toString().length();
        }
        return new TextRange(0, 0);
    }

    @Nullable
    public static DartFunctionDescription tryGetDescription(DartCallExpression callExpression) {
        DartComponent callMethod;
        DartClassResolveResult resolveResult;
        DartClass dartClass;
        Object targetParent;
        DartReference expression = (DartReference)callExpression.getExpression();
        Object target = expression.resolve();
        PsiElement psiElement = targetParent = target == null ? null : target.getParent();
        if ((target == null || targetParent instanceof DartVarAccessDeclaration || targetParent instanceof DartGetterDeclaration) && (dartClass = (resolveResult = expression.resolveDartClass()).getDartClass()) != null && (callMethod = dartClass.findMethodByName("call")) != null) {
            target = callMethod.getComponentName();
            targetParent = callMethod;
        }
        if (target instanceof DartComponentName && targetParent instanceof DartComponent) {
            DartReference[] references = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)expression, DartReference.class);
            DartClassResolveResult resolveResult2 = references != null && references.length == 2 ? references[0].resolveDartClass() : DartClassResolveResult.create((DartClass)PsiTreeUtil.getParentOfType((PsiElement)callExpression, DartClass.class));
            return DartFunctionDescription.createDescription((DartComponent)targetParent, resolveResult2);
        }
        return null;
    }

    public static DartFunctionDescription createDescription(DartComponent namedComponent, DartClassResolveResult resolveResult) {
        DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)namedComponent, DartReturnType.class);
        DartType dartType = (DartType)PsiTreeUtil.getChildOfType((PsiElement)namedComponent, DartType.class);
        String typeText = returnType == null ? DartPresentableUtil.buildTypeText(namedComponent, dartType, resolveResult.getSpecialization()) : DartPresentableUtil.buildTypeText(namedComponent, returnType, resolveResult.getSpecialization());
        return new DartFunctionDescription(namedComponent.getName(), typeText, DartParameterDescription.getParameters(namedComponent, resolveResult.getSpecialization()), DartOptionalParameterDescription.getParameters(namedComponent, resolveResult.getSpecialization()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "optionalParameters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/info/DartFunctionDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/info/DartFunctionDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

