/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartVarDeclarationList;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartSymbolIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_SYMBOL_INDEX = ID.create((String)"DartSymbolIndex");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_SYMBOL_INDEX;
        if (iD == null) {
            DartSymbolIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            DartSymbolIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DartSymbolIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            DartSymbolIndex.$$$reportNull$$$0(3);
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static String[] getAllSymbols(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            DartSymbolIndex.$$$reportNull$$$0(4);
        }
        CommonProcessors.CollectProcessor processor = new CommonProcessors.CollectProcessor();
        FileBasedIndex.getInstance().processAllKeys(DART_SYMBOL_INDEX, (Processor)processor, scope, null);
        return ArrayUtil.toStringArray((Collection)processor.getResults());
    }

    public static List<DartComponentName> getItemsByName(@NotNull String name, @NotNull Project project, @NotNull GlobalSearchScope searchScope) {
        if (name == null) {
            DartSymbolIndex.$$$reportNull$$$0(5);
        }
        if (project == null) {
            DartSymbolIndex.$$$reportNull$$$0(6);
        }
        if (searchScope == null) {
            DartSymbolIndex.$$$reportNull$$$0(7);
        }
        Collection files = FileBasedIndex.getInstance().getContainingFiles(DART_SYMBOL_INDEX, (Object)name, searchScope);
        THashSet result = new THashSet();
        for (VirtualFile vFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
                DartSymbolIndex.processComponents(root, (PsiElementProcessor<DartComponent>)((PsiElementProcessor)arg_0 -> DartSymbolIndex.lambda$getItemsByName$0(name, (Set)result, arg_0)));
            }
        }
        return new ArrayList<DartComponentName>((Collection<DartComponentName>)result);
    }

    private static void processComponents(PsiElement context, PsiElementProcessor<DartComponent> processor) {
        DartVarDeclarationList[] varLists;
        DartComponent[] components = (DartComponent[])PsiTreeUtil.getChildrenOfType((PsiElement)context, DartComponent.class);
        if (components != null) {
            for (DartComponent component : components) {
                if (DartSymbolIndex.processComponent(processor, component)) continue;
                return;
            }
        }
        if ((varLists = (DartVarDeclarationList[])PsiTreeUtil.getChildrenOfType((PsiElement)context, DartVarDeclarationList.class)) != null) {
            for (DartVarDeclarationList varList : varLists) {
                if (!DartSymbolIndex.processComponent(processor, varList.getVarAccessDeclaration())) {
                    return;
                }
                for (DartVarDeclarationListPart part : varList.getVarDeclarationListPartList()) {
                    if (DartSymbolIndex.processComponent(processor, part)) continue;
                    return;
                }
            }
        }
    }

    private static boolean processComponent(PsiElementProcessor<DartComponent> processor, DartComponent component) {
        String componentName = component.getName();
        if (componentName == null) {
            return true;
        }
        if (!processor.execute((PsiElement)component)) {
            return false;
        }
        if (component instanceof DartClass) {
            for (DartComponent subComponent : DartResolveUtil.getNamedSubComponents((DartClass)component)) {
                if (subComponent.isConstructor() && componentName.equals(subComponent.getName()) || processor.execute((PsiElement)subComponent)) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ boolean lambda$getItemsByName$0(@NotNull String name, Set result, DartComponent component) {
        if (name == null) {
            DartSymbolIndex.$$$reportNull$$$0(8);
        }
        if (name.equals(component.getName())) {
            result.add(component.getComponentName());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartSymbolIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchScope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartSymbolIndex";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllSymbols";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getItemsByName";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getItemsByName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            List<String> symbols = DartIndexUtil.indexFile(inputData).getSymbols();
            THashMap result = new THashMap();
            for (String symbol : symbols) {
                result.put(symbol, null);
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                MyDataIndexer.$$$reportNull$$$0(1);
            }
            return tHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartSymbolIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartSymbolIndex$MyDataIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

