/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.BidirectionalMap;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.ide.index.DartFileIndexData;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartArgumentList;
import com.jetbrains.lang.dart.psi.DartArguments;
import com.jetbrains.lang.dart.psi.DartExpression;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.psi.DartMapLiteralEntry;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartLibraryIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_LIBRARY_INDEX = ID.create((String)"DartLibraryIndex");
    private static final Key<Pair<Long, BidirectionalMap<String, String>>> LIBRARIES_TIME_AND_MAP_KEY = Key.create((String)"dart.internal.libraries");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_LIBRARY_INDEX;
        if (iD == null) {
            DartLibraryIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            DartLibraryIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DartLibraryIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            DartLibraryIndex.$$$reportNull$$$0(3);
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<VirtualFile> getFilesByLibName(@NotNull GlobalSearchScope scope, @NotNull String libraryName) {
        if (scope == null) {
            DartLibraryIndex.$$$reportNull$$$0(4);
        }
        if (libraryName == null) {
            DartLibraryIndex.$$$reportNull$$$0(5);
        }
        return FileBasedIndex.getInstance().getContainingFiles(DART_LIBRARY_INDEX, (Object)libraryName, scope);
    }

    @Nullable
    public static String getSdkLibUriByRelativePath(@NotNull Project project, @NotNull String relativePath) {
        DartSdk sdk;
        if (project == null) {
            DartLibraryIndex.$$$reportNull$$$0(6);
        }
        if (relativePath == null) {
            DartLibraryIndex.$$$reportNull$$$0(7);
        }
        List libNames = (sdk = DartSdk.getDartSdk(project)) == null ? null : DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdk.getHomePath()).getKeysByValue((Object)relativePath);
        return libNames == null || libNames.isEmpty() ? null : (String)libNames.get(0);
    }

    @Nullable
    public static VirtualFile getSdkLibByUri(@NotNull Project project, @NotNull String sdkLibUri) {
        DartSdk sdk;
        if (project == null) {
            DartLibraryIndex.$$$reportNull$$$0(8);
        }
        if (sdkLibUri == null) {
            DartLibraryIndex.$$$reportNull$$$0(9);
        }
        String relativeLibPath = (sdk = DartSdk.getDartSdk(project)) == null ? null : (String)DartLibraryIndex.getSdkLibUriToRelativePathMap(project, sdk.getHomePath()).get((Object)sdkLibUri);
        return relativeLibPath == null ? null : LocalFileSystem.getInstance().findFileByPath(sdk.getHomePath() + "/lib/" + relativeLibPath);
    }

    @NotNull
    public static BidirectionalMap<String, String> getSdkLibUriToRelativePathMap(@NotNull Project project, @NotNull String sdkHomePath) {
        VirtualFile librariesDartFile;
        if (project == null) {
            DartLibraryIndex.$$$reportNull$$$0(10);
        }
        if (sdkHomePath == null) {
            DartLibraryIndex.$$$reportNull$$$0(11);
        }
        if ((librariesDartFile = LocalFileSystem.getInstance().findFileByPath(sdkHomePath + "/lib/_internal/libraries.dart")) == null) {
            librariesDartFile = LocalFileSystem.getInstance().findFileByPath(sdkHomePath + "/lib/_internal/sdk_library_metadata/lib/libraries.dart");
        }
        if (librariesDartFile == null) {
            BidirectionalMap bidirectionalMap = new BidirectionalMap();
            if (bidirectionalMap == null) {
                DartLibraryIndex.$$$reportNull$$$0(12);
            }
            return bidirectionalMap;
        }
        Pair data = (Pair)librariesDartFile.getUserData(LIBRARIES_TIME_AND_MAP_KEY);
        Long cachedTimestamp = data == null ? null : (Long)data.first;
        long modificationCount = librariesDartFile.getModificationCount();
        if (cachedTimestamp != null && cachedTimestamp.equals(modificationCount)) {
            BidirectionalMap bidirectionalMap = (BidirectionalMap)data.second;
            if (bidirectionalMap == null) {
                DartLibraryIndex.$$$reportNull$$$0(13);
            }
            return bidirectionalMap;
        }
        VirtualFile finalLibrariesDartFile = librariesDartFile;
        BidirectionalMap bidirectionalMap = (BidirectionalMap)ReadAction.compute(() -> {
            if (project == null) {
                DartLibraryIndex.$$$reportNull$$$0(16);
            }
            try {
                String contents = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)finalLibrariesDartFile));
                PsiFile psiFile = PsiFileFactory.getInstance((Project)project).createFileFromText("libraries.dart", DartLanguage.INSTANCE, (CharSequence)contents);
                if (!(psiFile instanceof DartFile)) {
                    return new BidirectionalMap();
                }
                Pair data1 = Pair.create((Object)modificationCount, DartLibraryIndex.computeSdkLibUriToRelativePathMap((DartFile)psiFile));
                finalLibrariesDartFile.putUserData(LIBRARIES_TIME_AND_MAP_KEY, (Object)data1);
                return (BidirectionalMap)data1.second;
            }
            catch (IOException e) {
                return new BidirectionalMap();
            }
        });
        if (bidirectionalMap == null) {
            DartLibraryIndex.$$$reportNull$$$0(14);
        }
        return bidirectionalMap;
    }

    private static BidirectionalMap<String, String> computeSdkLibUriToRelativePathMap(@NotNull DartFile librariesDartFile) {
        if (librariesDartFile == null) {
            DartLibraryIndex.$$$reportNull$$$0(15);
        }
        final BidirectionalMap result = new BidirectionalMap();
        librariesDartFile.acceptChildren(new DartRecursiveVisitor(){

            @Override
            public void visitMapLiteralEntry(@NotNull DartMapLiteralEntry mapLiteralEntry) {
                String libraryRelativePath;
                List<DartExpression> expressions;
                if (mapLiteralEntry == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((expressions = mapLiteralEntry.getExpressionList()).size() != 2 || !(expressions.get(0) instanceof DartStringLiteralExpression) || !(expressions.get(1) instanceof DartNewExpression)) {
                    return;
                }
                DartStringLiteralExpression keyExpression = (DartStringLiteralExpression)expressions.get(0);
                DartNewExpression newExpression = (DartNewExpression)expressions.get(1);
                String libraryName = StringUtil.unquoteString((String)keyExpression.getText());
                DartType dartType = newExpression.getType();
                if (dartType == null || !"LibraryInfo".equals(dartType.getText())) {
                    return;
                }
                DartArguments arguments = newExpression.getArguments();
                DartArgumentList argumentList = arguments != null ? arguments.getArgumentList() : null;
                List<DartExpression> expressionList = argumentList != null ? argumentList.getExpressionList() : null;
                DartExpression firstExpression = expressionList == null || expressionList.isEmpty() ? null : expressionList.get(0);
                String string = libraryRelativePath = firstExpression instanceof DartStringLiteralExpression ? StringUtil.unquoteString((String)firstExpression.getText()) : null;
                if (libraryRelativePath != null) {
                    String libraryUri = "dart:" + libraryName;
                    result.put((Object)libraryUri, (Object)libraryRelativePath);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapLiteralEntry", "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$1", "visitMapLiteralEntry"));
            }
        });
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartLibraryIndex";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkLibUri";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdkHomePath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "librariesDartFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartLibraryIndex";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getSdkLibUriToRelativePathMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByLibName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getSdkLibUriByRelativePath";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSdkLibByUri";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getSdkLibUriToRelativePathMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSdkLibUriToRelativePathMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getSdkLibUriToRelativePathMap$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 15: 
            case 16: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            DartFileIndexData indexData;
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            Map<String, Void> map = (indexData = DartIndexUtil.indexFile(inputData)).isPart() ? Collections.emptyMap() : Collections.singletonMap(indexData.getLibraryName(), null);
            if (map == null) {
                MyDataIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartLibraryIndex$MyDataIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

