/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexExtension;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.IOUtil;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartImportOrExportInfo;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import gnu.trove.THashSet;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DartImportAndExportIndex
extends FileBasedIndexExtension<String, List<DartImportOrExportInfo>> {
    public static final ID<String, List<DartImportOrExportInfo>> DART_IMPORT_EXPORT_INDEX = ID.create((String)"DartImportIndex");
    private DataIndexer<String, List<DartImportOrExportInfo>, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, List<DartImportOrExportInfo>> getName() {
        ID<String, List<DartImportOrExportInfo>> iD = DART_IMPORT_EXPORT_INDEX;
        if (iD == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, List<DartImportOrExportInfo>, FileContent> getIndexer() {
        DataIndexer<String, List<DartImportOrExportInfo>, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public DataExternalizer<List<DartImportOrExportInfo>> getValueExternalizer() {
        DataExternalizer<List<DartImportOrExportInfo>> dataExternalizer = new DataExternalizer<List<DartImportOrExportInfo>>(){

            public void save(@NotNull DataOutput out, @NotNull List<DartImportOrExportInfo> value) throws IOException {
                if (out == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (value == null) {
                    1.$$$reportNull$$$0(1);
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.size());
                for (DartImportOrExportInfo importOrExportInfo : value) {
                    IOUtil.writeUTF((DataOutput)out, (String)importOrExportInfo.getKind().name());
                    IOUtil.writeUTF((DataOutput)out, (String)importOrExportInfo.getUri());
                    IOUtil.writeUTF((DataOutput)out, (String)StringUtil.notNullize((String)importOrExportInfo.getImportPrefix()));
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)importOrExportInfo.getShowComponents().size());
                    for (String showComponentName : importOrExportInfo.getShowComponents()) {
                        IOUtil.writeUTF((DataOutput)out, (String)showComponentName);
                    }
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)importOrExportInfo.getHideComponents().size());
                    for (String hideComponentName : importOrExportInfo.getHideComponents()) {
                        IOUtil.writeUTF((DataOutput)out, (String)hideComponentName);
                    }
                }
            }

            @NotNull
            public List<DartImportOrExportInfo> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    1.$$$reportNull$$$0(2);
                }
                int size = DataInputOutputUtil.readINT((DataInput)in);
                ArrayList<DartImportOrExportInfo> result = new ArrayList<DartImportOrExportInfo>(size);
                for (int i = 0; i < size; ++i) {
                    DartImportOrExportInfo.Kind kind = DartImportOrExportInfo.Kind.valueOf(IOUtil.readUTF((DataInput)in));
                    String uri = IOUtil.readUTF((DataInput)in);
                    String prefix = IOUtil.readUTF((DataInput)in);
                    int showSize = DataInputOutputUtil.readINT((DataInput)in);
                    THashSet showComponentNames = showSize == 0 ? Collections.emptySet() : new THashSet(showSize);
                    for (int j = 0; j < showSize; ++j) {
                        showComponentNames.add(IOUtil.readUTF((DataInput)in));
                    }
                    int hideSize = DataInputOutputUtil.readINT((DataInput)in);
                    THashSet hideComponentNames = hideSize == 0 ? Collections.emptySet() : new THashSet(hideSize);
                    for (int j = 0; j < hideSize; ++j) {
                        hideComponentNames.add(IOUtil.readUTF((DataInput)in));
                    }
                    result.add(new DartImportOrExportInfo(kind, uri, StringUtil.nullize((String)prefix), (Set<String>)showComponentNames, (Set<String>)hideComponentNames));
                }
                ArrayList<DartImportOrExportInfo> arrayList = result;
                if (arrayList == null) {
                    1.$$$reportNull$$$0(3);
                }
                return arrayList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 3: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 3: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "out";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "value";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "in";
                        break;
                    }
                    case 3: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$1";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[1] = "read";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "save";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "read";
                        break;
                    }
                    case 3: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 3: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (dataExternalizer == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(3);
        }
        return dataExternalizer;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(4);
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    @NotNull
    public static List<DartImportOrExportInfo> getImportAndExportInfos(@NotNull Project project, @NotNull VirtualFile virtualFile) {
        if (project == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(5);
        }
        if (virtualFile == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(6);
        }
        ArrayList<DartImportOrExportInfo> result = new ArrayList<DartImportOrExportInfo>();
        for (List list : FileBasedIndex.getInstance().getValues(DART_IMPORT_EXPORT_INDEX, (Object)virtualFile.getName(), GlobalSearchScope.fileScope((Project)project, (VirtualFile)virtualFile))) {
            result.addAll(list);
        }
        ArrayList<DartImportOrExportInfo> arrayList = result;
        if (arrayList == null) {
            DartImportAndExportIndex.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "virtualFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueExternalizer";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getImportAndExportInfos";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImportAndExportInfos";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyDataIndexer
    implements DataIndexer<String, List<DartImportOrExportInfo>, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, List<DartImportOrExportInfo>> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            Map<String, List<DartImportOrExportInfo>> map = Collections.singletonMap(inputData.getFileName(), DartIndexUtil.indexFile(inputData).getImportAndExportInfos());
            if (map == null) {
                MyDataIndexer.$$$reportNull$$$0(1);
            }
            return map;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartImportAndExportIndex$MyDataIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

