/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.IOUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.index.DartComponentInfo;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartComponentInfoListExternalizer
implements DataExternalizer<List<DartComponentInfo>> {
    public void save(@NotNull DataOutput out, @NotNull List<DartComponentInfo> infos) throws IOException {
        if (out == null) {
            DartComponentInfoListExternalizer.$$$reportNull$$$0(0);
        }
        if (infos == null) {
            DartComponentInfoListExternalizer.$$$reportNull$$$0(1);
        }
        DataInputOutputUtil.writeINT((DataOutput)out, (int)infos.size());
        for (DartComponentInfo componentInfo : infos) {
            DartComponentType dartComponentType = componentInfo.getComponentType();
            int key = dartComponentType == null ? -1 : dartComponentType.getKey();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)key);
            String libraryName = componentInfo.getLibraryName();
            out.writeBoolean(libraryName != null);
            if (libraryName == null) continue;
            IOUtil.writeUTF((DataOutput)out, (String)libraryName);
        }
    }

    public List<DartComponentInfo> read(@NotNull DataInput in) throws IOException {
        int size;
        if (in == null) {
            DartComponentInfoListExternalizer.$$$reportNull$$$0(2);
        }
        if ((size = DataInputOutputUtil.readINT((DataInput)in)) == 0) {
            return Collections.emptyList();
        }
        ArrayList<DartComponentInfo> result = new ArrayList<DartComponentInfo>(size);
        for (int i = 0; i < size; ++i) {
            int componentTypeKey = DataInputOutputUtil.readINT((DataInput)in);
            boolean hasLibraryName = in.readBoolean();
            String libraryName = hasLibraryName ? IOUtil.readUTF((DataInput)in) : null;
            result.add(new DartComponentInfo(DartComponentType.valueOf(componentTypeKey), libraryName));
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "out";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartComponentInfoListExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "save";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "read";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

