/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.index;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.indexing.DataIndexer;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileContent;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.ScalarIndexExtension;
import com.intellij.util.io.EnumeratorStringDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.jetbrains.lang.dart.ide.index.DartFileIndexData;
import com.jetbrains.lang.dart.ide.index.DartIndexUtil;
import com.jetbrains.lang.dart.ide.index.DartInputFilter;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class DartClassIndex
extends ScalarIndexExtension<String> {
    public static final ID<String, Void> DART_CLASS_INDEX = ID.create((String)"DartClassIndex");
    private DataIndexer<String, Void, FileContent> myDataIndexer = new MyDataIndexer();

    @NotNull
    public ID<String, Void> getName() {
        ID<String, Void> iD = DART_CLASS_INDEX;
        if (iD == null) {
            DartClassIndex.$$$reportNull$$$0(0);
        }
        return iD;
    }

    public int getVersion() {
        return 23;
    }

    @NotNull
    public DataIndexer<String, Void, FileContent> getIndexer() {
        DataIndexer<String, Void, FileContent> dataIndexer = this.myDataIndexer;
        if (dataIndexer == null) {
            DartClassIndex.$$$reportNull$$$0(1);
        }
        return dataIndexer;
    }

    @NotNull
    public KeyDescriptor<String> getKeyDescriptor() {
        EnumeratorStringDescriptor enumeratorStringDescriptor = EnumeratorStringDescriptor.INSTANCE;
        if (enumeratorStringDescriptor == null) {
            DartClassIndex.$$$reportNull$$$0(2);
        }
        return enumeratorStringDescriptor;
    }

    @NotNull
    public FileBasedIndex.InputFilter getInputFilter() {
        DartInputFilter dartInputFilter = DartInputFilter.INSTANCE;
        if (dartInputFilter == null) {
            DartClassIndex.$$$reportNull$$$0(3);
        }
        return dartInputFilter;
    }

    public boolean dependsOnFileContent() {
        return true;
    }

    public static Collection<String> getNames(Project project) {
        return FileBasedIndex.getInstance().getAllKeys(DART_CLASS_INDEX, project);
    }

    public static List<DartComponentName> getItemsByName(String name, Project project, GlobalSearchScope searchScope) {
        Collection files = FileBasedIndex.getInstance().getContainingFiles(DART_CLASS_INDEX, (Object)name, searchScope);
        THashSet result = new THashSet();
        for (VirtualFile vFile : files) {
            PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(vFile);
            for (PsiElement root : DartResolveUtil.findDartRoots(psiFile)) {
                for (DartClass component : DartResolveUtil.getClassDeclarations(root)) {
                    if (!name.equals(component.getName())) continue;
                    result.add(component.getComponentName());
                }
            }
        }
        return new ArrayList<DartComponentName>((Collection<DartComponentName>)result);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/lang/dart/ide/index/DartClassIndex";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexer";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getKeyDescriptor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputFilter";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyDataIndexer
    implements DataIndexer<String, Void, FileContent> {
        private MyDataIndexer() {
        }

        @NotNull
        public Map<String, Void> map(@NotNull FileContent inputData) {
            if (inputData == null) {
                MyDataIndexer.$$$reportNull$$$0(0);
            }
            DartFileIndexData indexData = DartIndexUtil.indexFile(inputData);
            THashMap result = new THashMap();
            for (String componentName : indexData.getClassNames()) {
                result.put(componentName, null);
            }
            THashMap tHashMap = result;
            if (tHashMap == null) {
                MyDataIndexer.$$$reportNull$$$0(1);
            }
            return tHashMap;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "inputData";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/index/DartClassIndex$MyDataIndexer";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/index/DartClassIndex$MyDataIndexer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "map";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "map";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

