/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.imports;

import com.intellij.lang.ImportOptimizer;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartImportOptimizer
implements ImportOptimizer {
    @NotNull
    public Runnable processFile(final PsiFile file) {
        DartAnalysisServerService.getInstance(file.getProject()).serverReadyForRequest(file.getProject());
        ImportOptimizer.CollectingInfoRunnable collectingInfoRunnable = new ImportOptimizer.CollectingInfoRunnable(){
            private boolean myFileChanged = false;

            public void run() {
                VirtualFile vFile = DartResolveUtil.getRealVirtualFile(file);
                if (vFile != null) {
                    String filePath = vFile.getPath();
                    SourceFileEdit fileEdit = DartAnalysisServerService.getInstance(file.getProject()).edit_organizeDirectives(filePath);
                    if (fileEdit != null && AssistUtils.applyFileEdit(file.getProject(), fileEdit)) {
                        this.myFileChanged = true;
                        Document document = PsiDocumentManager.getInstance((Project)file.getProject()).getDocument(file);
                        if (document != null) {
                            PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(document);
                        }
                    }
                }
            }

            @Nullable
            public String getUserNotificationInfo() {
                return this.myFileChanged ? DartBundle.message("organized.directives", new Object[0]) : null;
            }
        };
        if (collectingInfoRunnable == null) {
            DartImportOptimizer.$$$reportNull$$$0(0);
        }
        return collectingInfoRunnable;
    }

    public boolean supports(PsiFile file) {
        return file instanceof DartFile;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/lang/dart/ide/imports/DartImportOptimizer", "processFile"));
    }
}

