/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.type;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerSubtypesHierarchyTreeStructure;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartTypeHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DartServerTypeHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final String myCurrentScopeType;

    public DartServerTypeHierarchyTreeStructure(Project project, DartClass dartClass, String currentScopeType) {
        super(project, DartServerTypeHierarchyTreeStructure.buildHierarchyElement(project, dartClass));
        this.myCurrentScopeType = currentScopeType;
        this.setBaseElement(this.myBaseDescriptor);
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descriptor) {
        if (descriptor == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(1);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    @NotNull
    private static HierarchyNodeDescriptor buildHierarchyElement(@NotNull Project project, @NotNull DartClass dartClass) {
        if (project == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(2);
        }
        if (dartClass == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(3);
        }
        if ("Object".equals(dartClass.getName())) {
            DartTypeHierarchyNodeDescriptor dartTypeHierarchyNodeDescriptor = new DartTypeHierarchyNodeDescriptor(project, null, dartClass, true);
            if (dartTypeHierarchyNodeDescriptor == null) {
                DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(4);
            }
            return dartTypeHierarchyNodeDescriptor;
        }
        List<TypeHierarchyItem> items = DartHierarchyUtil.getTypeHierarchyItems(dartClass);
        HierarchyNodeDescriptor superDescriptor = DartServerTypeHierarchyTreeStructure.buildSuperClassHierarchy(project, items);
        DartTypeHierarchyNodeDescriptor baseDescriptor = new DartTypeHierarchyNodeDescriptor(project, superDescriptor, dartClass, true);
        if (superDescriptor != null) {
            superDescriptor.setCachedChildren((Object[])new HierarchyNodeDescriptor[]{baseDescriptor});
        }
        if (!items.isEmpty()) {
            DartServerSubtypesHierarchyTreeStructure.addSubClassHierarchy(Sets.newHashSet(), project, items, items.get(0), baseDescriptor);
        }
        DartTypeHierarchyNodeDescriptor dartTypeHierarchyNodeDescriptor = baseDescriptor;
        if (dartTypeHierarchyNodeDescriptor == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        return dartTypeHierarchyNodeDescriptor;
    }

    @Nullable
    private static HierarchyNodeDescriptor buildSuperClassHierarchy(@NotNull Project project, @NotNull List<TypeHierarchyItem> items) {
        if (project == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        if (items == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(7);
        }
        DartTypeHierarchyNodeDescriptor descriptor = null;
        DartClass[] superClasses = DartServerTypeHierarchyTreeStructure.filterSuperClasses(project, items);
        for (int i = superClasses.length - 1; i >= 0; --i) {
            DartClass superClass = superClasses[i];
            DartTypeHierarchyNodeDescriptor newDescriptor = new DartTypeHierarchyNodeDescriptor(project, descriptor, superClass, false);
            if (descriptor != null) {
                descriptor.setCachedChildren(new HierarchyNodeDescriptor[]{newDescriptor});
            }
            descriptor = newDescriptor;
        }
        return descriptor;
    }

    @NotNull
    public static DartClass[] filterSuperClasses(@NotNull Project project, @NotNull List<TypeHierarchyItem> items) {
        TypeHierarchyItem superItem;
        if (project == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        if (items == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(9);
        }
        if (items.isEmpty()) {
            DartClass[] dartClassArray = new DartClass[]{};
            if (dartClassArray == null) {
                DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(10);
            }
            return dartClassArray;
        }
        HashSet seenItems = Sets.newHashSet();
        ArrayList superClasses = Lists.newArrayList();
        Integer superIndex = items.get(0).getSuperclass();
        while (superIndex != null && seenItems.add(superItem = items.get(superIndex))) {
            DartClass superClass = DartHierarchyUtil.findDartClass(project, superItem);
            if (superClass != null) {
                superClasses.add(superClass);
            }
            superIndex = superItem.getSuperclass();
        }
        DartClass[] dartClassArray = superClasses.toArray(new DartClass[superClasses.size()]);
        if (dartClassArray == null) {
            DartServerTypeHierarchyTreeStructure.$$$reportNull$$$0(11);
        }
        return dartClassArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure";
                break;
            }
            case 2: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/hierarchy/type/DartServerTypeHierarchyTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHierarchyElement";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterSuperClasses";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "buildHierarchyElement";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildSuperClassHierarchy";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "filterSuperClasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

