/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.method;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.ide.hierarchy.HierarchyBrowserManager;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.jetbrains.lang.dart.ide.hierarchy.DartHierarchyUtil;
import com.jetbrains.lang.dart.ide.hierarchy.method.DartMethodHierarchyNodeDescriptor;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class DartMethodHierarchyTreeStructure
extends HierarchyTreeStructure {
    private final SmartPsiElementPointer myMethod;

    public DartMethodHierarchyTreeStructure(Project project, DartComponent element) {
        super(project, null);
        DartClass baseClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class);
        this.myBaseDescriptor = new DartMethodHierarchyNodeDescriptor(project, null, (PsiElement)baseClass, true, this);
        this.setBaseElement(this.myBaseDescriptor);
        ((DartMethodHierarchyNodeDescriptor)this.myBaseDescriptor).setTreeStructure(this);
        this.myMethod = SmartPointerManager.getInstance((Project)this.myProject).createSmartPsiElementPointer((PsiElement)element);
    }

    @NotNull
    protected Object[] buildChildren(@NotNull HierarchyNodeDescriptor descript) {
        DartMethodHierarchyNodeDescriptor descriptor;
        DartClass dartClass;
        if (descript == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(0);
        }
        if ((dartClass = (descriptor = (DartMethodHierarchyNodeDescriptor)descript).getType()) == null) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                DartMethodHierarchyTreeStructure.$$$reportNull$$$0(1);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        List<TypeHierarchyItem> items = DartHierarchyUtil.getTypeHierarchyItems(dartClass);
        if (items.isEmpty()) {
            if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                DartMethodHierarchyTreeStructure.$$$reportNull$$$0(2);
            }
            return ArrayUtil.EMPTY_OBJECT_ARRAY;
        }
        this.addAllVisibleSubclasses(Sets.newHashSet(), this.myProject, items, items.get(0), descriptor);
        Object[] objectArray = descriptor.getCachedChildren();
        if (objectArray == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(3);
        }
        return objectArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllVisibleSubclasses(@NotNull Set<TypeHierarchyItem> stackItems, @NotNull Project project, @NotNull List<TypeHierarchyItem> items, @NotNull TypeHierarchyItem item, @NotNull DartMethodHierarchyNodeDescriptor descriptor) {
        if (stackItems == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(4);
        }
        if (project == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(5);
        }
        if (items == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(6);
        }
        if (item == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(7);
        }
        if (descriptor == null) {
            DartMethodHierarchyTreeStructure.$$$reportNull$$$0(8);
        }
        if (!stackItems.add(item)) {
            descriptor.setCachedChildren(ArrayUtil.EMPTY_OBJECT_ARRAY);
            return;
        }
        HierarchyBrowserManager.State state = HierarchyBrowserManager.getInstance((Project)this.myProject).getState();
        if (state == null) {
            throw new NullPointerException();
        }
        ArrayList subDescriptors = Lists.newArrayList();
        try {
            DartComponent method;
            for (int index : item.getSubclasses()) {
                TypeHierarchyItem subItem = items.get(index);
                DartClass subclass = DartHierarchyUtil.findDartClass(project, subItem);
                if (subclass == null) continue;
                DartMethodHierarchyNodeDescriptor subDescriptor = new DartMethodHierarchyNodeDescriptor(project, (NodeDescriptor)descriptor, (PsiElement)subclass, false, this);
                subDescriptors.add(subDescriptor);
                this.addAllVisibleSubclasses(stackItems, project, items, subItem, subDescriptor);
            }
            DartClass dartClass = DartHierarchyUtil.findDartClass(project, item);
            assert (dartClass != null);
            String methodName = this.getBaseMethod().getName();
            if (methodName != null && (method = dartClass.findMethodByName(methodName)) != null) {
                DartClass definingClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)method, DartClass.class);
                if (definingClass == dartClass) {
                    descriptor.myIsImplementor = true;
                } else {
                    descriptor.myShouldImplement = method.isAbstract() && !dartClass.isAbstract();
                }
            }
            for (DartMethodHierarchyNodeDescriptor subDescriptor : subDescriptors) {
                if (!subDescriptor.myIsSuperclassOfImplementor && !subDescriptor.myIsImplementor) continue;
                descriptor.myIsSuperclassOfImplementor = true;
                break;
            }
            if (state.HIDE_CLASSES_WHERE_METHOD_NOT_IMPLEMENTED) {
                ArrayList toRemove = Lists.newArrayList();
                for (DartMethodHierarchyNodeDescriptor subDescriptor : subDescriptors) {
                    if (subDescriptor.myIsSuperclassOfImplementor || subDescriptor.myIsImplementor) continue;
                    toRemove.add(subDescriptor);
                }
                subDescriptors.removeAll(toRemove);
            }
        }
        finally {
            stackItems.remove(item);
        }
        descriptor.setCachedChildren(subDescriptors.toArray(new HierarchyNodeDescriptor[subDescriptors.size()]));
    }

    private DartComponent getBaseMethod() {
        return (DartComponent)this.myMethod.getElement();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descript";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyTreeStructure";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackItems";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/hierarchy/method/DartMethodHierarchyTreeStructure";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildChildren";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addAllVisibleSubclasses";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

