/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.call;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.roots.ui.util.CompositeAppearance;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import org.jetbrains.annotations.NotNull;

public class DartHierarchyNodeDescriptor
extends HierarchyNodeDescriptor {
    public DartHierarchyNodeDescriptor(NodeDescriptor parentDescriptor, @NotNull PsiElement element, boolean isBase) {
        if (element == null) {
            DartHierarchyNodeDescriptor.$$$reportNull$$$0(0);
        }
        super(element.getProject(), parentDescriptor, element, isBase);
    }

    public boolean update() {
        boolean changes = super.update();
        CompositeAppearance oldText = this.myHighlightedText;
        this.myHighlightedText = new CompositeAppearance();
        NavigatablePsiElement element = (NavigatablePsiElement)this.getPsiElement();
        if (element == null) {
            return this.invalidElement();
        }
        ItemPresentation presentation = element.getPresentation();
        if (presentation != null) {
            DartClass cls;
            if (element instanceof DartMethodDeclaration && DartComponentType.typeOf((PsiElement)element) != DartComponentType.CONSTRUCTOR && (cls = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)element, DartClass.class)) != null) {
                this.myHighlightedText.getEnding().addText(cls.getName() + ".");
            }
            this.myHighlightedText.getEnding().addText(presentation.getPresentableText());
            PsiFile file = element.getContainingFile();
            if (file != null) {
                this.myHighlightedText.getEnding().addText(" (" + file.getName() + ")", HierarchyNodeDescriptor.getPackageNameAttributes());
            }
        }
        this.myName = this.myHighlightedText.getText();
        if (!Comparing.equal((Object)this.myHighlightedText, (Object)oldText)) {
            changes = true;
        }
        return changes;
    }

    private boolean invalidElement() {
        String invalidPrefix = IdeBundle.message((String)"node.hierarchy.invalid", (Object[])new Object[0]);
        if (!this.myHighlightedText.getText().startsWith(invalidPrefix)) {
            this.myHighlightedText.getBeginning().addText(invalidPrefix, HierarchyNodeDescriptor.getInvalidPrefixAttributes());
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/hierarchy/call/DartHierarchyNodeDescriptor", "<init>"));
    }
}

