/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.hierarchy.call;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.ide.hierarchy.call.DartCallHierarchyTreeStructure;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartRecursiveVisitor;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.resolve.DartResolver;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartCalleeTreeStructure
extends DartCallHierarchyTreeStructure {
    public DartCalleeTreeStructure(Project project, PsiElement element, String currentScopeType) {
        super(project, element, currentScopeType);
    }

    private static void getCallees(@NotNull PsiElement element, @NotNull List<PsiElement> results) {
        DartComponentName name;
        DartComponent decl;
        PsiFile file;
        if (element == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(0);
        }
        if (results == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(1);
        }
        if ((file = (decl = (DartComponent)(name = (DartComponentName)element).getParent()).getContainingFile()) == null) {
            return;
        }
        VirtualFile vFile = file.getVirtualFile();
        List<DartServerData.DartNavigationRegion> navRegions = DartAnalysisServerService.getInstance(element.getProject()).analysis_getNavigation(vFile, decl.getTextOffset(), decl.getTextLength());
        if (navRegions == null) {
            return;
        }
        DartCalleeTreeStructure.resolveReferences(decl, navRegions, results);
    }

    private static void resolveReferences(@NotNull DartComponent component, final @NotNull List<DartServerData.DartNavigationRegion> regions, final @NotNull List<PsiElement> results) {
        if (component == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(2);
        }
        if (regions == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(3);
        }
        if (results == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(4);
        }
        component.acceptChildren(new DartRecursiveVisitor(){

            @Override
            public void visitReferenceExpression(@NotNull DartReferenceExpression reference) {
                if (reference == null) {
                    1.$$$reportNull$$$0(0);
                }
                int offset = reference.getTextOffset();
                List targets = DartCalleeTreeStructure.getRegionAt(offset, regions);
                for (DartServerData.DartNavigationTarget target : targets) {
                    PsiElement element;
                    if (!DartCalleeTreeStructure.isExecutable(target) || (element = DartCalleeTreeStructure.getDeclaration(target, (PsiElement)reference)) == null) continue;
                    results.add(element);
                }
                super.visitReferenceExpression(reference);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure$1", "visitReferenceExpression"));
            }
        });
    }

    private static boolean isExecutable(DartServerData.DartNavigationTarget target) {
        String kind = target.getKind();
        return "METHOD".equals(kind) || "FUNCTION".equals(kind) || "GETTER".equals(kind) || "SETTER".equals(kind) || "CONSTRUCTOR".equals(kind);
    }

    private static PsiElement getDeclaration(DartServerData.DartNavigationTarget target, PsiElement reference) {
        PsiElement found = DartResolver.getElementForNavigationTarget(reference.getProject(), target);
        return found == null ? null : found.getParent();
    }

    @NotNull
    private static List<DartServerData.DartNavigationTarget> getRegionAt(int offset, @NotNull List<DartServerData.DartNavigationRegion> regions) {
        if (regions == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(5);
        }
        for (DartServerData.DartNavigationRegion region : regions) {
            int targetStart = region.getOffset();
            int targetEnd = targetStart + region.getLength();
            if (offset < targetStart || offset > targetEnd) continue;
            List<DartServerData.DartNavigationTarget> list = region.getTargets();
            if (list == null) {
                DartCalleeTreeStructure.$$$reportNull$$$0(6);
            }
            return list;
        }
        ArrayList<DartServerData.DartNavigationTarget> arrayList = new ArrayList<DartServerData.DartNavigationTarget>(0);
        if (arrayList == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected List<PsiElement> getChildren(@NotNull PsiElement element) {
        if (element == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(8);
        }
        ArrayList<PsiElement> list = new ArrayList<PsiElement>();
        DartCalleeTreeStructure.getCallees(element, list);
        ArrayList<PsiElement> arrayList = list;
        if (arrayList == null) {
            DartCalleeTreeStructure.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "results";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regions";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/hierarchy/call/DartCalleeTreeStructure";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getRegionAt";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getCallees";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "resolveReferences";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getRegionAt";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

