/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.psi.DartVarDeclarationListPart;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import org.jetbrains.annotations.NotNull;

public class OverrideImplementMethodFix
extends BaseCreateMethodsFix<DartComponent> {
    final boolean myImplementNotOverride;

    public OverrideImplementMethodFix(@NotNull DartClass dartClass, boolean implementNotOverride) {
        if (dartClass == null) {
            OverrideImplementMethodFix.$$$reportNull$$$0(0);
        }
        super(dartClass);
        this.myImplementNotOverride = implementNotOverride;
    }

    @Override
    @NotNull
    protected String getNothingFoundMessage() {
        String string = DartBundle.message(this.myImplementNotOverride ? "dart.fix.implement.none.found" : "dart.fix.override.none.found", new Object[0]);
        if (string == null) {
            OverrideImplementMethodFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Override
    protected Template buildFunctionsText(TemplateManager templateManager, DartComponent element) {
        boolean isField;
        Template template = templateManager.createTemplate(this.getClass().getName(), "Dart");
        template.setToReformat(true);
        if (CodeStyleSettingsManager.getSettings((Project)element.getProject()).INSERT_OVERRIDE_ANNOTATION) {
            template.addTextSegment("@override\n");
        }
        boolean bl = isField = element instanceof DartVarAccessDeclaration || element instanceof DartVarDeclarationListPart;
        if (isField && element.isFinal()) {
            template.addTextSegment("final");
            template.addTextSegment(" ");
        }
        DartReturnType returnType = (DartReturnType)PsiTreeUtil.getChildOfType((PsiElement)element, DartReturnType.class);
        DartType dartType = (DartType)PsiTreeUtil.getChildOfType((PsiElement)element, DartType.class);
        if (returnType != null) {
            template.addTextSegment(DartPresentableUtil.buildTypeText(element, returnType, this.specializations));
            template.addTextSegment(" ");
        } else if (dartType != null) {
            template.addTextSegment(DartPresentableUtil.buildTypeText(element, dartType, this.specializations));
            template.addTextSegment(" ");
        }
        if (isField) {
            if (returnType == null && dartType == null) {
                template.addTextSegment("var");
                template.addTextSegment(" ");
            }
            template.addTextSegment(element.getName());
            if (element.isFinal()) {
                template.addTextSegment(" ");
                template.addTextSegment("=");
                template.addTextSegment(" ");
                template.addTextSegment("null");
            }
            template.addTextSegment("; ");
            return template;
        }
        if (element.isOperator()) {
            template.addTextSegment("operator ");
        }
        if (element.isGetter() || element.isSetter()) {
            template.addTextSegment(element.isGetter() ? "get " : "set ");
        }
        template.addTextSegment(element.getName());
        if (!element.isGetter()) {
            template.addTextSegment("(");
            template.addTextSegment(DartPresentableUtil.getPresentableParameterList(element, this.specializations, false, true, true));
            template.addTextSegment(")");
        }
        template.addTextSegment("{\n");
        template.addEndVariable();
        template.addTextSegment("\n} ");
        return template;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/generation/OverrideImplementMethodFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/generation/OverrideImplementMethodFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNothingFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

