/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.ide.generation.DartGenerateEqualsAndHashcodeAction;
import com.jetbrains.lang.dart.ide.hierarchy.type.DartServerTypeHierarchyTreeStructure;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import java.util.List;
import java.util.Set;
import org.dartlang.analysis.server.protocol.TypeHierarchyItem;
import org.jetbrains.annotations.NotNull;

public class CreateEqualsAndHashcodeFix
extends BaseCreateMethodsFix<DartComponent> {
    private boolean mySuperclassOverridesEqualEqualAndHashCode;

    public CreateEqualsAndHashcodeFix(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(0);
        }
        super(dartClass);
    }

    @Override
    public void beforeInvoke(@NotNull Project project, Editor editor, PsiElement file) {
        if (project == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(1);
        }
        super.beforeInvoke(project, editor, file);
        this.mySuperclassOverridesEqualEqualAndHashCode = CreateEqualsAndHashcodeFix.doesSuperclassOverrideEqualEqualAndHashCode(this.myDartClass);
    }

    @Override
    protected void processElements(@NotNull Project project, @NotNull Editor editor, @NotNull Set<DartComponent> elementsToProcess) {
        if (project == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(3);
        }
        if (elementsToProcess == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(4);
        }
        TemplateManager templateManager = TemplateManager.getInstance((Project)project);
        this.anchor = this.doAddMethodsForOne(editor, templateManager, this.buildFunctionsText(templateManager, elementsToProcess), this.anchor);
    }

    @Override
    @NotNull
    protected String getNothingFoundMessage() {
        if ("" == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(5);
        }
        return "";
    }

    private static boolean doesSuperclassOverrideEqualEqualAndHashCode(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(6);
        }
        Project project = dartClass.getProject();
        VirtualFile file = dartClass.getContainingFile().getVirtualFile();
        DartComponentName name = dartClass.getComponentName();
        if (name == null) {
            return false;
        }
        List<TypeHierarchyItem> items = DartAnalysisServerService.getInstance(dartClass.getProject()).search_getTypeHierarchy(file, name.getTextRange().getStartOffset(), true);
        for (DartClass superClass : DartServerTypeHierarchyTreeStructure.filterSuperClasses(project, items)) {
            if (superClass == null || superClass.getName() == null || superClass.getName().equals("Object") || !DartGenerateEqualsAndHashcodeAction.doesClassContainEqualsAndHashCode(superClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Template buildFunctionsText(TemplateManager templateManager, @NotNull Set<DartComponent> elementsToProcess) {
        if (elementsToProcess == null) {
            CreateEqualsAndHashcodeFix.$$$reportNull$$$0(7);
        }
        Template template = templateManager.createTemplate(this.getClass().getName(), "Dart");
        template.setToReformat(true);
        boolean doInsertOverrideAnnotation = CodeStyleSettingsManager.getSettings((Project)this.myDartClass.getProject()).INSERT_OVERRIDE_ANNOTATION;
        if (doInsertOverrideAnnotation) {
            template.addTextSegment("@override\n");
        }
        template.addTextSegment("bool operator==(Object other) =>\nidentical(this, other) ||\n");
        if (this.mySuperclassOverridesEqualEqualAndHashCode) {
            template.addTextSegment("super == other &&\n");
        }
        template.addTextSegment("other is " + this.myDartClass.getName() + " &&\n");
        template.addTextSegment("runtimeType == other.runtimeType");
        for (DartComponent component : elementsToProcess) {
            template.addTextSegment(" &&\n");
            template.addTextSegment(component.getName() + " == other." + component.getName());
        }
        template.addTextSegment(";\n");
        if (doInsertOverrideAnnotation) {
            template.addTextSegment("@override\n");
        }
        template.addTextSegment("int get hashCode => ");
        boolean firstItem = true;
        if (this.mySuperclassOverridesEqualEqualAndHashCode) {
            template.addTextSegment("\nsuper.hashCode");
            firstItem = false;
        }
        for (DartComponent component : elementsToProcess) {
            if (!firstItem) {
                template.addTextSegment(" ^\n");
            }
            template.addTextSegment(component.getName() + ".hashCode");
            firstItem = false;
        }
        if (!this.mySuperclassOverridesEqualEqualAndHashCode && elementsToProcess.isEmpty()) {
            template.addTextSegment("0");
        }
        template.addTextSegment(";\n");
        template.addEndVariable();
        template.addTextSegment(" ");
        return template;
    }

    @Override
    protected Template buildFunctionsText(TemplateManager templateManager, DartComponent e) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementsToProcess";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/generation/CreateEqualsAndHashcodeFix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/generation/CreateEqualsAndHashcodeFix";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getNothingFoundMessage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "beforeInvoke";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processElements";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doesSuperclassOverrideEqualEqualAndHashCode";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "buildFunctionsText";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

