/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.ide.util.MemberChooser;
import com.intellij.lang.LanguageCodeInsightActionHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.DartNamedElementNode;
import com.jetbrains.lang.dart.ide.generation.BaseCreateMethodsFix;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassDefinition;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDartGenerateHandler
implements LanguageCodeInsightActionHandler {
    private static final Condition<DartComponent> NOT_CONSTRUCTOR_CONDITION = component -> DartComponentType.typeOf((PsiElement)component) != DartComponentType.CONSTRUCTOR;
    private static final Condition<DartComponent> NOT_STATIC_CONDITION = component -> !component.isStatic();

    public boolean isValidFor(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(1);
        }
        return file instanceof DartFile && PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(editor.getCaretModel().getOffset()), DartClass.class) != null;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (project == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(2);
        }
        if (editor == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(3);
        }
        if (file == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(4);
        }
        this.invoke(project, editor, file, editor.getCaretModel().getOffset());
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, int offset) {
        DartClass dartClass;
        if (project == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(6);
        }
        if (file == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(7);
        }
        if ((dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)file.findElementAt(offset), DartClassDefinition.class)) == null) {
            return;
        }
        ArrayList<DartComponent> candidates = new ArrayList<DartComponent>();
        this.collectCandidates(dartClass, candidates);
        List selectedElements = Collections.emptyList();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            selectedElements = ContainerUtil.map(candidates, DartNamedElementNode::new);
        } else if (!candidates.isEmpty()) {
            MemberChooser<DartNamedElementNode> chooser = this.createMemberChooserDialog(project, dartClass, candidates, this.getTitle());
            chooser.show();
            if (chooser.getExitCode() != 0) {
                return;
            }
            selectedElements = chooser.getSelectedElements();
        }
        this.doInvoke(project, editor, file, selectedElements, this.createFix(dartClass));
    }

    protected void doInvoke(final @NotNull Project project, final @NotNull Editor editor, final @NotNull PsiFile file, final @NotNull Collection<DartNamedElementNode> selectedElements, final @NotNull BaseCreateMethodsFix createMethodsFix) {
        if (project == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(8);
        }
        if (editor == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(9);
        }
        if (file == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(10);
        }
        if (selectedElements == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(11);
        }
        if (createMethodsFix == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(12);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                createMethodsFix.addElementsToProcessFrom(selectedElements);
                createMethodsFix.beforeInvoke(project, editor, (PsiElement)file);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            createMethodsFix.invoke(project, editor, (PsiElement)file);
                        }
                        catch (IncorrectOperationException ex) {
                            Logger.getInstance((String)this.getClass().getName()).error((Throwable)ex);
                        }
                    }
                });
            }
        };
        if (CommandProcessor.getInstance().getCurrentCommand() == null) {
            CommandProcessor.getInstance().executeCommand(project, runnable, this.getClass().getName(), null);
        } else {
            runnable.run();
        }
    }

    @NotNull
    protected abstract BaseCreateMethodsFix createFix(@NotNull DartClass var1);

    @NotNull
    protected abstract String getTitle();

    protected abstract void collectCandidates(@NotNull DartClass var1, @NotNull List<DartComponent> var2);

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeClassMembersMap(@NotNull DartClass dartClass, boolean doIncludeStatics) {
        if (dartClass == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(13);
        }
        List classMembers = DartResolveUtil.getNamedSubComponents(dartClass);
        classMembers = ContainerUtil.filter(classMembers, NOT_CONSTRUCTOR_CONDITION);
        if (!doIncludeStatics) {
            classMembers = ContainerUtil.filter((Collection)classMembers, NOT_STATIC_CONDITION);
        }
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(classMembers);
        if (map == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(14);
        }
        return map;
    }

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeSuperClassesMemberMap(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(15);
        }
        ArrayList<DartClass> superClasses = new ArrayList<DartClass>();
        ArrayList<DartClass> superInterfaces = new ArrayList<DartClass>();
        DartResolveUtil.collectSupers(superClasses, superInterfaces, dartClass);
        List<DartComponent> superClassesMembers = new ArrayList();
        for (DartClass superClass : superClasses) {
            superClassesMembers.addAll(DartResolveUtil.getNamedSubComponents(superClass));
        }
        superClassesMembers = ContainerUtil.filter(superClassesMembers, NOT_CONSTRUCTOR_CONDITION);
        superClassesMembers = ContainerUtil.filter(superClassesMembers, NOT_STATIC_CONDITION);
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(superClassesMembers);
        if (map == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(16);
        }
        return map;
    }

    @NotNull
    protected final Map<Pair<String, Boolean>, DartComponent> computeSuperInterfacesMembersMap(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(17);
        }
        ArrayList<DartClass> superClasses = new ArrayList<DartClass>();
        ArrayList<DartClass> superInterfaces = new ArrayList<DartClass>();
        DartResolveUtil.collectSupers(superClasses, superInterfaces, dartClass);
        List<DartComponent> superInterfacesMembers = new ArrayList();
        for (DartClass superInterface : superInterfaces) {
            superInterfacesMembers.addAll(DartResolveUtil.getNamedSubComponents(superInterface));
        }
        superInterfacesMembers = ContainerUtil.filter(superInterfacesMembers, NOT_CONSTRUCTOR_CONDITION);
        superInterfacesMembers = ContainerUtil.filter(superInterfacesMembers, NOT_STATIC_CONDITION);
        Map<Pair<String, Boolean>, DartComponent> map = DartResolveUtil.namedComponentToMap(superInterfacesMembers);
        if (map == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(18);
        }
        return map;
    }

    @Nullable
    protected JComponent getOptionsComponent(DartClass jsClass, Collection<DartComponent> candidates) {
        return null;
    }

    protected MemberChooser<DartNamedElementNode> createMemberChooserDialog(@NotNull Project project, final @NotNull DartClass dartClass, final @NotNull Collection<DartComponent> candidates, @NotNull String title) {
        if (project == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(19);
        }
        if (dartClass == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(20);
        }
        if (candidates == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(21);
        }
        if (title == null) {
            BaseDartGenerateHandler.$$$reportNull$$$0(22);
        }
        List nodes = ContainerUtil.map(candidates, DartNamedElementNode::new);
        MemberChooser<DartNamedElementNode> chooser = new MemberChooser<DartNamedElementNode>(nodes.toArray(new DartNamedElementNode[0]), this.doAllowEmptySelection(), true, project, false){

            protected JComponent createCenterPanel() {
                JComponent superComponent = super.createCenterPanel();
                JComponent optionsComponent = BaseDartGenerateHandler.this.getOptionsComponent(dartClass, candidates);
                if (optionsComponent == null) {
                    return superComponent;
                }
                JPanel panel = new JPanel(new BorderLayout());
                panel.add((Component)superComponent, "Center");
                panel.add((Component)optionsComponent, "South");
                return panel;
            }
        };
        chooser.setTitle(title);
        chooser.setCopyJavadocVisible(false);
        return chooser;
    }

    protected boolean doAllowEmptySelection() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: 
            case 8: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "createMethodsFix";
                break;
            }
            case 13: 
            case 15: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "candidates";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateHandler";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMembersMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSuperClassesMemberMap";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSuperInterfacesMembersMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isValidFor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doInvoke";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMembersMap";
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "computeSuperClassesMemberMap";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "computeSuperInterfacesMembersMap";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createMemberChooserDialog";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 14: 
            case 16: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

