/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.generation;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.ide.generation.BaseDartGenerateHandler;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseDartGenerateAction
extends AnAction {
    public boolean startInTransaction() {
        return true;
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        assert (project != null);
        Pair<Editor, PsiFile> editorAndPsiFile = BaseDartGenerateAction.getEditorAndPsiFile(e);
        this.getGenerateHandler().invoke(project, (Editor)editorAndPsiFile.first, (PsiFile)editorAndPsiFile.second);
    }

    private static Pair<Editor, PsiFile> getEditorAndPsiFile(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return Pair.create(null, null);
        }
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        PsiFile psiFile = (PsiFile)e.getData(CommonDataKeys.PSI_FILE);
        return Pair.create((Object)editor, (Object)psiFile);
    }

    @NotNull
    protected abstract BaseDartGenerateHandler getGenerateHandler();

    public void update(AnActionEvent e) {
        Pair<Editor, PsiFile> editorAndPsiFile = BaseDartGenerateAction.getEditorAndPsiFile(e);
        Editor editor = (Editor)editorAndPsiFile.first;
        PsiFile psiFile = (PsiFile)editorAndPsiFile.second;
        int caretOffset = editor == null ? -1 : editor.getCaretModel().getOffset();
        boolean enable = psiFile != null && this.doEnable((DartClass)PsiTreeUtil.getParentOfType((PsiElement)psiFile.findElementAt(caretOffset), DartClass.class));
        e.getPresentation().setEnabled(enable);
        e.getPresentation().setVisible(enable);
    }

    protected boolean doEnable(@Nullable DartClass dartClass) {
        return dartClass != null;
    }

    protected static boolean doesClassContainMethod(@NotNull DartClass dartClass, @NotNull String methodName) {
        if (dartClass == null) {
            BaseDartGenerateAction.$$$reportNull$$$0(0);
        }
        if (methodName == null) {
            BaseDartGenerateAction.$$$reportNull$$$0(1);
        }
        if (methodName.isEmpty()) {
            return false;
        }
        DartMethodDeclaration[] methodDeclarations = (DartMethodDeclaration[])PsiTreeUtil.getChildrenOfType((PsiElement)DartResolveUtil.getBody(dartClass), DartMethodDeclaration.class);
        if (methodDeclarations == null) {
            return false;
        }
        for (DartMethodDeclaration methodDeclaration : methodDeclarations) {
            if (!methodName.equals(methodDeclaration.getName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean doesClassContainGetter(@NotNull DartClass dartClass, @NotNull String getterName) {
        if (dartClass == null) {
            BaseDartGenerateAction.$$$reportNull$$$0(2);
        }
        if (getterName == null) {
            BaseDartGenerateAction.$$$reportNull$$$0(3);
        }
        if (getterName.isEmpty()) {
            return false;
        }
        DartGetterDeclaration[] getterDeclarations = (DartGetterDeclaration[])PsiTreeUtil.getChildrenOfType((PsiElement)DartResolveUtil.getBody(dartClass), DartGetterDeclaration.class);
        if (getterDeclarations == null) {
            return false;
        }
        for (DartGetterDeclaration getterDeclaration : getterDeclarations) {
            if (!getterName.equals(getterDeclaration.getName())) continue;
            return true;
        }
        return false;
    }

    protected static boolean hasNonStaticField(@NotNull DartClass dartClass) {
        if (dartClass == null) {
            BaseDartGenerateAction.$$$reportNull$$$0(4);
        }
        for (DartComponent component : DartResolveUtil.getNamedSubComponents(dartClass)) {
            if (DartComponentType.typeOf((PsiElement)component) != DartComponentType.FIELD || component.isStatic()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dartClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getterName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/generation/BaseDartGenerateAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "doesClassContainMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "doesClassContainGetter";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "hasNonStaticField";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

