/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.formatter.common.AbstractBlock;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.containers.SortedList;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.ide.formatter.DartBlock;
import com.jetbrains.lang.dart.ide.formatter.DartIndentProcessor;
import java.util.ArrayList;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartSpacingProcessor {
    private static final TokenSet TOKENS_WITH_SPACE_AFTER = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.VAR, DartTokenTypes.FINAL, DartTokenTypes.STATIC, DartTokenTypes.EXTERNAL, DartTokenTypes.ABSTRACT, DartTokenTypes.GET, DartTokenTypes.SET, DartTokenTypes.FACTORY, DartTokenTypes.OPERATOR, DartTokenTypes.PART, DartTokenTypes.EXPORT, DartTokenTypes.DEFERRED, DartTokenTypes.AS, DartTokenTypes.SHOW, DartTokenTypes.HIDE, DartTokenTypes.RETURN_TYPE, DartTokenTypes.COVARIANT});
    private static final TokenSet KEYWORDS_WITH_SPACE_BEFORE = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.GET, DartTokenTypes.SET, DartTokenTypes.EXTENDS, DartTokenTypes.IMPLEMENTS, DartTokenTypes.DEFERRED, DartTokenTypes.AS, DartTokenTypes.SHOW_COMBINATOR, DartTokenTypes.HIDE_COMBINATOR, DartTokenTypes.COVARIANT});
    private static final TokenSet CASCADE_REFERENCE_EXPRESSION_SET = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.CASCADE_REFERENCE_EXPRESSION});
    private static final TokenSet REFERENCE_EXPRESSION_SET = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.REFERENCE_EXPRESSION});
    private static final TokenSet ID_SET = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.ID});
    private static final TokenSet PREFIX_OPERATOR_SET = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.PREFIX_OPERATOR});
    private static final TokenSet SIMPLE_LITERAL_SET = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.STRING_LITERAL_EXPRESSION, DartTokenTypes.NUMBER, DartTokenTypes.TRUE, DartTokenTypes.FALSE, DartTokenTypes.NULL, DartTokenTypes.THIS, DartTokenTypes.LIST_LITERAL_EXPRESSION, DartTokenTypes.MAP_LITERAL_EXPRESSION});
    private static final TokenSet SKIP_COMMA = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.COMMA});
    private static final TokenSet DIRECTIVE_GROUPS = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.IMPORT_STATEMENT, DartTokenTypes.EXPORT_STATEMENT, DartTokenTypes.PART_STATEMENT});
    private final ASTNode myNode;
    private final CommonCodeStyleSettings mySettings;

    public DartSpacingProcessor(ASTNode node, CommonCodeStyleSettings settings) {
        this.myNode = node;
        this.mySettings = settings;
    }

    public Spacing getSpacing(Block child1, Block child2) {
        boolean isBraces;
        ASTNode[] childs;
        ASTNode prev;
        if (!(child1 instanceof AbstractBlock) || !(child2 instanceof AbstractBlock)) {
            return null;
        }
        IElementType elementType = this.myNode.getElementType();
        IElementType parentType = this.myNode.getTreeParent() == null ? null : this.myNode.getTreeParent().getElementType();
        ASTNode node1 = ((AbstractBlock)child1).getNode();
        IElementType type1 = node1.getElementType();
        ASTNode node2 = ((AbstractBlock)child2).getNode();
        IElementType type2 = node2.getElementType();
        if (!(type2 != DartTokenTypesSets.SINGLE_LINE_COMMENT || DartSpacingProcessor.isDirectlyPrecededByNewline(node2) || type1 == DartTokenTypes.LBRACE && (elementType == DartTokenTypes.CLASS_BODY || DartTokenTypesSets.BLOCKS.contains(elementType) && parentType == DartTokenTypes.FUNCTION_BODY))) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE, (int)0);
        }
        if (elementType == DartTokenTypesSets.DART_FILE && DartTokenTypesSets.COMMENTS.contains(type1) && !DartTokenTypesSets.COMMENTS.contains(type2) && (prev = DartSpacingProcessor.getPrevSiblingOnTheSameLineSkipCommentsAndWhitespace(((AbstractBlock)child1).getNode())) != null) {
            int lineBreaks = DartSpacingProcessor.getMinLineBreaksBetweenTopLevelNodes(prev.getElementType(), type2);
            return Spacing.createSpacing((int)0, (int)0, (int)lineBreaks, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (type1 == DartTokenTypesSets.SINGLE_LINE_COMMENT) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (type2 == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
            int nsp = 2;
            if (type1 == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT || elementType != DartTokenTypesSets.DART_FILE && type1 == DartTokenTypes.LBRACE) {
                nsp = 1;
            }
            return Spacing.createSpacing((int)0, (int)0, (int)nsp, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (DIRECTIVE_GROUPS.contains(type1)) {
            ASTNode next;
            if (type2 == DartTokenTypesSets.MULTI_LINE_COMMENT && (next = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)node2)) != null && next.getElementType() == type1) {
                boolean needsNewline = DartSpacingProcessor.isEmbeddedComment(type2, child2) && !DartSpacingProcessor.isDirectlyPrecededByNewline(next);
                int space = needsNewline ? 0 : 1;
                int newline = needsNewline ? 1 : 0;
                return Spacing.createSpacing((int)0, (int)space, (int)newline, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (type2 != DartTokenTypes.IMPORT_STATEMENT && type2 != DartTokenTypes.EXPORT_STATEMENT && !DartSpacingProcessor.isEmbeddedComment(type2, child2)) {
                int numNewlines = DartTokenTypesSets.COMMENTS.contains(type2) && DartSpacingProcessor.isBlankLineAfterComment(node2) ? 1 : 2;
                return Spacing.createSpacing((int)0, (int)0, (int)numNewlines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
        if (type1 == DartTokenTypes.LIBRARY_STATEMENT) {
            int newlines = DartTokenTypesSets.COMMENTS.contains(type2) && DartSpacingProcessor.isBlankLineAfterComment(node2) ? 1 : 2;
            return Spacing.createSpacing((int)0, (int)0, (int)newlines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (elementType == DartTokenTypes.LIBRARY_STATEMENT || parentType == DartTokenTypes.LIBRARY_STATEMENT) {
            if (DartSpacingProcessor.isEmbeddedComment(type2, child2)) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (type1 == DartTokenTypesSets.MULTI_LINE_COMMENT && DartSpacingProcessor.isEmbeddedComment(type1, child1)) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
        }
        if (parentType == DartTokenTypes.LIBRARY_STATEMENT) {
            return this.noSpace();
        }
        if (DartTokenTypes.SEMICOLON == type2) {
            if (type1 == DartTokenTypes.SEMICOLON && elementType == DartTokenTypes.STATEMENTS) {
                return this.addSingleSpaceIf(false, true);
            }
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (DartTokenTypes.AT == type1) {
            return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
        }
        if (DartTokenTypes.METADATA == type1) {
            if (parentType == DartTokenTypes.TYPE_PARAMETERS) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            if (DartTokenTypesSets.COMMENTS.contains(type2)) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (parentType == DartTokenTypesSets.DART_FILE) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
            }
            if (parentType == DartTokenTypes.CLASS_MEMBERS || DartTokenTypesSets.FUNCTION_DEFINITION.contains(parentType)) {
                if (type2 == DartTokenTypes.METADATA || FormatterUtil.isPrecededBy((ASTNode)node1, (IElementType)DartTokenTypes.METADATA, (IElementType[])new IElementType[]{DartTokenTypesSets.WHITE_SPACE})) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                }
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (parentType == DartTokenTypes.VAR_DECLARATION_LIST) {
                if (this.myNode.getTreeParent().getTreeParent().getElementType() == DartTokenTypes.STATEMENTS) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                }
                if (type2 == DartTokenTypes.METADATA || FormatterUtil.isPrecededBy((ASTNode)node1, (IElementType)DartTokenTypes.METADATA, (IElementType[])new IElementType[]{DartTokenTypesSets.WHITE_SPACE})) {
                    return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
                }
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
            }
            if (parentType == DartTokenTypes.NORMAL_FORMAL_PARAMETER) {
                return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)true, (int)0);
        }
        if (DartTokenTypesSets.FUNCTION_DEFINITION.contains(type2)) {
            boolean needsBlank = DartSpacingProcessor.needsBlankLineBeforeFunction(elementType);
            if (!(!needsBlank || this.mySettings.KEEP_LINE_BREAKS || parentType != DartTokenTypes.CLASS_BODY && elementType != DartTokenTypesSets.DART_FILE || type1 != DartTokenTypes.SEMICOLON && !DartSpacingProcessor.hasEmptyBlock(node1))) {
                needsBlank = false;
            }
            int lineFeeds = DartTokenTypesSets.COMMENTS.contains(type1) || !needsBlank ? 1 : 2;
            return Spacing.createSpacing((int)0, (int)0, (int)lineFeeds, (boolean)needsBlank, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (DartTokenTypesSets.DOC_COMMENT_CONTENTS.contains(type2)) {
            return Spacing.createSpacing((int)0, (int)Integer.MAX_VALUE, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (DartTokenTypesSets.BLOCKS_EXT.contains(elementType)) {
            boolean topLevel = elementType == DartTokenTypesSets.DART_FILE || elementType == DartTokenTypesSets.EMBEDDED_CONTENT;
            int lineFeeds = node1 instanceof PsiErrorElement || node2 instanceof PsiErrorElement ? 0 : 1;
            int spaces = 0;
            int blanks = this.mySettings.KEEP_BLANK_LINES_IN_CODE;
            boolean keepBreaks = false;
            if (!DartTokenTypesSets.COMMENTS.contains(type1) && (elementType == DartTokenTypes.CLASS_MEMBERS || topLevel && DartTokenTypesSets.DECLARATIONS.contains(type2))) {
                if (type1 == DartTokenTypes.SEMICOLON && type2 == DartTokenTypes.VAR_DECLARATION_LIST) {
                    ASTNode node1TreePrev = node1.getTreePrev();
                    if (node1TreePrev == null || node1TreePrev.getElementType() != DartTokenTypes.VAR_DECLARATION_LIST) {
                        lineFeeds = 2;
                    }
                } else {
                    lineFeeds = type2 == DartTokenTypes.VAR_DECLARATION_LIST && DartSpacingProcessor.hasEmptyBlock(node1) || type1 == DartTokenTypes.FUNCTION_TYPE_ALIAS && type2 == DartTokenTypes.FUNCTION_TYPE_ALIAS ? 1 : 2;
                }
            } else if (type1 == DartTokenTypes.LBRACE && type2 == DartTokenTypes.RBRACE) {
                if (parentType == DartTokenTypes.ON_PART && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.FUNCTION_BODY) {
                    if (this.myNode.getTreeParent().getTreeParent() != null && this.myNode.getTreeParent().getTreeParent().getElementType() == DartTokenTypes.METHOD_DECLARATION && this.mySettings.KEEP_SIMPLE_METHODS_IN_ONE_LINE) {
                        lineFeeds = 0;
                        keepBreaks = this.mySettings.KEEP_LINE_BREAKS;
                        blanks = keepBreaks ? this.mySettings.KEEP_BLANK_LINES_IN_CODE : 0;
                    } else if (this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                        lineFeeds = 0;
                        keepBreaks = this.mySettings.KEEP_LINE_BREAKS;
                        blanks = keepBreaks ? this.mySettings.KEEP_BLANK_LINES_IN_CODE : 0;
                    }
                } else if (parentType == DartTokenTypes.IF_STATEMENT && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.FOR_STATEMENT && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.WHILE_STATEMENT && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.DO_WHILE_STATEMENT && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.TRY_STATEMENT && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.FINALLY_PART && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.FUNCTION_EXPRESSION_BODY && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                } else if (parentType == DartTokenTypes.STATEMENTS && this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                    lineFeeds = 0;
                }
            } else if (topLevel && DartTokenTypesSets.COMMENTS.contains(type2)) {
                lineFeeds = 0;
                spaces = 1;
                keepBreaks = true;
            } else if (type1 != DartTokenTypes.LBRACE && DartSpacingProcessor.isEmbeddedComment(type2, child2)) {
                lineFeeds = 0;
                spaces = 1;
                keepBreaks = false;
            } else if (type1 == DartTokenTypes.LBRACE && type2 == DartTokenTypes.STATEMENTS || type2 == DartTokenTypes.RBRACE && type1 == DartTokenTypes.STATEMENTS) {
                lineFeeds = 1;
                keepBreaks = false;
                blanks = 0;
            } else if (type1 == DartTokenTypes.LBRACE && type2 == DartTokenTypesSets.SINGLE_LINE_COMMENT) {
                lineFeeds = 1;
                keepBreaks = false;
                blanks = 0;
            } else if (type1 == DartTokenTypesSets.MULTI_LINE_COMMENT && type2 == DartTokenTypes.STATEMENTS) {
                spaces = 1;
                lineFeeds = 0;
                keepBreaks = true;
            }
            int maxSpaces = node1 instanceof PsiErrorElement || node2 instanceof PsiErrorElement ? 1 : spaces;
            return Spacing.createSpacing((int)spaces, (int)maxSpaces, (int)lineFeeds, (boolean)keepBreaks, (int)blanks);
        }
        if (elementType == DartTokenTypes.STATEMENTS && (parentType == DartTokenTypes.SWITCH_CASE || parentType == DartTokenTypes.DEFAULT_CASE)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (!DartTokenTypesSets.COMMENTS.contains(type2) && DartTokenTypesSets.BLOCKS.contains(parentType) && !(node1.getTreeNext() instanceof PsiErrorElement)) {
            return this.addLineBreak();
        }
        if (type2 == DartTokenTypes.RBRACE && (type1 == DartTokenTypes.SWITCH_CASE || type1 == DartTokenTypes.DEFAULT_CASE)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
        }
        if (type1 == DartTokenTypes.COLON && (elementType == DartTokenTypes.SWITCH_CASE || elementType == DartTokenTypes.DEFAULT_CASE)) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
        }
        if (elementType == DartTokenTypes.SWITCH_STATEMENT && type1 == DartTokenTypes.LBRACE) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
        }
        if (type1 == DartTokenTypes.STATEMENTS || type2 == DartTokenTypes.STATEMENTS) {
            return this.addLineBreak();
        }
        if (type1 == DartTokenTypes.CLASS_MEMBERS || type2 == DartTokenTypes.CLASS_MEMBERS) {
            if (type1 == DartTokenTypesSets.MULTI_LINE_COMMENT) {
                return this.addSingleSpaceIf(true, false);
            }
            return this.addSingleSpaceIf(false, true);
        }
        if (type2 == DartTokenTypes.LPAREN) {
            if (elementType == DartTokenTypes.IF_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_IF_PARENTHESES);
            }
            if (elementType == DartTokenTypes.WHILE_STATEMENT || elementType == DartTokenTypes.DO_WHILE_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_PARENTHESES);
            }
            if (elementType == DartTokenTypes.SWITCH_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_SWITCH_PARENTHESES);
            }
            if (elementType == DartTokenTypes.ON_PART || elementType == DartTokenTypes.CATCH_PART) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_PARENTHESES);
            }
        }
        if (elementType == DartTokenTypes.IF_STATEMENT) {
            if (type1 == DartTokenTypes.RPAREN && this.mySettings.BRACE_STYLE == 1) {
                int nsp = this.mySettings.SPACE_BEFORE_IF_LBRACE ? 1 : 0;
                int lf = 0;
                if (!DartTokenTypesSets.BLOCKS.contains(type2) && this.mySettings.SPECIAL_ELSE_IF_TREATMENT && FormatterUtil.isFollowedBy((ASTNode)node2, (IElementType)DartTokenTypes.ELSE, (IElementType[])new IElementType[]{DartTokenTypes.SEMICOLON})) {
                    lf = 1;
                }
                return Spacing.createSpacing((int)nsp, (int)nsp, (int)lf, (!DartTokenTypesSets.BLOCKS.contains(type2) && this.mySettings.KEEP_LINE_BREAKS ? 1 : 0) != 0, (int)0);
            }
            if (type1 == DartTokenTypes.SEMICOLON && type2 == DartTokenTypes.ELSE) {
                return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)0);
            }
        }
        if (type2 == DartTokenTypes.FOR_LOOP_PARTS_IN_BRACES) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_FOR_PARENTHESES);
        }
        if (type2 == DartTokenTypes.FORMAL_PARAMETER_LIST && (DartTokenTypesSets.FUNCTION_DEFINITION.contains(elementType) || elementType == DartTokenTypes.FUNCTION_EXPRESSION)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_PARENTHESES);
        }
        if (elementType == DartTokenTypes.DEFAULT_FORMAL_NAMED_PARAMETER && (type1 == DartTokenTypes.EQ || type2 == DartTokenTypes.EQ)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (type2 == DartTokenTypes.ARGUMENTS && elementType == DartTokenTypes.CALL_EXPRESSION) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES);
        }
        if (DartTokenTypesSets.BLOCKS.contains(type2)) {
            if (elementType == DartTokenTypes.IF_STATEMENT && type1 != DartTokenTypes.ELSE) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_IF_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.IF_STATEMENT && type1 == DartTokenTypes.ELSE) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_ELSE_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.WHILE_STATEMENT || elementType == DartTokenTypes.DO_WHILE_STATEMENT) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_WHILE_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.FOR_STATEMENT) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_FOR_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.TRY_STATEMENT) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_TRY_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.ON_PART) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_CATCH_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (elementType == DartTokenTypes.FINALLY_PART) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_FINALLY_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
        }
        if (type2 == DartTokenTypes.LBRACE && elementType == DartTokenTypes.SWITCH_STATEMENT) {
            return this.setBraceSpace(this.mySettings.SPACE_BEFORE_SWITCH_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
        }
        if (DartTokenTypesSets.FUNCTION_DEFINITION.contains(elementType) && type2 == DartTokenTypes.FUNCTION_BODY) {
            return this.setBraceSpace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, child1.getTextRange());
        }
        if (elementType == DartTokenTypes.FUNCTION_EXPRESSION && type2 == DartTokenTypes.FUNCTION_EXPRESSION_BODY) {
            return this.setBraceSpace(this.mySettings.SPACE_BEFORE_METHOD_LBRACE, this.mySettings.METHOD_BRACE_STYLE, child1.getTextRange());
        }
        if (elementType == DartTokenTypes.CLASS_DEFINITION) {
            if (type2 == DartTokenTypes.CLASS_BODY) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
            if (type2 == DartTokenTypes.TYPE_PARAMETERS) {
                return this.noSpace();
            }
            if (type2 == DartTokenTypes.INTERFACES || type2 == DartTokenTypes.MIXINS) {
                ASTNode typeNameNode = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)this.myNode.getFirstChildNode());
                ASTNode bodyNode = this.myNode.getLastChildNode();
                if (typeNameNode != null && bodyNode != null) {
                    TextRange range = TextRange.create((int)typeNameNode.getTextRange().getStartOffset(), (int)bodyNode.getStartOffset());
                    return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
            }
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (elementType == DartTokenTypes.MIXIN_APPLICATION) {
            return Spacing.createSpacing((int)1, (int)1, (int)0, (boolean)false, (int)0);
        }
        if (elementType == DartTokenTypes.ENUM_DEFINITION) {
            if (this.mySettings.BRACE_STYLE == 1) {
                if (type1 == DartTokenTypes.LBRACE && type2 == DartTokenTypes.RBRACE) {
                    return this.noSpace();
                }
                if (type1 == DartTokenTypes.LBRACE || type2 == DartTokenTypes.RBRACE) {
                    return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.textRangeFollowingMetadata(), (boolean)false, (int)0);
                }
                if (type2 == DartTokenTypes.ENUM_CONSTANT_DECLARATION) {
                    return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.textRangeFollowingMetadata(), (boolean)false, (int)0);
                }
            }
            if (type2 == DartTokenTypes.LBRACE) {
                return this.setBraceSpace(this.mySettings.SPACE_BEFORE_CLASS_LBRACE, this.mySettings.BRACE_STYLE, child1.getTextRange());
            }
        }
        if (type1 == DartTokenTypes.LPAREN || type2 == DartTokenTypes.RPAREN) {
            if (elementType == DartTokenTypes.IF_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_IF_PARENTHESES);
            }
            if (elementType == DartTokenTypes.WHILE_STATEMENT || elementType == DartTokenTypes.DO_WHILE_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_WHILE_PARENTHESES);
            }
            if (elementType == DartTokenTypes.FOR_LOOP_PARTS_IN_BRACES) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_FOR_PARENTHESES);
            }
            if (elementType == DartTokenTypes.SWITCH_STATEMENT) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_SWITCH_PARENTHESES);
            }
            if (elementType == DartTokenTypes.CATCH_PART) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_CATCH_PARENTHESES);
            }
            if (elementType == DartTokenTypes.FORMAL_PARAMETER_LIST) {
                boolean newLineNeeded;
                boolean bl = newLineNeeded = type1 == DartTokenTypes.LPAREN ? this.mySettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE : this.mySettings.METHOD_PARAMETERS_RPAREN_ON_NEXT_LINE;
                if (newLineNeeded || this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES) {
                    return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_PARENTHESES, newLineNeeded);
                }
                return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
            }
            if (elementType == DartTokenTypes.ARGUMENTS) {
                boolean newLineNeeded = type1 == DartTokenTypes.LPAREN ? this.mySettings.CALL_PARAMETERS_LPAREN_ON_NEXT_LINE : this.mySettings.CALL_PARAMETERS_RPAREN_ON_NEXT_LINE;
                return this.addSingleSpaceIf(this.mySettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES, newLineNeeded);
            }
            if (this.mySettings.BINARY_OPERATION_WRAP != 0 && elementType == DartTokenTypes.PARENTHESIZED_EXPRESSION) {
                boolean newLineNeeded = type1 == DartTokenTypes.LPAREN ? this.mySettings.PARENTHESES_EXPRESSION_LPAREN_WRAP : this.mySettings.PARENTHESES_EXPRESSION_RPAREN_WRAP;
                return this.addSingleSpaceIf(false, newLineNeeded);
            }
        }
        if (elementType == DartTokenTypes.TERNARY_EXPRESSION) {
            if (type2 == DartTokenTypes.QUEST) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_QUEST);
            }
            if (type2 == DartTokenTypes.COLON) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_COLON);
            }
            if (type1 == DartTokenTypes.QUEST) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_QUEST);
            }
            if (type1 == DartTokenTypes.COLON) {
                return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COLON);
            }
        }
        if (type1 == DartTokenTypes.ASSIGNMENT_OPERATOR || type2 == DartTokenTypes.ASSIGNMENT_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (type1 == DartTokenTypes.EQ && elementType == DartTokenTypes.VAR_INIT) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (type2 == DartTokenTypes.VAR_INIT) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ASSIGNMENT_OPERATORS);
        }
        if (DartTokenTypesSets.LOGIC_OPERATORS.contains(type1) || DartTokenTypesSets.LOGIC_OPERATORS.contains(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_LOGICAL_OPERATORS);
        }
        if (type1 == DartTokenTypes.EQUALITY_OPERATOR || type2 == DartTokenTypes.EQUALITY_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_EQUALITY_OPERATORS);
        }
        if (type1 == DartTokenTypes.RELATIONAL_OPERATOR || type2 == DartTokenTypes.RELATIONAL_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_RELATIONAL_OPERATORS);
        }
        if (DartTokenTypesSets.BITWISE_OPERATORS.contains(type1) || DartTokenTypesSets.BITWISE_OPERATORS.contains(type2)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_BITWISE_OPERATORS);
        }
        if ((type1 == DartTokenTypes.ADDITIVE_OPERATOR || type2 == DartTokenTypes.ADDITIVE_OPERATOR) && elementType != DartTokenTypes.PREFIX_EXPRESSION) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_ADDITIVE_OPERATORS);
        }
        if (type1 == DartTokenTypes.MULTIPLICATIVE_OPERATOR || type2 == DartTokenTypes.MULTIPLICATIVE_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_MULTIPLICATIVE_OPERATORS);
        }
        if (type1 == DartTokenTypes.PREFIX_OPERATOR && type2 == DartTokenTypes.PREFIX_EXPRESSION && (childs = node2.getChildren(PREFIX_OPERATOR_SET)).length > 0) {
            return this.addSingleSpaceIf(DartSpacingProcessor.isSpaceNeededBetweenPrefixOps(node1, childs[0]));
        }
        if (type1 == DartTokenTypes.PREFIX_OPERATOR || type2 == DartTokenTypes.PREFIX_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_UNARY_OPERATOR);
        }
        if (type1 == DartTokenTypes.SHIFT_OPERATOR || type2 == DartTokenTypes.SHIFT_OPERATOR) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AROUND_SHIFT_OPERATORS);
        }
        if (type2 == DartTokenTypes.ELSE) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_ELSE_KEYWORD, this.mySettings.ELSE_ON_NEW_LINE);
        }
        if (type2 == DartTokenTypes.WHILE) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_WHILE_KEYWORD, this.mySettings.WHILE_ON_NEW_LINE);
        }
        if (type2 == DartTokenTypes.ON_PART) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_CATCH_KEYWORD, this.mySettings.CATCH_ON_NEW_LINE);
        }
        if (type2 == DartTokenTypes.FINALLY_PART) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_FINALLY_KEYWORD, this.mySettings.CATCH_ON_NEW_LINE);
        }
        if (type1 == DartTokenTypes.ELSE) {
            if (type2 == DartTokenTypes.IF_STATEMENT) {
                return Spacing.createSpacing((int)1, (int)1, (int)(this.mySettings.SPECIAL_ELSE_IF_TREATMENT ? 0 : 1), (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            if (type2 != DartTokenTypes.LBRACE) {
                int lf = this.mySettings.SPECIAL_ELSE_IF_TREATMENT ? 1 : 0;
                return Spacing.createSpacing((int)1, (int)1, (int)lf, (!DartTokenTypesSets.BLOCKS.contains(type2) && this.mySettings.KEEP_LINE_BREAKS ? 1 : 0) != 0, (int)0);
            }
        }
        if (type1 == DartTokenTypes.LBRACE && type2 == DartTokenTypes.RBRACE) {
            if (elementType == DartTokenTypes.CLASS_BODY && this.mySettings.KEEP_SIMPLE_CLASSES_IN_ONE_LINE) {
                return this.noSpace();
            }
            if (this.mySettings.KEEP_SIMPLE_BLOCKS_IN_ONE_LINE) {
                return this.noSpace();
            }
        }
        boolean bl = isBraces = type1 == DartTokenTypes.LBRACE || type2 == DartTokenTypes.RBRACE;
        if (isBraces && elementType != DartTokenTypes.OPTIONAL_FORMAL_PARAMETERS && elementType != DartTokenTypes.OPTIONAL_PARAMETER_TYPES && elementType != DartTokenTypes.MAP_LITERAL_EXPRESSION || DartTokenTypesSets.BLOCKS_EXT.contains(type1) || DartTokenTypesSets.FUNCTION_DEFINITION.contains(type1)) {
            return this.addLineBreak();
        }
        if (DartTokenTypesSets.COMMENTS.contains(type1)) {
            if (isBraces || type2 == DartTokenTypes.SEMICOLON) {
                return this.addLineBreak();
            }
            if (parentType == DartTokenTypesSets.DART_FILE && DartTokenTypesSets.FUNCTION_DEFINITION.contains(elementType) && (type1 != DartTokenTypesSets.MULTI_LINE_COMMENT || type2 != DartTokenTypes.COMPONENT_NAME)) {
                return this.addLineBreak();
            }
            if (type2 == DartTokenTypes.RBRACKET && elementType != DartTokenTypes.OPTIONAL_FORMAL_PARAMETERS) {
                return this.addLineBreak();
            }
            if (type2 == DartTokenTypes.ARGUMENT_LIST || type2 == DartTokenTypes.COMPONENT_NAME) {
                if (type1 == DartTokenTypesSets.MULTI_LINE_COMMENT && DartSpacingProcessor.isEmbeddedComment(type1, child1) && !DartSpacingProcessor.hasNewlineInText(node1)) {
                    return this.addSingleSpaceIf(true);
                }
                return this.addLineBreak();
            }
        }
        if ((elementType == DartTokenTypes.INTERFACES || elementType == DartTokenTypes.MIXINS) && type2 == DartTokenTypes.TYPE_LIST) {
            return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myNode.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (elementType == DartTokenTypes.TYPE_LIST && type2 == DartTokenTypes.TYPE) {
            return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)this.myNode.getTreeParent().getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (type1 == DartTokenTypes.LBRACKET && type2 == DartTokenTypes.RBRACKET) {
            return this.noSpace();
        }
        if (type1 == DartTokenTypes.COMMA && (elementType == DartTokenTypes.FORMAL_PARAMETER_LIST || elementType == DartTokenTypes.ARGUMENT_LIST)) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COMMA);
        }
        if (type1 == DartTokenTypes.COMMA) {
            if (type2 == DartTokenTypes.RBRACKET) {
                TextRange range = this.myNode.getTextRange();
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
            }
            return this.addSingleSpaceIf(this.mySettings.SPACE_AFTER_COMMA && type2 != DartTokenTypes.RBRACE && type2 != DartTokenTypes.RBRACKET);
        }
        if (type2 == DartTokenTypes.COMMA) {
            return this.addSingleSpaceIf(this.mySettings.SPACE_BEFORE_COMMA);
        }
        if (type1 == DartTokenTypes.EXPRESSION_BODY_DEF) {
            if (type2 == DartTokenTypes.STRING_LITERAL_EXPRESSION) {
                return this.addSingleSpaceIf(true);
            }
            TextRange range = node2.getTextRange();
            return Spacing.createDependentLFSpacing((int)1, (int)1, (TextRange)range, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (type2 == DartTokenTypes.EXPRESSION_BODY_DEF) {
            return this.addSingleSpaceIf(true);
        }
        if (type1 == DartTokenTypes.FOR_LOOP_PARTS_IN_BRACES && !DartTokenTypesSets.BLOCKS_EXT.contains(type2)) {
            return this.addLineBreak();
        }
        if (type1 == DartTokenTypes.IF_STATEMENT || type1 == DartTokenTypes.SWITCH_STATEMENT || type1 == DartTokenTypes.TRY_STATEMENT || type1 == DartTokenTypes.DO_WHILE_STATEMENT || type1 == DartTokenTypes.FOR_STATEMENT || type1 == DartTokenTypes.SWITCH_CASE || type1 == DartTokenTypes.DEFAULT_CASE || type1 == DartTokenTypes.WHILE_STATEMENT) {
            return this.addLineBreak();
        }
        if (DartTokenTypesSets.COMMENTS.contains(type2)) {
            int forceSpace = 1;
            if (type2 == DartTokenTypesSets.MULTI_LINE_COMMENT && (type1 == DartTokenTypes.COMPONENT_NAME || type1 == DartTokenTypes.TYPE || type1 == DartTokenTypes.VAR || type1 == DartTokenTypes.RETURN_TYPE)) {
                forceSpace = 0;
            }
            return Spacing.createSpacing((int)forceSpace, (int)1, (int)0, (boolean)true, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (TOKENS_WITH_SPACE_AFTER.contains(type1) || KEYWORDS_WITH_SPACE_BEFORE.contains(type2)) {
            return this.addSingleSpaceIf(true);
        }
        if (elementType == DartTokenTypes.FOR_LOOP_PARTS && type1 == DartTokenTypes.SEMICOLON) {
            return this.addSingleSpaceIf(true);
        }
        if (elementType == DartTokenTypes.VALUE_EXPRESSION && type2 == DartTokenTypes.CASCADE_REFERENCE_EXPRESSION) {
            if (type1 == DartTokenTypes.CASCADE_REFERENCE_EXPRESSION) {
                if (DartSpacingProcessor.cascadesAreSameMethod(((AbstractBlock)child1).getNode(), ((AbstractBlock)child2).getNode())) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
            } else if (type1 == DartTokenTypes.REFERENCE_EXPRESSION || DartSpacingProcessor.isSimpleLiteral(type1)) {
                CompositeElement elem = (CompositeElement)this.myNode;
                ASTNode[] childs2 = elem.getChildren(CASCADE_REFERENCE_EXPRESSION_SET);
                if (childs2.length == 1) {
                    return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myNode.getTextRange(), (boolean)true, (int)0);
                }
                if (DartSpacingProcessor.allCascadesAreSameMethod(childs2)) {
                    return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)false, (int)0);
                }
            } else if (type1 == DartTokenTypes.NEW_EXPRESSION && parentType == DartTokenTypes.ARGUMENT_LIST) {
                return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)this.myNode.getTextRange(), (boolean)true, (int)0);
            }
            return this.addLineBreak();
        }
        if (type1 == DartTokenTypes.CLOSING_QUOTE && type2 == DartTokenTypes.OPEN_QUOTE && elementType == DartTokenTypes.STRING_LITERAL_EXPRESSION) {
            ASTNode sib = node1;
            int preserveNewline = 0;
            while ((sib = sib.getTreeNext()) != null && sib.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
                String ws = sib.getText();
                if (!ws.contains("\n")) continue;
                ++preserveNewline;
                break;
            }
            return Spacing.createSpacing((int)0, (int)1, (int)preserveNewline, (boolean)true, (int)0);
        }
        if (type2 == DartTokenTypes.INITIALIZERS) {
            if (DartSpacingProcessor.hasMultipleInitializers(node2)) {
                return this.addSingleSpaceIf(false, true);
            }
            return this.addSingleSpaceIf(true, false);
        }
        if (elementType == DartTokenTypes.LIST_LITERAL_EXPRESSION && type2 == DartTokenTypes.RBRACKET) {
            return Spacing.createDependentLFSpacing((int)0, (int)0, (TextRange)node1.getTextRange(), (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        if (elementType == DartTokenTypes.NAMED_ARGUMENT || elementType == DartTokenTypes.DEFAULT_FORMAL_NAMED_PARAMETER || elementType == DartTokenTypes.MAP_LITERAL_ENTRY) {
            if (type1 == DartTokenTypes.COLON) {
                return this.addSingleSpaceIf(true);
            }
            if (type2 == DartTokenTypes.COLON) {
                return this.noSpace();
            }
        }
        if (!(elementType != DartTokenTypes.TYPE_ARGUMENTS && elementType != DartTokenTypes.TYPE_PARAMETERS || type1 != DartTokenTypes.LT && type2 != DartTokenTypes.GT && type2 != DartTokenTypes.LT && type1 != DartTokenTypes.GT)) {
            return this.noSpace();
        }
        if (elementType == DartTokenTypes.IS_EXPRESSION) {
            if (type1 == DartTokenTypes.NOT) {
                return this.addSingleSpaceIf(true);
            }
            if (type2 == DartTokenTypes.NOT) {
                return this.noSpace();
            }
        }
        if (type1 == DartTokenTypes.TYPE_ARGUMENTS && (type2 == DartTokenTypes.LBRACKET || type2 == DartTokenTypes.LBRACE)) {
            return this.noSpace();
        }
        if (type2 == DartTokenTypes.RBRACE && type1 == DartTokenTypes.MAP_LITERAL_ENTRY) {
            return this.noSpace();
        }
        if (type2 == DartTokenTypes.RBRACKET && type1 == DartTokenTypes.LIST_LITERAL_EXPRESSION) {
            return this.noSpace();
        }
        if (type2 == DartTokenTypes.RBRACKET && type1 == DartTokenTypes.EXPRESSION_LIST) {
            return this.noSpace();
        }
        if (elementType == DartTokenTypes.FUNCTION_BODY || elementType == DartTokenTypes.FUNCTION_EXPRESSION_BODY) {
            if (type1 == DartTokenTypes.ASYNC || type1 == DartTokenTypes.SYNC) {
                if (type2 == DartTokenTypes.MUL) {
                    return this.noSpace();
                }
                return this.addSingleSpaceIf(true);
            }
            if (type1 == DartTokenTypes.MUL) {
                return this.addSingleSpaceIf(true);
            }
        }
        if (elementType == DartTokenTypes.REFERENCE_EXPRESSION && (type2 == DartTokenTypes.DOT || type2 == DartTokenTypes.QUEST_DOT)) {
            return this.createSpacingForCallChain(this.collectSurroundingMessageSends(), node2);
        }
        if (type1 == DartTokenTypes.DOT || type1 == DartTokenTypes.QUEST_DOT || type1 == DartTokenTypes.HASH) {
            return this.noSpace();
        }
        if (type2 == DartTokenTypes.HASH) {
            return this.addSingleSpaceIf(parentType == DartTokenTypes.SYMBOL_LITERAL_EXPRESSION);
        }
        if (type1 == DartTokenTypes.RETURN && type2 != DartTokenTypes.SEMICOLON) {
            return this.addSingleSpaceIf(true);
        }
        return Spacing.createSpacing((int)0, (int)1, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private static int getMinLineBreaksBetweenTopLevelNodes(@NotNull IElementType type1, @NotNull IElementType type2) {
        if (type1 == null) {
            DartSpacingProcessor.$$$reportNull$$$0(0);
        }
        if (type2 == null) {
            DartSpacingProcessor.$$$reportNull$$$0(1);
        }
        if (type1 == DartTokenTypes.LIBRARY_STATEMENT) {
            return 2;
        }
        if (type1 == DartTokenTypes.PART_OF_STATEMENT) {
            return 2;
        }
        if ((type1 == DartTokenTypes.IMPORT_STATEMENT || type1 == DartTokenTypes.EXPORT_STATEMENT) && type2 != DartTokenTypes.IMPORT_STATEMENT && type2 != DartTokenTypes.EXPORT_STATEMENT) {
            return 2;
        }
        if (type1 == DartTokenTypes.PART) {
            return 2;
        }
        if (type1 == DartTokenTypes.CLASS_DEFINITION) {
            return 2;
        }
        if (type1 == DartTokenTypes.ENUM_DEFINITION) {
            return 2;
        }
        if (type1 == DartTokenTypes.GETTER_DECLARATION) {
            return 2;
        }
        if (type1 == DartTokenTypes.SETTER_DECLARATION) {
            return 2;
        }
        if (type1 == DartTokenTypes.FUNCTION_DECLARATION_WITH_BODY_OR_NATIVE) {
            return 2;
        }
        return 1;
    }

    private Spacing addLineBreak() {
        return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)false, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing addSingleSpaceIf(boolean condition) {
        return this.addSingleSpaceIf(condition, false);
    }

    private Spacing addSingleSpaceIf(boolean condition, boolean linesFeed) {
        int spaces = condition ? 1 : 0;
        int lines = linesFeed ? 1 : 0;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)lines, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private Spacing noSpace() {
        return Spacing.createSpacing((int)0, (int)0, (int)0, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)0);
    }

    private Spacing setBraceSpace(boolean needSpaceSetting, @CommonCodeStyleSettings.BraceStyleConstant int braceStyleSetting, TextRange textRange) {
        int spaces;
        int n = spaces = needSpaceSetting ? 1 : 0;
        if (braceStyleSetting == 5 && textRange != null) {
            return Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        int lineBreaks = braceStyleSetting == 1 || braceStyleSetting == 5 ? 0 : 1;
        return Spacing.createSpacing((int)spaces, (int)spaces, (int)lineBreaks, (boolean)false, (int)0);
    }

    private static boolean doesMessageHaveArguments(ASTNode node) {
        ASTNode parent = node.getTreeParent().getTreeParent();
        if (parent == null) {
            return false;
        }
        if (parent.getElementType() != DartTokenTypes.CALL_EXPRESSION) {
            return false;
        }
        ASTNode args = parent.getLastChildNode();
        if (args == null) {
            return false;
        }
        return args.getElementType() == DartTokenTypes.ARGUMENTS;
    }

    private static Comparator<ASTNode> textRangeSorter() {
        return Comparator.comparingInt(o -> o.getTextRange().getStartOffset());
    }

    private CallChain collectSurroundingMessageSends() {
        CallChain calls = new CallChain();
        this.collectPredecessorMessageSends(calls);
        this.collectSuccessorMessageSends(calls);
        return calls;
    }

    private void collectPredecessorMessageSends(CallChain calls) {
        ASTNode node = this.myNode;
        while (node != null) {
            IElementType type = node.getElementType();
            if (type == DartTokenTypes.REFERENCE_EXPRESSION) {
                DartSpacingProcessor.collectDotIfMessageSend(calls, node);
                node = node.getTreeParent();
                continue;
            }
            if (type != DartTokenTypes.CALL_EXPRESSION) break;
            if (DartSpacingProcessor.hasMultilineFunctionArgument(node)) {
                calls.isFollowedByHardNewline = true;
                break;
            }
            node = node.getTreeParent();
        }
    }

    private void collectSuccessorMessageSends(CallChain calls) {
        ASTNode node = this.myNode;
        while (node != null) {
            IElementType type = node.getElementType();
            if (type == DartTokenTypes.CALL_EXPRESSION) {
                if (DartSpacingProcessor.hasMultilineFunctionArgument(node)) {
                    calls.isPrecededByHardNewline = true;
                    break;
                }
                node = node.getFirstChildNode();
                continue;
            }
            if (type != DartTokenTypes.REFERENCE_EXPRESSION) break;
            DartSpacingProcessor.collectDotIfMessageSend(calls, node);
            node = node.getFirstChildNode();
        }
    }

    private static void collectDotIfMessageSend(CallChain calls, ASTNode node) {
        IElementType childType;
        ASTNode child = node.getFirstChildNode();
        if ((child = FormatterUtil.getNextNonWhitespaceSibling((ASTNode)child)) != null && ((childType = child.getElementType()) == DartTokenTypes.DOT || childType == DartTokenTypes.QUEST_DOT || childType == DartTokenTypes.HASH)) {
            calls.add(child);
        }
    }

    private static boolean hasMultilineFunctionArgument(ASTNode node) {
        ASTNode args = node.getLastChildNode();
        ASTNode first = args == null ? null : args.getFirstChildNode();
        ASTNode aSTNode = args = first == null ? null : first.getTreeNext();
        if (args != null && args.getElementType() == DartTokenTypes.ARGUMENT_LIST) {
            int n = 1;
            for (ASTNode arg = args.getFirstChildNode(); arg != null; arg = arg.getTreeNext()) {
                if (n++ != 10 && arg.getElementType() != DartTokenTypes.FUNCTION_EXPRESSION || arg.getText().indexOf(10) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private Spacing createSpacingForCallChain(CallChain calls, ASTNode node2) {
        if (calls.list.size() < 2) {
            return this.noSpace();
        }
        boolean isAllProperties = true;
        boolean mustSplit = false;
        boolean mustStopAtNextMethod = false;
        ArrayList<TextRange> ranges = new ArrayList<TextRange>();
        for (ASTNode node : calls.list) {
            if (DartSpacingProcessor.doesMessageHaveArguments(node)) {
                if (mustStopAtNextMethod) {
                    return Spacing.createDependentLFSpacing((int)0, (int)0, ranges, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
                }
                isAllProperties = false;
            } else if (!isAllProperties) {
                mustSplit = true;
            }
            TextRange range = node.getTextRange();
            ranges.add(new TextRange(range.getStartOffset() - 1, range.getEndOffset()));
            if (node2 != node || !isAllProperties) continue;
            mustStopAtNextMethod = true;
        }
        if (isAllProperties && ranges.size() > 7) {
            mustSplit = true;
        }
        if (mustSplit) {
            return Spacing.createSpacing((int)0, (int)0, (int)1, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
        }
        return Spacing.createDependentLFSpacing((int)0, (int)0, ranges, (boolean)this.mySettings.KEEP_LINE_BREAKS, (int)this.mySettings.KEEP_BLANK_LINES_IN_CODE);
    }

    private TextRange textRangeFollowingMetadata() {
        TextRange range = this.myNode.getTextRange();
        ASTNode child = this.myNode.getFirstChildNode();
        if (child == null || child.getElementType() != DartTokenTypes.METADATA) {
            return range;
        }
        while (child != null && (child.getElementType() == DartTokenTypes.METADATA || child.getElementType() == DartTokenTypesSets.WHITE_SPACE)) {
            child = child.getTreeNext();
        }
        if (child == null) {
            return range;
        }
        return new TextRange(child.getTextRange().getStartOffset(), range.getEndOffset());
    }

    private static boolean allCascadesAreSameMethod(ASTNode[] children) {
        for (int i = 1; i < children.length; ++i) {
            if (DartSpacingProcessor.cascadesAreSameMethod(children[i - 1], children[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean cascadesAreSameMethod(ASTNode child1, ASTNode child2) {
        String name2;
        String name1;
        ASTNode call2;
        ASTNode call1 = child1.getLastChildNode();
        return call1.getElementType() == DartTokenTypes.CALL_EXPRESSION && (call2 = child2.getLastChildNode()).getElementType() == DartTokenTypes.CALL_EXPRESSION && (name1 = DartSpacingProcessor.getImmediateCallName(call1)) != null && name1.equals(name2 = DartSpacingProcessor.getImmediateCallName(call2));
    }

    private static String getImmediateCallName(ASTNode callNode) {
        ASTNode[] childs = callNode.getChildren(REFERENCE_EXPRESSION_SET);
        if (childs.length != 1) {
            return null;
        }
        ASTNode child = childs[0];
        if ((childs = child.getChildren(ID_SET)).length != 1) {
            return null;
        }
        child = childs[0];
        return child.getText();
    }

    private static boolean isSpaceNeededBetweenPrefixOps(ASTNode node1, ASTNode node2) {
        String op1 = node1.getText();
        String op2 = node2.getText();
        return op1.endsWith(op2.substring(op2.length() - 1));
    }

    private static boolean isSimpleLiteral(IElementType nodeType) {
        return SIMPLE_LITERAL_SET.contains(nodeType);
    }

    private static boolean needsBlankLineBeforeFunction(IElementType elementType) {
        return elementType == DartTokenTypesSets.DART_FILE || elementType == DartTokenTypes.CLASS_MEMBERS || elementType instanceof DartTokenTypesSets.DartEmbeddedContentElementType;
    }

    private static boolean isEmbeddedComment(IElementType type, Block block) {
        return DartTokenTypesSets.COMMENTS.contains(type) && (!DartSpacingProcessor.isDirectlyPrecededByNewline(block) || DartSpacingProcessor.isDirectlyPrecededByBlockComment(block));
    }

    private static boolean isDirectlyPrecededByNewline(Block child) {
        ASTNode node = ((DartBlock)child).getNode();
        return DartSpacingProcessor.isDirectlyPrecededByNewline(node);
    }

    private static boolean isDirectlyPrecededByNewline(ASTNode node) {
        while ((node = node.getTreePrev()) != null) {
            if (node.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
                if (!node.getText().contains("\n")) continue;
                return true;
            }
            if (node.getElementType() != DartTokenTypesSets.MULTI_LINE_COMMENT) break;
            if (node.getTreePrev() != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    private static ASTNode getPrevSiblingOnTheSameLineSkipCommentsAndWhitespace(@NotNull ASTNode node) {
        if (node == null) {
            DartSpacingProcessor.$$$reportNull$$$0(2);
        }
        while ((node = node.getTreePrev()) != null) {
            if (node.getElementType() == DartTokenTypesSets.WHITE_SPACE || DartTokenTypesSets.COMMENTS.contains(node.getElementType())) {
                if (!node.getText().contains("\n")) continue;
                return null;
            }
            return node;
        }
        return null;
    }

    private static boolean isDirectlyPrecededByBlockComment(Block child) {
        ASTNode node = ((DartBlock)child).getNode();
        return DartSpacingProcessor.isDirectlyPrecededByBlockComment(node);
    }

    private static boolean isDirectlyPrecededByBlockComment(ASTNode node) {
        while ((node = node.getTreePrev()) != null) {
            if (node.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
                if (!node.getText().contains("\n")) continue;
                return false;
            }
            if (node.getElementType() != DartTokenTypesSets.MULTI_LINE_COMMENT) break;
            return true;
        }
        return false;
    }

    private static boolean isScriptTag(Block child) {
        ASTNode node = ((DartBlock)child).getNode();
        if (!node.getText().trim().startsWith("#!")) {
            return false;
        }
        while ((node = node.getTreePrev()) != null) {
            if (node.getElementType() == DartTokenTypesSets.WHITE_SPACE) continue;
            return false;
        }
        return true;
    }

    public static boolean hasMultipleInitializers(ASTNode node) {
        return FormatterUtil.isPrecededBy((ASTNode)node.getLastChildNode(), (IElementType)DartTokenTypes.SUPER_CALL_OR_FIELD_INITIALIZER, (TokenSet)SKIP_COMMA);
    }

    private static boolean hasEmptyBlock(ASTNode node) {
        if (node.getElementType() == DartTokenTypes.CLASS_DEFINITION) {
            return false;
        }
        ASTNode child = node;
        while (true) {
            if ((child = child.getLastChildNode()) == null) {
                return false;
            }
            if (child.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
                child = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
            }
            if (child == null) {
                return false;
            }
            if (child.getElementType() == DartTokenTypes.FUNCTION_BODY) {
                ASTNode arrow;
                ASTNode next = child.getLastChildNode();
                if (next.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
                    next = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)next);
                }
                if (next == null || next.getElementType() != DartTokenTypes.SEMICOLON) continue;
                return (next = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)next)) != null && DartIndentProcessor.EXPRESSIONS.contains(next.getElementType()) && (arrow = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)next)) != null && arrow.getElementType() == DartTokenTypes.EXPRESSION_BODY_DEF;
            }
            if (child.getElementType() == DartTokenTypes.SEMICOLON) {
                ASTNode prev = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
                return prev != null && prev.getElementType() == DartTokenTypes.INITIALIZERS;
            }
            if (DartTokenTypesSets.BLOCKS.contains(child.getElementType())) break;
        }
        if ((child = child.getLastChildNode()) == null) {
            return false;
        }
        if (child.getElementType() == DartTokenTypesSets.WHITE_SPACE) {
            child = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child);
        }
        if (child == null) {
            return false;
        }
        if (child.getElementType() != DartTokenTypes.RBRACE) {
            return false;
        }
        return (child = FormatterUtil.getPreviousNonWhitespaceSibling((ASTNode)child)) != null && child.getElementType() == DartTokenTypes.LBRACE;
    }

    private static boolean hasNewlineInText(ASTNode node) {
        String comment = node.getText();
        return comment.indexOf(10) > 0;
    }

    private static boolean isBlankLineAfterComment(ASTNode node) {
        int n;
        ASTNode next = node.getTreeNext();
        if (next == null || next.getElementType() != DartTokenTypesSets.WHITE_SPACE) {
            return false;
        }
        String comment = next.getText();
        return comment.indexOf(10, (n = comment.indexOf(10)) + 1) > 0;
    }

    static /* synthetic */ Comparator access$100() {
        return DartSpacingProcessor.textRangeSorter();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type2";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/formatter/DartSpacingProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getMinLineBreaksBetweenTopLevelNodes";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getPrevSiblingOnTheSameLineSkipCommentsAndWhitespace";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class CallChain {
        SortedList<ASTNode> list = new SortedList(DartSpacingProcessor.access$100());
        boolean isPrecededByHardNewline = false;
        boolean isFollowedByHardNewline = false;

        private CallChain() {
        }

        void add(ASTNode node) {
            if (!this.list.contains((Object)node)) {
                this.list.add((Object)node);
            }
        }
    }
}

