/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessor;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.actions.DartStyleAction;
import com.jetbrains.lang.dart.ide.application.options.DartCodeStyleSettings;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class DartPostFormatProcessor
implements PostFormatProcessor {
    public PsiElement processElement(@NotNull PsiElement source, @NotNull CodeStyleSettings settings) {
        if (source == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(1);
        }
        return source;
    }

    @NotNull
    public TextRange processText(@NotNull PsiFile psiFile, @NotNull TextRange rangeToReformat, @NotNull CodeStyleSettings settings) {
        if (psiFile == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(2);
        }
        if (rangeToReformat == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(3);
        }
        if (settings == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(4);
        }
        if (!DartPostFormatProcessor.isApplicable(psiFile, rangeToReformat)) {
            TextRange textRange = rangeToReformat;
            if (textRange == null) {
                DartPostFormatProcessor.$$$reportNull$$$0(5);
            }
            return textRange;
        }
        DartStyleAction.runDartfmt(psiFile.getProject(), Collections.singletonList(psiFile.getVirtualFile()));
        Document document = PsiDocumentManager.getInstance((Project)psiFile.getProject()).getDocument(psiFile);
        if (document != null) {
            PsiDocumentManager.getInstance((Project)psiFile.getProject()).commitDocument(document);
        }
        TextRange textRange = psiFile.getTextRange();
        if (textRange == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(6);
        }
        return textRange;
    }

    private static boolean isApplicable(@NotNull PsiFile psiFile, @NotNull TextRange rangeToReformat) {
        if (psiFile == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(7);
        }
        if (rangeToReformat == null) {
            DartPostFormatProcessor.$$$reportNull$$$0(8);
        }
        if (!(psiFile instanceof DartFile)) {
            return false;
        }
        if (!psiFile.getTextRange().equals((Object)rangeToReformat)) {
            return false;
        }
        Project project = psiFile.getProject();
        if (!((DartCodeStyleSettings)CodeStyleSettingsManager.getSettings((Project)project).getCustomSettings(DartCodeStyleSettings.class)).DELEGATE_TO_DARTFMT) {
            return false;
        }
        VirtualFile vFile = psiFile.getVirtualFile();
        if (!DartAnalysisServerService.isLocalAnalyzableFile(vFile)) {
            return false;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            return false;
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(vFile)) {
            return false;
        }
        return DartAnalysisServerService.getInstance(project).serverReadyForRequest(project);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rangeToReformat";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/formatter/DartPostFormatProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/formatter/DartPostFormatProcessor";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "processText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "processElement";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processText";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

