/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.formatter;

import com.intellij.formatting.FormattingMode;
import com.intellij.formatting.Indent;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.formatter.FormatterUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class DartIndentProcessor {
    public static final TokenSet EXPRESSIONS = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.ADDITIVE_EXPRESSION, DartTokenTypes.ARRAY_ACCESS_EXPRESSION, DartTokenTypes.ASSIGN_EXPRESSION, DartTokenTypes.AS_EXPRESSION, DartTokenTypes.AWAIT_EXPRESSION, DartTokenTypes.BITWISE_EXPRESSION, DartTokenTypes.CALL_EXPRESSION, DartTokenTypes.CASCADE_REFERENCE_EXPRESSION, DartTokenTypes.COMPARE_EXPRESSION, DartTokenTypes.EXPRESSION, DartTokenTypes.FUNCTION_EXPRESSION, DartTokenTypes.IS_EXPRESSION, DartTokenTypes.LIBRARY_COMPONENT_REFERENCE_EXPRESSION, DartTokenTypes.LIST_LITERAL_EXPRESSION, DartTokenTypes.LITERAL_EXPRESSION, DartTokenTypes.LOGIC_AND_EXPRESSION, DartTokenTypes.LOGIC_OR_EXPRESSION, DartTokenTypes.MAP_LITERAL_EXPRESSION, DartTokenTypes.MULTIPLICATIVE_EXPRESSION, DartTokenTypes.NEW_EXPRESSION, DartTokenTypes.PARAMETER_NAME_REFERENCE_EXPRESSION, DartTokenTypes.PARENTHESIZED_EXPRESSION, DartTokenTypes.PREFIX_EXPRESSION, DartTokenTypes.REFERENCE_EXPRESSION, DartTokenTypes.SHIFT_EXPRESSION, DartTokenTypes.STRING_LITERAL_EXPRESSION, DartTokenTypes.SUFFIX_EXPRESSION, DartTokenTypes.SUPER_EXPRESSION, DartTokenTypes.SYMBOL_LITERAL_EXPRESSION, DartTokenTypes.TERNARY_EXPRESSION, DartTokenTypes.THIS_EXPRESSION, DartTokenTypes.THROW_EXPRESSION, DartTokenTypes.VALUE_EXPRESSION, DartTokenTypes.IF_NULL_EXPRESSION});
    private final CommonCodeStyleSettings settings;

    public DartIndentProcessor(CommonCodeStyleSettings settings) {
        this.settings = settings;
    }

    public Indent getChildIndent(ASTNode node, FormattingMode mode) {
        ASTNode previousNode;
        int braceStyle;
        IElementType elementType = node.getElementType();
        ASTNode prevSibling = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(node);
        IElementType prevSiblingType = prevSibling == null ? null : prevSibling.getElementType();
        ASTNode parent = node.getTreeParent();
        IElementType parentType = parent != null ? parent.getElementType() : null;
        ASTNode superParent = parent == null ? null : parent.getTreeParent();
        IElementType superParentType = superParent == null ? null : superParent.getElementType();
        int n = braceStyle = superParentType == DartTokenTypes.FUNCTION_BODY ? this.settings.METHOD_BRACE_STYLE : this.settings.BRACE_STYLE;
        if (parent == null || parent.getTreeParent() == null || parentType == DartTokenTypesSets.EMBEDDED_CONTENT) {
            return Indent.getNoneIndent();
        }
        if (elementType == DartTokenTypesSets.MULTI_LINE_COMMENT_BODY) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypesSets.DOC_COMMENT_LEADING_ASTERISK || elementType == DartTokenTypesSets.MULTI_LINE_COMMENT_END) {
            return Indent.getSpaceIndent((int)1, (boolean)true);
        }
        if (this.settings.KEEP_FIRST_COLUMN_COMMENT && (elementType == DartTokenTypesSets.SINGLE_LINE_COMMENT || elementType == DartTokenTypesSets.MULTI_LINE_COMMENT) && (previousNode = node.getTreePrev()) != null && previousNode.getElementType() == DartTokenTypesSets.WHITE_SPACE && previousNode.getText().endsWith("\n")) {
            return Indent.getAbsoluteNoneIndent();
        }
        if (DartTokenTypesSets.COMMENTS.contains(elementType) && prevSiblingType == DartTokenTypes.LBRACE && parentType == DartTokenTypes.CLASS_BODY) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.ENUM_DEFINITION && DartIndentProcessor.isBetweenBraces(node)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.MAP_LITERAL_EXPRESSION || parentType == DartTokenTypes.LIST_LITERAL_EXPRESSION) {
            if (elementType == DartTokenTypes.LBRACE || elementType == DartTokenTypes.RBRACE || elementType == DartTokenTypes.LBRACKET || elementType == DartTokenTypes.RBRACKET) {
                return Indent.getNoneIndent();
            }
            if (elementType == DartTokenTypes.TYPE_ARGUMENTS) {
                return Indent.getNoneIndent();
            }
            if (elementType == DartTokenTypes.MAP_LITERAL_ENTRY || elementType == DartTokenTypes.EXPRESSION_LIST || elementType == DartTokenTypes.COMMA) {
                return Indent.getNormalIndent();
            }
            if (DartTokenTypesSets.COMMENTS.contains(elementType)) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (elementType == DartTokenTypes.LBRACE || elementType == DartTokenTypes.RBRACE) {
            switch (braceStyle) {
                case 1: {
                    if (elementType == DartTokenTypes.LBRACE && FormatterUtil.isPrecededBy((ASTNode)parent, (IElementType)DartTokenTypesSets.SINGLE_LINE_COMMENT, (IElementType[])new IElementType[]{DartTokenTypesSets.WHITE_SPACE})) {
                        return Indent.getContinuationIndent();
                    }
                }
                case 2: 
                case 5: {
                    return Indent.getNoneIndent();
                }
                case 3: 
                case 4: {
                    return Indent.getNormalIndent();
                }
            }
            return Indent.getNoneIndent();
        }
        if (parentType == DartTokenTypes.PARENTHESIZED_EXPRESSION) {
            if (elementType == DartTokenTypes.LPAREN || elementType == DartTokenTypes.RPAREN) {
                return Indent.getNoneIndent();
            }
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.CLASS_MEMBERS) {
            return Indent.getNormalIndent();
        }
        if (DartTokenTypesSets.BLOCKS.contains(parentType)) {
            PsiElement psi = node.getPsi();
            if (psi.getParent() instanceof PsiFile) {
                return Indent.getNoneIndent();
            }
            return Indent.getNormalIndent();
        }
        if (elementType == DartTokenTypes.LPAREN && (superParentType == DartTokenTypes.METADATA || parentType == DartTokenTypes.ARGUMENTS)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.ARGUMENTS) {
            if (DartTokenTypesSets.COMMENTS.contains(elementType)) {
                return Indent.getNormalIndent();
            }
            return Indent.getNoneIndent();
        }
        if (parentType == DartTokenTypes.ARGUMENT_LIST) {
            return parent.getLastChildNode().getElementType() == DartTokenTypes.COMMA ? Indent.getNormalIndent() : Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.FORMAL_PARAMETER_LIST || parentType == DartTokenTypes.PARAMETER_TYPE_LIST) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.OPTIONAL_FORMAL_PARAMETERS && elementType != DartTokenTypes.LBRACE && elementType != DartTokenTypes.RBRACE && elementType != DartTokenTypes.LBRACKET && elementType != DartTokenTypes.RBRACKET) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.FOR_STATEMENT && prevSiblingType == DartTokenTypes.FOR_LOOP_PARTS_IN_BRACES && !DartTokenTypesSets.BLOCKS.contains(elementType)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.SWITCH_STATEMENT && (elementType == DartTokenTypes.SWITCH_CASE || elementType == DartTokenTypes.DEFAULT_CASE)) {
            return Indent.getNormalIndent();
        }
        if ((parentType == DartTokenTypes.SWITCH_CASE || parentType == DartTokenTypes.DEFAULT_CASE) && elementType == DartTokenTypes.STATEMENTS) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.WHILE_STATEMENT && prevSiblingType == DartTokenTypes.RPAREN && !DartTokenTypesSets.BLOCKS.contains(elementType)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.DO_WHILE_STATEMENT && prevSiblingType == DartTokenTypes.DO && !DartTokenTypesSets.BLOCKS.contains(elementType)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.RETURN_STATEMENT && prevSiblingType == DartTokenTypes.RETURN && !DartTokenTypesSets.BLOCKS.contains(elementType)) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.IF_STATEMENT && !DartTokenTypesSets.BLOCKS.contains(elementType) && (prevSiblingType == DartTokenTypes.RPAREN || prevSiblingType == DartTokenTypes.ELSE && elementType != DartTokenTypes.IF_STATEMENT)) {
            return Indent.getNormalIndent();
        }
        if (elementType == DartTokenTypes.CASCADE_REFERENCE_EXPRESSION) {
            return Indent.getNormalIndent();
        }
        if (elementType == DartTokenTypes.OPEN_QUOTE && prevSiblingType == DartTokenTypes.CLOSING_QUOTE && parentType == DartTokenTypes.STRING_LITERAL_EXPRESSION) {
            return Indent.getContinuationIndent();
        }
        if (DartTokenTypesSets.BINARY_EXPRESSIONS.contains(parentType) && prevSibling != null) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.COLON || parentType == DartTokenTypes.TERNARY_EXPRESSION && elementType == DartTokenTypes.QUEST) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.HIDE_COMBINATOR || elementType == DartTokenTypes.SHOW_COMBINATOR) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.FUNCTION_BODY && FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypes.EXPRESSION_BODY_DEF)) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.CALL_EXPRESSION) {
            if (FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypes.EXPRESSION_BODY_DEF)) {
                return Indent.getContinuationIndent();
            }
            if (FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypes.ASSIGNMENT_OPERATOR)) {
                return Indent.getContinuationIndent();
            }
        }
        if ((elementType == DartTokenTypes.REFERENCE_EXPRESSION || DartTokenTypesSets.BINARY_EXPRESSIONS.contains(elementType)) && (FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypes.ASSIGNMENT_OPERATOR) || FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypes.EQ))) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.VAR_DECLARATION_LIST_PART) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.SUPER_CALL_OR_FIELD_INITIALIZER) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.SUPER_CALL_OR_FIELD_INITIALIZER && elementType != DartTokenTypes.COLON) {
            return Indent.getNormalIndent();
        }
        if (parentType == DartTokenTypes.CLASS_DEFINITION && (elementType == DartTokenTypes.SUPERCLASS || elementType == DartTokenTypes.INTERFACES || elementType == DartTokenTypes.MIXINS)) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.MIXIN_APPLICATION && elementType == DartTokenTypes.MIXINS) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.LIBRARY_NAME_ELEMENT) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.SEMICOLON && FormatterUtil.isPrecededBy((ASTNode)node, (IElementType)DartTokenTypesSets.SINGLE_LINE_COMMENT, (IElementType[])new IElementType[]{DartTokenTypesSets.WHITE_SPACE})) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.DOT || elementType == DartTokenTypes.QUEST_DOT) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.TYPE_LIST && elementType == DartTokenTypes.TYPE) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.OPEN_QUOTE && parentType == DartTokenTypes.STRING_LITERAL_EXPRESSION && superParentType == DartTokenTypes.VAR_INIT && node.getText().length() < 3) {
            return Indent.getContinuationIndent();
        }
        if (elementType == DartTokenTypes.RAW_SINGLE_QUOTED_STRING && parentType == DartTokenTypes.STRING_LITERAL_EXPRESSION && superParentType == DartTokenTypes.VAR_INIT) {
            return Indent.getContinuationIndent();
        }
        if (parentType == DartTokenTypes.LONG_TEMPLATE_ENTRY && EXPRESSIONS.contains(elementType)) {
            return Indent.getContinuationIndent();
        }
        return Indent.getNoneIndent();
    }

    private static boolean isBetweenBraces(@NotNull ASTNode node) {
        IElementType elementType;
        if (node == null) {
            DartIndentProcessor.$$$reportNull$$$0(0);
        }
        if ((elementType = node.getElementType()) == DartTokenTypes.LBRACE || elementType == DartTokenTypes.RBRACE) {
            return false;
        }
        for (ASTNode sibling = node.getTreePrev(); sibling != null; sibling = sibling.getTreePrev()) {
            if (sibling.getElementType() != DartTokenTypes.LBRACE) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/jetbrains/lang/dart/ide/formatter/DartIndentProcessor", "isBetweenBraces"));
    }
}

