/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.findUsages;

import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.usages.impl.rules.UsageType;
import com.intellij.usages.impl.rules.UsageTypeProvider;
import com.jetbrains.lang.dart.DartComponentType;
import com.jetbrains.lang.dart.psi.DartCallExpression;
import com.jetbrains.lang.dart.psi.DartInterfaces;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartReference;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartSuperclass;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeList;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import org.jetbrains.annotations.Nullable;

public class DartUsageTypeProvider
implements UsageTypeProvider {
    public UsageType getUsageType(PsiElement element) {
        boolean isFirstChild;
        if (!(element instanceof DartReference)) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent instanceof DartType) {
            return DartUsageTypeProvider.getUsageTypeByType((DartType)parent);
        }
        if (DartResolveUtil.isLValue(element)) {
            return UsageType.WRITE;
        }
        if (!(parent instanceof DartReference)) {
            return UsageType.READ;
        }
        PsiElement target = ((DartReference)element).resolve();
        DartComponentType targetType = DartComponentType.typeOf(target == null ? null : target.getParent());
        DartReference[] references = (DartReference[])PsiTreeUtil.getChildrenOfType((PsiElement)parent, DartReference.class);
        boolean bl = isFirstChild = references != null && references.length > 0 && references[0] == element;
        if (isFirstChild && references.length == 2 && targetType == DartComponentType.CLASS) {
            return UsageType.CLASS_STATIC_MEMBER_ACCESS;
        }
        if (isFirstChild) {
            return UsageType.READ;
        }
        if (!(parent.getParent() instanceof DartCallExpression)) {
            return UsageType.READ;
        }
        return null;
    }

    @Nullable
    private static UsageType getUsageTypeByType(DartType type) {
        PsiElement typeParent = type.getParent();
        DartComponentType typeParentType = DartComponentType.typeOf(typeParent);
        if (typeParent instanceof DartSuperclass) {
            return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
        }
        if (typeParent instanceof DartNewExpression) {
            return UsageType.CLASS_NEW_OPERATOR;
        }
        if (typeParent instanceof DartTypeList && typeParent.getParent() instanceof DartInterfaces) {
            return UsageType.CLASS_EXTENDS_IMPLEMENTS_LIST;
        }
        if (typeParent instanceof DartTypeList && typeParent.getParent() instanceof DartTypeArguments) {
            return UsageType.TYPE_PARAMETER;
        }
        if (typeParent instanceof DartReturnType) {
            return UsageType.CLASS_METHOD_RETURN_TYPE;
        }
        if (typeParent instanceof DartVarAccessDeclaration && typeParentType != null) {
            switch (typeParentType) {
                case PARAMETER: {
                    return UsageType.CLASS_METHOD_PARAMETER_DECLARATION;
                }
                case FIELD: {
                    return UsageType.CLASS_FIELD_DECLARATION;
                }
                case METHOD: {
                    return UsageType.CLASS_METHOD_RETURN_TYPE;
                }
            }
            return null;
        }
        return null;
    }
}

