/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.findUsages;

import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.Consumer;
import com.intellij.util.Processor;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.findUsages.ReadActionConsumer;
import com.jetbrains.lang.dart.psi.DartReference;
import org.dartlang.analysis.server.protocol.Location;
import org.dartlang.analysis.server.protocol.SearchResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerFindUsagesHandler
extends FindUsagesHandler {
    public DartServerFindUsagesHandler(@NotNull PsiElement element) {
        if (element == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(0);
        }
        super(DartServerFindUsagesHandler.mayBeChangeToNameIdentifier(element));
    }

    @NotNull
    private static PsiElement mayBeChangeToNameIdentifier(@NotNull PsiElement element) {
        PsiElement nameIdentifier;
        if (element == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(1);
        }
        if (element instanceof PsiNameIdentifierOwner && (nameIdentifier = ((PsiNameIdentifierOwner)element).getNameIdentifier()) != null) {
            PsiElement psiElement = nameIdentifier;
            if (psiElement == null) {
                DartServerFindUsagesHandler.$$$reportNull$$$0(2);
            }
            return psiElement;
        }
        PsiElement psiElement = element;
        if (psiElement == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(3);
        }
        return psiElement;
    }

    public boolean processElementUsages(final @NotNull PsiElement elementToSearch, final @NotNull Processor<UsageInfo> processor, @NotNull FindUsagesOptions options) {
        if (elementToSearch == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(4);
        }
        if (processor == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(5);
        }
        if (options == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(6);
        }
        final SearchScope scope = options.searchScope;
        Project project = (Project)ReadAction.compute(() -> ((DartServerFindUsagesHandler)this).getProject());
        final DartAnalysisServerService service = DartAnalysisServerService.getInstance(project);
        ReadActionConsumer<SearchResult> searchResultProcessor = new ReadActionConsumer<SearchResult>(){

            @Override
            public void consumeInReadAction(SearchResult result) {
                UsageInfo usageInfo;
                if (result.getKind().equals("DECLARATION")) {
                    return;
                }
                Location location = result.getLocation();
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)location.getFile()));
                if (vFile == null) {
                    return;
                }
                if (!scope.contains(vFile)) {
                    return;
                }
                PsiFile psiFile = elementToSearch.getManager().findFile(vFile);
                if (psiFile == null) {
                    return;
                }
                int offset = service.getConvertedOffset(vFile, location.getOffset());
                int length = service.getConvertedOffset(vFile, location.getOffset() + location.getLength()) - offset;
                TextRange range = TextRange.create((int)offset, (int)(offset + length));
                boolean potentialUsage = result.isPotential();
                PsiElement usageElement = DartServerFindUsagesHandler.getUsagePsiElement(psiFile, range);
                UsageInfo usageInfo2 = usageInfo = usageElement == null ? null : DartServerFindUsagesHandler.getUsageInfo(usageElement, range, potentialUsage);
                if (usageInfo != null && usageInfo.getElement() != null && (!(scope instanceof LocalSearchScope) || PsiSearchScopeUtil.isInScope((LocalSearchScope)((LocalSearchScope)scope), (PsiElement)usageInfo.getElement()))) {
                    processor.process((Object)usageInfo);
                }
            }
        };
        VirtualFile file = (VirtualFile)ReadAction.compute(() -> {
            if (elementToSearch == null) {
                DartServerFindUsagesHandler.$$$reportNull$$$0(11);
            }
            return elementToSearch.getContainingFile().getVirtualFile();
        });
        int offset = elementToSearch.getTextRange().getStartOffset();
        service.search_findElementReferences(file, offset, (Consumer<SearchResult>)searchResultProcessor);
        return true;
    }

    @Nullable
    public static UsageInfo getUsageInfo(@NotNull PsiElement usageElement, @NotNull TextRange range, boolean potentialUsage) {
        if (usageElement == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(7);
        }
        if (range == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(8);
        }
        int offset = range.getStartOffset() - usageElement.getTextRange().getStartOffset();
        boolean nonCodeUsage = usageElement instanceof PsiComment || usageElement.getParent() instanceof PsiComment;
        UsageInfo usageInfo = new UsageInfo(usageElement, offset, offset + range.getLength(), nonCodeUsage);
        usageInfo.setDynamicUsage(potentialUsage);
        return usageInfo;
    }

    @Nullable
    public static PsiElement getUsagePsiElement(@NotNull PsiFile psiFile, @NotNull TextRange textRange) {
        PsiElement parent;
        PsiElement element;
        if (psiFile == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(9);
        }
        if (textRange == null) {
            DartServerFindUsagesHandler.$$$reportNull$$$0(10);
        }
        if ((element = psiFile.findElementAt(textRange.getStartOffset())) == null) {
            return null;
        }
        boolean rangeOk = element.getTextRange().contains(textRange);
        if (rangeOk && element instanceof DartReference) {
            return element;
        }
        TextRange previousRange = element.getTextRange();
        while ((parent = element.getParent()) != null) {
            TextRange parentRange = parent.getTextRange();
            if (rangeOk) {
                if (!parentRange.equals((Object)previousRange)) {
                    return element;
                }
                if (parent instanceof DartReference) {
                    return parent;
                }
                previousRange = parentRange;
                element = parent;
                continue;
            }
            rangeOk = parent.getTextRange().contains(textRange);
            if (rangeOk && parent instanceof DartReference) {
                return parent;
            }
            previousRange = parentRange;
            element = parent;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementToSearch";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/findUsages/DartServerFindUsagesHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "mayBeChangeToNameIdentifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "mayBeChangeToNameIdentifier";
                break;
            }
            case 2: 
            case 3: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "processElementUsages";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getUsageInfo";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getUsagePsiElement";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processElementUsages$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

