/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.findUsages;

import com.google.dart.server.utilities.general.ObjectUtilities;
import com.intellij.navigation.NavigationItem;
import com.intellij.navigation.NavigationItemFileStatus;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartComponentName;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartComponentUsageGroup
implements UsageGroup,
DataProvider {
    private final VirtualFile myFile;
    private final SmartPsiElementPointer<DartComponent> myElementPointer;
    private final String myText;
    private final Icon myIcon;

    public DartComponentUsageGroup(@NotNull DartComponent element) {
        if (element == null) {
            DartComponentUsageGroup.$$$reportNull$$$0(0);
        }
        this.myFile = element.getContainingFile().getVirtualFile();
        this.myText = StringUtil.notNullize((String)element.getName());
        this.myElementPointer = SmartPointerManager.getInstance((Project)element.getProject()).createSmartPsiElementPointer((PsiElement)element);
        this.myIcon = element.getIcon(3);
    }

    public boolean canNavigate() {
        return this.isValid();
    }

    public boolean canNavigateToSource() {
        return this.canNavigate();
    }

    public int compareTo(@NotNull UsageGroup usageGroup) {
        if (usageGroup == null) {
            DartComponentUsageGroup.$$$reportNull$$$0(1);
        }
        return this.getText(null).compareToIgnoreCase(usageGroup.getText(null));
    }

    public boolean equals(Object object) {
        if (object instanceof DartComponentUsageGroup) {
            DartComponentUsageGroup other = (DartComponentUsageGroup)object;
            return ObjectUtilities.equals(other.myFile, this.myFile) && ObjectUtilities.equals(other.myText, this.myText);
        }
        return false;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        DartComponentName nameElement;
        if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (nameElement = this.getNameElement()) != null) {
            return nameElement;
        }
        if (UsageView.USAGE_INFO_KEY.is(dataId) && (nameElement = this.getNameElement()) != null) {
            return new UsageInfo((PsiElement)nameElement);
        }
        return null;
    }

    public FileStatus getFileStatus() {
        return this.isValid() ? NavigationItemFileStatus.get((NavigationItem)this.getComponentElement()) : null;
    }

    public Icon getIcon(boolean isOpen) {
        return this.myIcon;
    }

    @NotNull
    public String getText(UsageView view) {
        String string = this.myText;
        if (string == null) {
            DartComponentUsageGroup.$$$reportNull$$$0(2);
        }
        return string;
    }

    public int hashCode() {
        return this.myText.hashCode();
    }

    public boolean isValid() {
        DartComponent componentElement = this.getComponentElement();
        return componentElement != null && componentElement.isValid();
    }

    public void navigate(boolean focus) throws UnsupportedOperationException {
        DartComponentName nameElement = this.getNameElement();
        if (nameElement != null && nameElement.isValid()) {
            nameElement.navigate(focus);
        }
    }

    public void update() {
    }

    private DartComponent getComponentElement() {
        return (DartComponent)this.myElementPointer.getElement();
    }

    private DartComponentName getNameElement() {
        DartComponent componentElement = this.getComponentElement();
        return componentElement != null ? componentElement.getComponentName() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageGroup";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/findUsages/DartComponentUsageGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/findUsages/DartComponentUsageGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

