/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.actions.SendFeedbackAction;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.errorTreeView.DartFeedbackBuilder;
import com.jetbrains.lang.dart.sdk.DartSdk;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultDartFeedbackBuilder
extends DartFeedbackBuilder {
    @Override
    public String prompt() {
        return "Open issue submission form?";
    }

    @Override
    public void sendFeedback(@NotNull Project project, @Nullable String errorMessage, @Nullable String serverLog) {
        ApplicationInfoEx appInfo;
        boolean isEAP;
        if (project == null) {
            DefaultDartFeedbackBuilder.$$$reportNull$$$0(0);
        }
        String ijBuild = (isEAP = (appInfo = ApplicationInfoEx.getInstanceEx()).isEAP()) ? appInfo.getBuild().asStringWithoutProductCode() : appInfo.getBuild().asString();
        String sdkVersion = this.getSdkVersion(project);
        String platformDescription = StringUtil.replace((String)SendFeedbackAction.getDescription(), (String)";", (String)" ").trim();
        String urlTemplate = DartBundle.message("dart.feedback.url.template", ijBuild, sdkVersion, platformDescription);
        if (errorMessage != null) {
            errorMessage = "```\n" + errorMessage + "```";
            try {
                File file = FileUtil.createTempFile((String)"report", (String)".txt");
                FileUtil.writeToFile((File)file, (String)errorMessage);
                if (serverLog != null) {
                    FileUtil.writeToFile((File)file, (String)("\n\n" + serverLog), (boolean)true);
                }
                String potentialTemplate = urlTemplate + "\n\n" + DartBundle.message("dart.error.file.instructions", file.getAbsolutePath()) + "\n\n" + errorMessage;
                urlTemplate = potentialTemplate.substring(0, Math.min(potentialTemplate.length(), 1900));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        DefaultDartFeedbackBuilder.openBrowserOnFeedbackForm(urlTemplate, project);
    }

    public static void openBrowserOnFeedbackForm(@NotNull String urlTemplate, @Nullable Project project) {
        if (urlTemplate == null) {
            DefaultDartFeedbackBuilder.$$$reportNull$$$0(1);
        }
        BrowserUtil.browse((String)urlTemplate, (Project)project);
    }

    protected String getSdkVersion(@NotNull Project project) {
        DartSdk sdk;
        if (project == null) {
            DefaultDartFeedbackBuilder.$$$reportNull$$$0(2);
        }
        return (sdk = DartSdk.getDartSdk(project)) == null ? "<NO SDK>" : sdk.getVersion();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlTemplate";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DefaultDartFeedbackBuilder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "sendFeedback";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "openBrowserOnFeedbackForm";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSdkVersion";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

