/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.ide.CopyProvider;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.table.TableView;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblem;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilterForm;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsPresentationHelper;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsTableModel;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import icons.DartIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.swing.DefaultRowSorter;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.table.JTableHeader;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemsViewPanel
extends SimpleToolWindowPanel
implements DataProvider,
CopyProvider {
    private static final LayeredIcon DART_ERRORS_ICON = new LayeredIcon(2);
    private static final LayeredIcon DART_WARNINGS_ICON;
    @NotNull
    private final Project myProject;
    @NotNull
    private final TableView<DartProblem> myTable;
    @NotNull
    private final DartProblemsPresentationHelper myPresentationHelper;
    private DartProblemsView.ToolWindowUpdater myToolWindowUpdater;

    public DartProblemsViewPanel(@NotNull Project project, @NotNull DartProblemsPresentationHelper presentationHelper) {
        if (project == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(0);
        }
        if (presentationHelper == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(1);
        }
        super(false, true);
        this.myProject = project;
        this.myPresentationHelper = presentationHelper;
        this.myTable = this.createTable();
        this.setToolbar(this.createToolbar());
        this.setContent(this.createCenterPanel());
    }

    @NotNull
    private TableView<DartProblem> createTable() {
        TableView table = new TableView((ListTableModel)new DartProblemsTableModel(this.myProject, this.myPresentationHelper));
        table.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DartProblemsViewPanel.this.navigate(false);
                }
            }
        });
        EditSourceOnDoubleClickHandler.install((JTable)table);
        table.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DartProblemsViewPanel.this.popupInvoked(comp, x, y);
            }
        });
        ((DefaultRowSorter)table.getRowSorter()).setRowFilter(this.myPresentationHelper.getRowFilter());
        table.getRowSorter().addRowSorterListener(e -> {
            List<RowSorter.SortKey> sortKeys = this.myTable.getRowSorter().getSortKeys();
            assert (sortKeys.size() == 1) : sortKeys;
            ((DartProblemsTableModel)((Object)((Object)this.myTable.getModel()))).setSortKey(sortKeys.get(0));
        });
        new TableSpeedSearch((JTable)table, object -> object instanceof DartProblem ? ((DartProblem)object).getErrorMessage() + " " + ((DartProblem)object).getPresentableLocation() : "");
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        table.setStriped(true);
        table.setRowHeight(table.getRowHeight() + JBUI.scale((int)4));
        JTableHeader tableHeader = table.getTableHeader();
        tableHeader.setPreferredSize(new Dimension(0, table.getRowHeight()));
        TableView tableView = table;
        if (tableView == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(2);
        }
        return tableView;
    }

    private void popupInvoked(Component component, int x, int y) {
        DefaultActionGroup group = new DefaultActionGroup();
        if (this.getData(CommonDataKeys.NAVIGATABLE.getName()) != null) {
            group.add(ActionManager.getInstance().getAction("EditSource"));
        }
        group.add(ActionManager.getInstance().getAction("$Copy"));
        ActionPopupMenu menu = ActionManager.getInstance().createActionPopupMenu("toolbar", (ActionGroup)group);
        menu.getComponent().show(component, x, y);
    }

    @NotNull
    private JComponent createToolbar() {
        DefaultActionGroup group = new DefaultActionGroup();
        DartProblemsViewPanel.addReanalyzeActions(group);
        group.addSeparator();
        this.addAutoScrollToSourceAction(group);
        this.addGroupBySeverityAction(group);
        group.addAction((AnAction)new FilterProblemsAction());
        group.addSeparator();
        JComponent jComponent = ActionManager.getInstance().createActionToolbar("DartProblemsView", (ActionGroup)group, false).getComponent();
        if (jComponent == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(3);
        }
        return jComponent;
    }

    @NotNull
    private JPanel createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)ScrollPaneFactory.createScrollPane(this.myTable), "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(4);
        }
        return jPanel;
    }

    private void updateStatusDescription() {
        if (this.myToolWindowUpdater != null) {
            DartProblemsTableModel model = (DartProblemsTableModel)((Object)this.myTable.getModel());
            this.myToolWindowUpdater.setHeaderText(model.getStatusText());
            this.myToolWindowUpdater.setIcon((Icon)(model.hasErrors() ? DART_ERRORS_ICON : (model.hasWarnings() ? DART_WARNINGS_ICON : DartIcons.Dart_13)));
        }
    }

    private static void addReanalyzeActions(@NotNull DefaultActionGroup group) {
        AnAction restartAction;
        if (group == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(5);
        }
        if ((restartAction = ActionManager.getInstance().getAction("Dart.Restart.Analysis.Server")) != null) {
            group.add(restartAction);
        }
    }

    private void addAutoScrollToSourceAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(6);
        }
        AutoScrollToSourceHandler autoScrollToSourceHandler = new AutoScrollToSourceHandler(){

            protected boolean isAutoScrollMode() {
                return DartProblemsViewPanel.this.myPresentationHelper.isAutoScrollToSource();
            }

            protected void setAutoScrollMode(boolean autoScrollToSource) {
                DartProblemsViewPanel.this.myPresentationHelper.setAutoScrollToSource(autoScrollToSource);
            }
        };
        autoScrollToSourceHandler.install(this.myTable);
        group.addAction((AnAction)autoScrollToSourceHandler.createToggleAction());
    }

    private void addGroupBySeverityAction(@NotNull DefaultActionGroup group) {
        if (group == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(7);
        }
        ToggleAction action = new ToggleAction(DartBundle.message("group.by.severity", new Object[0]), DartBundle.message("group.by.severity.description", new Object[0]), AllIcons.Nodes.SortBySeverity){

            public boolean isSelected(AnActionEvent e) {
                return DartProblemsViewPanel.this.myPresentationHelper.isGroupBySeverity();
            }

            public void setSelected(AnActionEvent e, boolean groupBySeverity) {
                DartProblemsViewPanel.this.myPresentationHelper.setGroupBySeverity(groupBySeverity);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }
        };
        group.addAction((AnAction)action);
    }

    void fireGroupingOrFilterChanged() {
        this.myTable.getRowSorter().allRowsChanged();
        ((DartProblemsTableModel)((Object)this.myTable.getModel())).onFilterChanged();
        this.updateStatusDescription();
    }

    private void showFiltersPopup() {
        final DartProblemsFilterForm form = new DartProblemsFilterForm();
        form.reset(this.myPresentationHelper);
        form.addListener(new DartProblemsFilterForm.FilterListener(){

            @Override
            public void filtersChanged() {
                DartProblemsViewPanel.this.myPresentationHelper.updateFromUI(form);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }

            @Override
            public void filtersResetRequested() {
                DartProblemsViewPanel.this.myPresentationHelper.resetAllFilters();
                form.reset(DartProblemsViewPanel.this.myPresentationHelper);
                DartProblemsViewPanel.this.fireGroupingOrFilterChanged();
            }
        });
        Rectangle visibleRect = this.myTable.getVisibleRect();
        Point tableTopLeft = new Point(this.myTable.getLocationOnScreen().x + visibleRect.x, this.myTable.getLocationOnScreen().y + visibleRect.y);
        JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)form.getMainPanel(), (JComponent)form.getMainPanel()).setProject(this.myProject).setTitle("Dart Problems Filter").setMovable(true).setRequestFocus(true).createPopup().show(RelativePoint.fromScreen((Point)tableTopLeft));
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(8);
        }
        return true;
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(9);
        }
        return this.myTable.getSelectedObject() != null;
    }

    public void performCopy(@NotNull DataContext dataContext) {
        List selectedObjects;
        String s;
        if (dataContext == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(10);
        }
        if (!(s = StringUtil.join((Collection)(selectedObjects = this.myTable.getSelectedObjects()), problem -> problem.getSeverity().toLowerCase(Locale.US) + ": " + problem.getErrorMessage() + " (" + problem.getCode() + " at " + problem.getPresentableLocation() + ")", (String)"\n")).isEmpty()) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(s));
        }
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.COPY_PROVIDER.is(dataId)) {
            return this;
        }
        if (CommonDataKeys.NAVIGATABLE.is(dataId)) {
            return this.createNavigatable();
        }
        return null;
    }

    @Nullable
    private Navigatable createNavigatable() {
        VirtualFile file;
        DartProblem problem = (DartProblem)this.myTable.getSelectedObject();
        if (problem != null && (file = LocalFileSystem.getInstance().findFileByPath(problem.getSystemIndependentPath())) != null) {
            OpenFileDescriptor navigatable = new OpenFileDescriptor(this.myProject, file, problem.getOffset());
            navigatable.setScrollType(ScrollType.MAKE_VISIBLE);
            return navigatable;
        }
        return null;
    }

    private void navigate(boolean requestFocus) {
        Navigatable navigatable = this.createNavigatable();
        if (navigatable != null && navigatable.canNavigateToSource()) {
            navigatable.navigate(requestFocus);
        }
    }

    public void setErrors(@NotNull Map<String, List<AnalysisError>> filePathToErrors) {
        DartProblem oldSelectedProblem;
        DartProblemsTableModel model;
        DartProblem updatedSelectedProblem;
        if (filePathToErrors == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(11);
        }
        if ((updatedSelectedProblem = (model = (DartProblemsTableModel)((Object)this.myTable.getModel())).setErrorsAndReturnReplacementForSelection(filePathToErrors, oldSelectedProblem = (DartProblem)this.myTable.getSelectedObject())) != null) {
            this.myTable.setSelection(Collections.singletonList(updatedSelectedProblem));
        }
        this.updateStatusDescription();
    }

    public void clearAll() {
        ((DartProblemsTableModel)((Object)this.myTable.getModel())).removeAll();
        this.updateStatusDescription();
    }

    void setToolWindowUpdater(@NotNull DartProblemsView.ToolWindowUpdater toolWindowUpdater) {
        if (toolWindowUpdater == null) {
            DartProblemsViewPanel.$$$reportNull$$$0(12);
        }
        this.myToolWindowUpdater = toolWindowUpdater;
    }

    static {
        DART_ERRORS_ICON.setIcon(DartIcons.Dart_13, 0);
        DART_ERRORS_ICON.setIcon(AllIcons.Ide.ErrorPoint, 1, 6);
        DART_WARNINGS_ICON = new LayeredIcon(2);
        DART_WARNINGS_ICON.setIcon(DartIcons.Dart_13, 0);
        DART_WARNINGS_ICON.setIcon(DartIcons.Warning_point, 1, 6);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationHelper";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "group";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathToErrors";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowUpdater";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsViewPanel";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createTable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createToolbar";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCenterPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "addReanalyzeActions";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addAutoScrollToSourceAction";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addGroupBySeverityAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setErrors";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setToolWindowUpdater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class FilterProblemsAction
    extends DumbAwareAction
    implements Toggleable {
        public FilterProblemsAction() {
            super(DartBundle.message("filter.problems", new Object[0]), DartBundle.message("filter.problems.description", new Object[0]), AllIcons.General.Filter);
        }

        public void update(AnActionEvent e) {
            e.getPresentation().putClientProperty("selected", (Object)DartProblemsViewPanel.this.myPresentationHelper.areFiltersApplied());
        }

        public void actionPerformed(AnActionEvent e) {
            DartProblemsViewPanel.this.showFiltersPopup();
        }
    }
}

