/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.EventLog;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationSettings;
import com.intellij.notification.impl.NotificationsConfigurationImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerMessages;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.errorTreeView.AnalysisServerDiagnosticsAction;
import com.jetbrains.lang.dart.ide.errorTreeView.AnalysisServerFeedbackAction;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsPresentationHelper;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewPanel;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewSettings;
import gnu.trove.THashMap;
import icons.DartIcons;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DartProblemsView", storages={@Storage(value="$WORKSPACE_FILE$")})
public class DartProblemsView
implements PersistentStateComponent<DartProblemsViewSettings> {
    public static final String TOOLWINDOW_ID = DartBundle.message("dart.analysis.tool.window", new Object[0]);
    private static final NotificationGroup NOTIFICATION_GROUP = NotificationGroup.toolWindowGroup((String)TOOLWINDOW_ID, (String)TOOLWINDOW_ID, (boolean)false);
    private static final int TABLE_REFRESH_PERIOD = 300;
    private final Project myProject;
    private final DartProblemsPresentationHelper myPresentationHelper;
    private DartProblemsViewPanel myPanel;
    private final Object myLock;
    private final Map<String, List<AnalysisError>> myScheduledFilePathToErrors;
    private final Alarm myAlarm;
    private ToolWindow myToolWindow;
    private Icon myCurrentIcon;
    private boolean myAnalysisIsBusy;
    private int myFilesWithErrorsHash;
    private Notification myNotification;
    private boolean myDisabledForSession;
    private final Runnable myUpdateRunnable;
    public static final String OPEN_DART_ANALYSIS_LINK = "open.dart.analysis";

    public DartProblemsView(@NotNull Project project, @NotNull ToolWindowManager toolWindowManager) {
        if (project == null) {
            DartProblemsView.$$$reportNull$$$0(0);
        }
        if (toolWindowManager == null) {
            DartProblemsView.$$$reportNull$$$0(1);
        }
        this.myLock = new Object();
        this.myScheduledFilePathToErrors = new THashMap();
        this.myDisabledForSession = false;
        this.myUpdateRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                THashMap filePathToErrors;
                if ("ProjectPane".equals(ProjectView.getInstance((Project)DartProblemsView.this.myProject).getCurrentViewId())) {
                    int hash = DartAnalysisServerService.getInstance(DartProblemsView.this.myProject).getFilePathsWithErrorsHash();
                    if (DartProblemsView.this.myFilesWithErrorsHash != hash) {
                        DartProblemsView.this.myFilesWithErrorsHash = hash;
                        ProjectView.getInstance((Project)DartProblemsView.this.myProject).refresh();
                    }
                }
                Object object = DartProblemsView.this.myLock;
                synchronized (object) {
                    filePathToErrors = new THashMap(DartProblemsView.this.myScheduledFilePathToErrors);
                    DartProblemsView.this.myScheduledFilePathToErrors.clear();
                }
                DartProblemsView.this.myPanel.setErrors((Map<String, List<AnalysisError>>)filePathToErrors);
            }
        };
        this.myProject = project;
        this.myPresentationHelper = new DartProblemsPresentationHelper(project);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
        Disposer.register((Disposable)project, (Disposable)this.myAlarm);
        UIUtil.invokeLaterIfNeeded(() -> {
            if (project == null) {
                DartProblemsView.$$$reportNull$$$0(10);
            }
            if (toolWindowManager == null) {
                DartProblemsView.$$$reportNull$$$0(11);
            }
            if (project.isDisposed()) {
                return;
            }
            this.myPanel = new DartProblemsViewPanel(project, this.myPresentationHelper);
            this.myToolWindow = toolWindowManager.registerToolWindow(TOOLWINDOW_ID, false, ToolWindowAnchor.BOTTOM, (Disposable)project, true);
            this.myCurrentIcon = DartIcons.Dart_13;
            this.updateIcon();
            final Content content = ContentFactory.SERVICE.getInstance().createContent((JComponent)((Object)this.myPanel), "", false);
            this.myToolWindow.getContentManager().addContent(content);
            ToolWindowEx toolWindowEx = (ToolWindowEx)this.myToolWindow;
            toolWindowEx.setTitleActions(new AnAction[]{new AnalysisServerFeedbackAction()});
            ArrayList<AnalysisServerDiagnosticsAction> gearActions = new ArrayList<AnalysisServerDiagnosticsAction>();
            gearActions.add(new AnalysisServerDiagnosticsAction());
            toolWindowEx.setAdditionalGearActions((ActionGroup)new DefaultActionGroup(gearActions));
            this.myPanel.setToolWindowUpdater(new ToolWindowUpdater(){

                @Override
                public void setIcon(@NotNull Icon icon) {
                    if (icon == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    DartProblemsView.this.myCurrentIcon = icon;
                    DartProblemsView.this.updateIcon();
                }

                @Override
                public void setHeaderText(@NotNull String headerText) {
                    if (headerText == null) {
                        2.$$$reportNull$$$0(1);
                    }
                    content.setDisplayName(headerText);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "icon";
                            break;
                        }
                        case 1: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "headerText";
                            break;
                        }
                    }
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView$2";
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setIcon";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[2] = "setHeaderText";
                            break;
                        }
                    }
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
            if (PropertiesComponent.getInstance((Project)project).getBoolean("dart.analysis.tool.window.force.activate", true)) {
                PropertiesComponent.getInstance((Project)project).setValue("dart.analysis.tool.window.force.activate", false, true);
                this.myToolWindow.activate(null, false);
            }
            Disposer.register((Disposable)project, () -> this.myToolWindow.getContentManager().removeAllContents(true));
        });
        project.getMessageBus().connect().subscribe(DartAnalysisServerMessages.DART_ANALYSIS_TOPIC, (Object)new DartAnalysisServerMessages.DartAnalysisNotifier(){

            @Override
            public void analysisStarted() {
                DartProblemsView.this.myAnalysisIsBusy = true;
                UIUtil.invokeLaterIfNeeded(() -> DartProblemsView.this.updateIcon());
            }

            @Override
            public void analysisFinished() {
                DartProblemsView.this.myAnalysisIsBusy = false;
                UIUtil.invokeLaterIfNeeded(() -> DartProblemsView.this.updateIcon());
            }
        });
    }

    void updateIcon() {
        if (this.myAnalysisIsBusy) {
            this.myToolWindow.setIcon(ExecutionUtil.getLiveIndicator((Icon)this.myCurrentIcon));
        } else {
            this.myToolWindow.setIcon(this.myCurrentIcon);
        }
    }

    public static DartProblemsView getInstance(@NotNull Project project) {
        if (project == null) {
            DartProblemsView.$$$reportNull$$$0(2);
        }
        return (DartProblemsView)ServiceManager.getService((Project)project, DartProblemsView.class);
    }

    public void showWarningNotification(@NotNull String title, @Nullable String content, @Nullable Icon icon) {
        if (title == null) {
            DartProblemsView.$$$reportNull$$$0(3);
        }
        this.showNotification(NotificationType.WARNING, title, content, icon, false);
    }

    public void showErrorNotificationTerse(@NotNull String title) {
        if (title == null) {
            DartProblemsView.$$$reportNull$$$0(4);
        }
        this.showNotification(NotificationType.ERROR, title, null, null, true);
    }

    public void showErrorNotification(@NotNull String title, @Nullable String content, @Nullable Icon icon) {
        if (title == null) {
            DartProblemsView.$$$reportNull$$$0(5);
        }
        this.showNotification(NotificationType.ERROR, title, content, icon, false);
    }

    public void clearNotifications() {
        if (this.myNotification != null) {
            this.myNotification.expire();
            this.myNotification = null;
        }
    }

    private void showNotification(@NotNull NotificationType notificationType, @NotNull String title, @Nullable String content, @Nullable Icon icon, boolean terse) {
        if (notificationType == null) {
            DartProblemsView.$$$reportNull$$$0(6);
        }
        if (title == null) {
            DartProblemsView.$$$reportNull$$$0(7);
        }
        this.clearNotifications();
        if (this.myDisabledForSession) {
            return;
        }
        content = StringUtil.notNullize((String)content);
        if (!terse) {
            if (!content.endsWith("<br>")) {
                content = content + "<br>";
            }
            content = content + "<br><a href='disable.for.session'>Don't show for this session</a>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<a href='never.show.again'>Never show again</a>";
        }
        this.myNotification = NOTIFICATION_GROUP.createNotification(title, content, notificationType, (NotificationListener)new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    4.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    4.$$$reportNull$$$0(1);
                }
                notification.expire();
                if (DartProblemsView.OPEN_DART_ANALYSIS_LINK.equals(e.getDescription())) {
                    ToolWindowManager.getInstance((Project)DartProblemsView.this.myProject).getToolWindow(TOOLWINDOW_ID).activate(null);
                } else if ("disable.for.session".equals(e.getDescription())) {
                    DartProblemsView.this.myDisabledForSession = true;
                } else if ("never.show.again".equals(e.getDescription())) {
                    NOTIFICATION_GROUP.createNotification("Warning disabled.", "You can enable it back in the <a href=''>Event Log</a> settings.", NotificationType.INFORMATION, (NotificationListener)new NotificationListener.Adapter(){

                        protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                            if (notification == null) {
                                1.$$$reportNull$$$0(0);
                            }
                            if (e == null) {
                                1.$$$reportNull$$$0(1);
                            }
                            notification.expire();
                            ToolWindow toolWindow = EventLog.getEventLog((Project)DartProblemsView.this.myProject);
                            if (toolWindow != null) {
                                toolWindow.activate(null);
                            }
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2 = new Object[3];
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "notification";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[0] = "e";
                                    break;
                                }
                            }
                            objectArray[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView$4$1";
                            objectArray[2] = "hyperlinkActivated";
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                        }
                    }).notify(DartProblemsView.this.myProject);
                    NotificationSettings oldSettings = NotificationsConfigurationImpl.getSettings((String)notification.getGroupId());
                    NotificationsConfigurationImpl.getInstanceImpl().changeSettings(oldSettings.getGroupId(), NotificationDisplayType.NONE, oldSettings.isShouldLog(), oldSettings.isShouldReadAloud());
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView$4";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        if (icon != null) {
            this.myNotification.setIcon(icon);
        }
        this.myNotification.notify(this.myProject);
    }

    public DartProblemsViewSettings getState() {
        return this.myPresentationHelper.getSettings();
    }

    public void loadState(DartProblemsViewSettings state) {
        this.myPresentationHelper.setSettings(state);
        if (this.myPanel != null) {
            this.myPanel.fireGroupingOrFilterChanged();
        }
    }

    public void setCurrentFile(@Nullable VirtualFile file) {
        if (this.myPresentationHelper.setCurrentFile(file) && this.myPresentationHelper.getFileFilterMode() != DartProblemsViewSettings.FileFilterMode.All && this.myPanel != null) {
            this.myPanel.fireGroupingOrFilterChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateErrorsForFile(@NotNull String filePath, @NotNull List<AnalysisError> errors) {
        if (filePath == null) {
            DartProblemsView.$$$reportNull$$$0(8);
        }
        if (errors == null) {
            DartProblemsView.$$$reportNull$$$0(9);
        }
        Object object = this.myLock;
        synchronized (object) {
            if (this.myScheduledFilePathToErrors.isEmpty()) {
                this.myAlarm.addRequest(this.myUpdateRunnable, 300, ModalityState.NON_MODAL);
            }
            this.myScheduledFilePathToErrors.put(filePath, errors);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        ProjectView.getInstance((Project)this.myProject).refresh();
        Object object = this.myLock;
        synchronized (object) {
            this.myAlarm.cancelAllRequests();
            this.myScheduledFilePathToErrors.clear();
        }
        this.myPanel.clearAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindowManager";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "title";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notificationType";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsView";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getInstance";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "showWarningNotification";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorNotificationTerse";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "showErrorNotification";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "showNotification";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "updateErrorsForFile";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static interface ToolWindowUpdater {
        public void setIcon(@NotNull Icon var1);

        public void setHeaderText(@NotNull String var1);
    }
}

