/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.lang.dart.ide.annotator.DartAnnotator;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblem;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsPresentationHelper;
import icons.DartIcons;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DartProblemsTableModel
extends ListTableModel<DartProblem> {
    private static final TableCellRenderer MESSAGE_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel label = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
            DartProblem problem = (DartProblem)value;
            this.setText(problem.getErrorMessage());
            this.setToolTipText(DartProblemsTableModel.generateToolTipText(problem.getErrorMessage(), problem.getCorrectionMessage()));
            String severity = problem.getSeverity();
            this.setIcon("ERROR".equals(severity) ? AllIcons.General.Error : ("WARNING".equals(severity) ? DartIcons.Dart_warning : AllIcons.General.Information));
            return label;
        }
    };
    private static final TableCellRenderer LOCATION_RENDERER = new DefaultTableCellRenderer(){

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            return super.getTableCellRendererComponent(table, value, isSelected, false, row, column);
        }
    };
    private final Project myProject;
    @NotNull
    private final DartProblemsPresentationHelper myPresentationHelper;
    private final List<DartProblem> myItems;
    private RowSorter.SortKey mySortKey;
    private int myErrorCount;
    private int myWarningCount;
    private int myHintCount;
    private int myErrorCountAfterFilter;
    private int myWarningCountAfterFilter;
    private int myHintCountAfterFilter;
    private final Comparator<DartProblem> myDescriptionComparator;
    private final Comparator<DartProblem> myLocationComparator;

    @NotNull
    private static String generateToolTipText(@Nullable String message, @Nullable String correction) {
        String messageSanitized = StringUtil.notNullize((String)message).replaceAll("\\\\n", "\n");
        String correctionSanitized = StringUtil.notNullize((String)correction).replaceAll("\\\\n", "\n");
        String string = correctionSanitized.isEmpty() ? messageSanitized : messageSanitized + "\n\n" + correctionSanitized;
        if (string == null) {
            DartProblemsTableModel.$$$reportNull$$$0(0);
        }
        return string;
    }

    public DartProblemsTableModel(@NotNull Project project, @NotNull DartProblemsPresentationHelper presentationHelper) {
        if (project == null) {
            DartProblemsTableModel.$$$reportNull$$$0(1);
        }
        if (presentationHelper == null) {
            DartProblemsTableModel.$$$reportNull$$$0(2);
        }
        super(new ColumnInfo[0]);
        this.mySortKey = new RowSorter.SortKey(1, SortOrder.ASCENDING);
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myHintCount = 0;
        this.myErrorCountAfterFilter = 0;
        this.myWarningCountAfterFilter = 0;
        this.myHintCountAfterFilter = 0;
        this.myDescriptionComparator = new DartProblemsComparator(0);
        this.myLocationComparator = new DartProblemsComparator(1);
        this.myProject = project;
        this.myPresentationHelper = presentationHelper;
        this.myItems = new ArrayList<DartProblem>();
        this.setColumnInfos(new ColumnInfo[]{this.createDescriptionColumn(), this.createLocationColumn()});
        this.setItems(this.myItems);
        this.setSortable(true);
    }

    @NotNull
    private ColumnInfo<DartProblem, DartProblem> createDescriptionColumn() {
        ColumnInfo<DartProblem, DartProblem> columnInfo = new ColumnInfo<DartProblem, DartProblem>("Description"){

            @Nullable
            public Comparator<DartProblem> getComparator() {
                return DartProblemsTableModel.this.myDescriptionComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(@NotNull DartProblem problem) {
                if (problem == null) {
                    3.$$$reportNull$$$0(0);
                }
                return MESSAGE_RENDERER;
            }

            @NotNull
            public DartProblem valueOf(@NotNull DartProblem problem) {
                if (problem == null) {
                    3.$$$reportNull$$$0(1);
                }
                DartProblem dartProblem = problem;
                if (dartProblem == null) {
                    3.$$$reportNull$$$0(2);
                }
                return dartProblem;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 2: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 2: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problem";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel$3";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel$3";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "getRenderer";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 2: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (columnInfo == null) {
            DartProblemsTableModel.$$$reportNull$$$0(3);
        }
        return columnInfo;
    }

    @NotNull
    private ColumnInfo<DartProblem, String> createLocationColumn() {
        ColumnInfo<DartProblem, String> columnInfo = new ColumnInfo<DartProblem, String>("Location"){

            @Nullable
            public Comparator<DartProblem> getComparator() {
                return DartProblemsTableModel.this.myLocationComparator;
            }

            @Nullable
            public TableCellRenderer getRenderer(DartProblem problem) {
                return LOCATION_RENDERER;
            }

            @NotNull
            public String valueOf(@NotNull DartProblem problem) {
                if (problem == null) {
                    4.$$$reportNull$$$0(0);
                }
                String string = problem.getPresentableLocation();
                if (string == null) {
                    4.$$$reportNull$$$0(1);
                }
                return string;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                    case 1: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 3;
                        break;
                    }
                    case 1: {
                        n2 = 2;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "problem";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel$4";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel$4";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "valueOf";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "valueOf";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                    case 1: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
        if (columnInfo == null) {
            DartProblemsTableModel.$$$reportNull$$$0(4);
        }
        return columnInfo;
    }

    public RowSorter.SortKey getDefaultSortKey() {
        return this.mySortKey;
    }

    public boolean canExchangeRows(int oldIndex, int newIndex) {
        return false;
    }

    public void exchangeRows(int idx1, int idx2) {
        throw new IllegalStateException();
    }

    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public void removeRows(int firstRow, int lastRow) {
        assert (lastRow >= firstRow);
        for (int i = lastRow; i >= firstRow; --i) {
            DartProblem removed = this.myItems.remove(i);
            if ("ERROR".equals(removed.getSeverity())) {
                --this.myErrorCount;
            }
            if ("WARNING".equals(removed.getSeverity())) {
                --this.myWarningCount;
            }
            if ("INFO".equals(removed.getSeverity())) {
                --this.myHintCount;
            }
            this.updateProblemsCountAfterFilter(removed, false);
        }
        this.fireTableRowsDeleted(firstRow, lastRow);
    }

    public void removeAll() {
        int rowCount = this.getRowCount();
        if (rowCount > 0) {
            this.myItems.clear();
            this.fireTableRowsDeleted(0, rowCount - 1);
        }
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myHintCount = 0;
        this.myErrorCountAfterFilter = 0;
        this.myWarningCountAfterFilter = 0;
        this.myHintCountAfterFilter = 0;
    }

    @Nullable
    public DartProblem setErrorsAndReturnReplacementForSelection(@NotNull Map<String, List<AnalysisError>> filePathToErrors, @Nullable DartProblem selectedProblem) {
        boolean selectedProblemRemoved;
        if (filePathToErrors == null) {
            DartProblemsTableModel.$$$reportNull$$$0(5);
        }
        return this.addErrorsAndReturnReplacementForSelection(filePathToErrors, (selectedProblemRemoved = this.removeRowsForFilesInSet(filePathToErrors.keySet(), selectedProblem)) ? selectedProblem : null);
    }

    private boolean removeRowsForFilesInSet(@NotNull Set<String> filePaths, @Nullable DartProblem selectedProblem) {
        if (filePaths == null) {
            DartProblemsTableModel.$$$reportNull$$$0(6);
        }
        boolean selectedProblemRemoved = false;
        int matchedFilesCount = 0;
        for (int i = this.getRowCount() - 1; i >= 0; --i) {
            DartProblem problem = (DartProblem)this.getItem(i);
            if (!filePaths.contains(problem.getSystemIndependentPath())) continue;
            ++matchedFilesCount;
            int lastRowToDelete = i;
            if (problem == selectedProblem) {
                selectedProblemRemoved = true;
            }
            DartProblem lastProblemForCurrentFile = problem;
            int j = i - 1;
            while (j >= 0) {
                DartProblem previousProblem = (DartProblem)this.getItem(j);
                if (previousProblem.getSystemIndependentPath().equals(lastProblemForCurrentFile.getSystemIndependentPath())) {
                    --j;
                    if (previousProblem != selectedProblem) continue;
                    selectedProblemRemoved = true;
                    continue;
                }
                if (!filePaths.contains(previousProblem.getSystemIndependentPath())) break;
                ++matchedFilesCount;
                lastProblemForCurrentFile = previousProblem;
                --j;
                if (previousProblem != selectedProblem) continue;
                selectedProblemRemoved = true;
            }
            int firstRowToDelete = j + 1;
            this.removeRows(firstRowToDelete, lastRowToDelete);
            if (matchedFilesCount == filePaths.size()) break;
            i = j + 1;
        }
        return selectedProblemRemoved;
    }

    @Nullable
    private DartProblem addErrorsAndReturnReplacementForSelection(@NotNull Map<String, List<AnalysisError>> filePathToErrors, @Nullable DartProblem oldSelectedProblem) {
        if (filePathToErrors == null) {
            DartProblemsTableModel.$$$reportNull$$$0(7);
        }
        DartProblem newSelectedProblem = null;
        ArrayList<DartProblem> problemsToAdd = new ArrayList<DartProblem>();
        for (Map.Entry<String, List<AnalysisError>> entry : filePathToErrors.entrySet()) {
            String filePath = entry.getKey();
            VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(filePath);
            List<AnalysisError> errors = vFile != null && ProjectFileIndex.getInstance((Project)this.myProject).isInContent(vFile) ? entry.getValue() : AnalysisError.EMPTY_LIST;
            for (AnalysisError analysisError : errors) {
                if (DartAnnotator.shouldIgnoreMessageFromDartAnalyzer(filePath, analysisError.getLocation().getFile())) continue;
                DartProblem problem = new DartProblem(this.myProject, analysisError);
                problemsToAdd.add(problem);
                if (oldSelectedProblem != null && DartProblemsTableModel.lookSimilar(problem, oldSelectedProblem) && (newSelectedProblem == null || Math.abs(oldSelectedProblem.getLineNumber() - newSelectedProblem.getLineNumber()) >= Math.abs(oldSelectedProblem.getLineNumber() - problem.getLineNumber()))) {
                    newSelectedProblem = problem;
                }
                if ("ERROR".equals(problem.getSeverity())) {
                    ++this.myErrorCount;
                }
                if ("WARNING".equals(problem.getSeverity())) {
                    ++this.myWarningCount;
                }
                if ("INFO".equals(problem.getSeverity())) {
                    ++this.myHintCount;
                }
                this.updateProblemsCountAfterFilter(problem, true);
            }
        }
        if (!problemsToAdd.isEmpty()) {
            this.addRows(problemsToAdd);
        }
        return newSelectedProblem;
    }

    private static boolean lookSimilar(@NotNull DartProblem problem1, @NotNull DartProblem problem2) {
        if (problem1 == null) {
            DartProblemsTableModel.$$$reportNull$$$0(8);
        }
        if (problem2 == null) {
            DartProblemsTableModel.$$$reportNull$$$0(9);
        }
        return problem1.getSeverity().equals(problem2.getSeverity()) && problem1.getErrorMessage().equals(problem2.getErrorMessage()) && problem1.getSystemIndependentPath().equals(problem2.getSystemIndependentPath());
    }

    private void updateProblemsCountAfterFilter(@NotNull DartProblem problem, boolean incrementNotDecrement) {
        if (problem == null) {
            DartProblemsTableModel.$$$reportNull$$$0(10);
        }
        if (this.myPresentationHelper.shouldShowProblem(problem)) {
            if (incrementNotDecrement) {
                if ("ERROR".equals(problem.getSeverity())) {
                    ++this.myErrorCountAfterFilter;
                }
                if ("WARNING".equals(problem.getSeverity())) {
                    ++this.myWarningCountAfterFilter;
                }
                if ("INFO".equals(problem.getSeverity())) {
                    ++this.myHintCountAfterFilter;
                }
            } else {
                if ("ERROR".equals(problem.getSeverity())) {
                    --this.myErrorCountAfterFilter;
                }
                if ("WARNING".equals(problem.getSeverity())) {
                    --this.myWarningCountAfterFilter;
                }
                if ("INFO".equals(problem.getSeverity())) {
                    --this.myHintCountAfterFilter;
                }
            }
        }
    }

    public void setSortKey(@NotNull RowSorter.SortKey sortKey) {
        if (sortKey == null) {
            DartProblemsTableModel.$$$reportNull$$$0(11);
        }
        this.mySortKey = sortKey;
    }

    public void onFilterChanged() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (this.myPresentationHelper.areFiltersApplied()) {
            this.myErrorCountAfterFilter = 0;
            this.myWarningCountAfterFilter = 0;
            this.myHintCountAfterFilter = 0;
            for (DartProblem problem : this.myItems) {
                this.updateProblemsCountAfterFilter(problem, true);
            }
        } else {
            this.myErrorCountAfterFilter = this.myErrorCount;
            this.myWarningCountAfterFilter = this.myWarningCount;
            this.myHintCountAfterFilter = this.myHintCount;
        }
    }

    boolean hasErrors() {
        return this.myErrorCount > 0;
    }

    boolean hasWarnings() {
        return this.myWarningCount > 0;
    }

    @NotNull
    public String getStatusText() {
        StringBuilder b = new StringBuilder();
        ArrayList<String> summary = new ArrayList<String>();
        if (this.myPresentationHelper.isShowErrors() && this.myErrorCountAfterFilter > 0) {
            summary.add(this.myErrorCountAfterFilter + " " + StringUtil.pluralize((String)"error", (int)this.myErrorCountAfterFilter));
        }
        if (this.myPresentationHelper.isShowWarnings() && this.myWarningCountAfterFilter > 0) {
            summary.add(this.myWarningCountAfterFilter + " " + StringUtil.pluralize((String)"warning", (int)this.myWarningCountAfterFilter));
        }
        if (this.myPresentationHelper.isShowHints() && this.myHintCountAfterFilter > 0) {
            summary.add(this.myHintCountAfterFilter + " " + StringUtil.pluralize((String)"hint", (int)this.myHintCountAfterFilter));
        }
        if (summary.isEmpty()) {
            if (this.myPresentationHelper.areFiltersApplied()) {
                String string = this.getFilterTypeText();
                if (string == null) {
                    DartProblemsTableModel.$$$reportNull$$$0(12);
                }
                return string;
            }
            if ("" == null) {
                DartProblemsTableModel.$$$reportNull$$$0(13);
            }
            return "";
        }
        if (summary.size() == 2) {
            b.append(StringUtil.join(summary, (String)" and "));
        } else {
            b.append(StringUtil.join(summary, (String)", "));
        }
        if (this.myPresentationHelper.areFiltersApplied()) {
            b.append(" (");
            b.append(this.getFilterTypeText());
            b.append(")");
        }
        String string = b.toString();
        if (string == null) {
            DartProblemsTableModel.$$$reportNull$$$0(14);
        }
        return string;
    }

    private String getFilterTypeText() {
        StringBuilder builder = new StringBuilder();
        switch (this.myPresentationHelper.getFileFilterMode()) {
            case All: {
                break;
            }
            case ContentRoot: {
                builder.append("filtering by current content root");
                break;
            }
            case DartPackage: {
                builder.append("filtering by current Dart package");
                break;
            }
            case Directory: {
                builder.append("filtering by current directory");
                break;
            }
            case File: {
                builder.append("filtering by current file");
            }
        }
        if (!(this.myPresentationHelper.isShowErrors() && this.myPresentationHelper.isShowWarnings() && this.myPresentationHelper.isShowHints())) {
            builder.append(builder.length() == 0 ? "filtering by severity" : " and severity");
        }
        return builder.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentationHelper";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePathToErrors";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePaths";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem1";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem2";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "generateToolTipText";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createDescriptionColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createLocationColumn";
                break;
            }
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setErrorsAndReturnReplacementForSelection";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "removeRowsForFilesInSet";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addErrorsAndReturnReplacementForSelection";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lookSimilar";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "updateProblemsCountAfterFilter";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setSortKey";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DartProblemsComparator
    implements Comparator<DartProblem> {
        private static final int MESSAGE_COLUMN_ID = 0;
        private static final int LOCATION_COLUMN_ID = 1;
        private final int myColumn;

        DartProblemsComparator(int column) {
            this.myColumn = column;
        }

        @Override
        public int compare(@NotNull DartProblem problem1, @NotNull DartProblem problem2) {
            int s2;
            int s1;
            if (problem1 == null) {
                DartProblemsComparator.$$$reportNull$$$0(0);
            }
            if (problem2 == null) {
                DartProblemsComparator.$$$reportNull$$$0(1);
            }
            if (DartProblemsTableModel.this.myPresentationHelper.isGroupBySeverity() && (s1 = this.getSeverityIndex(problem1)) != (s2 = this.getSeverityIndex(problem2))) {
                return DartProblemsTableModel.this.mySortKey.getSortOrder() == SortOrder.ASCENDING ? s1 - s2 : s2 - s1;
            }
            if (this.myColumn == 0) {
                return StringUtil.compare((String)problem1.getErrorMessage(), (String)problem2.getErrorMessage(), (boolean)false);
            }
            if (this.myColumn == 1) {
                int result = StringUtil.compare((String)problem1.getPresentableLocationWithoutLineNumber(), (String)problem2.getPresentableLocationWithoutLineNumber(), (boolean)false);
                if (result != 0) {
                    return result;
                }
                return DartProblemsTableModel.this.mySortKey.getSortOrder() == SortOrder.ASCENDING ? problem1.getLineNumber() - problem2.getLineNumber() : problem2.getLineNumber() - problem1.getLineNumber();
            }
            return 0;
        }

        private int getSeverityIndex(@NotNull DartProblem problem) {
            String severity;
            if (problem == null) {
                DartProblemsComparator.$$$reportNull$$$0(2);
            }
            if ("ERROR".equals(severity = problem.getSeverity())) {
                return 0;
            }
            if ("WARNING".equals(severity)) {
                return 1;
            }
            return 2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "problem";
                    break;
                }
            }
            objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsTableModel$DartProblemsComparator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "compare";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getSeverityIndex";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

