/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblem;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsFilterForm;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsTableModel;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsViewSettings;
import com.jetbrains.lang.dart.util.DartBuildFileUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import javax.swing.RowFilter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemsPresentationHelper {
    @NotNull
    private final Project myProject;
    @NotNull
    DartProblemsViewSettings mySettings;
    @Nullable
    private VirtualFile myCurrentFile;
    private boolean myDartPackageRootUpToDate;
    @Nullable
    private VirtualFile myCurrentDartPackageRoot;
    private boolean myContentRootUpToDate;
    @Nullable
    private VirtualFile myCurrentContentRoot;

    public DartProblemsPresentationHelper(@NotNull Project project) {
        if (project == null) {
            DartProblemsPresentationHelper.$$$reportNull$$$0(0);
        }
        this.myDartPackageRootUpToDate = false;
        this.myContentRootUpToDate = false;
        this.myProject = project;
        this.mySettings = new DartProblemsViewSettings();
    }

    public void setSettings(@NotNull DartProblemsViewSettings settings) {
        if (settings == null) {
            DartProblemsPresentationHelper.$$$reportNull$$$0(1);
        }
        this.mySettings = settings;
    }

    @NotNull
    public DartProblemsViewSettings getSettings() {
        DartProblemsViewSettings dartProblemsViewSettings = this.mySettings;
        if (dartProblemsViewSettings == null) {
            DartProblemsPresentationHelper.$$$reportNull$$$0(2);
        }
        return dartProblemsViewSettings;
    }

    public RowFilter<DartProblemsTableModel, Integer> getRowFilter() {
        return new RowFilter<DartProblemsTableModel, Integer>(){

            @Override
            public boolean include(@NotNull RowFilter.Entry<? extends DartProblemsTableModel, ? extends Integer> entry) {
                if (entry == null) {
                    1.$$$reportNull$$$0(0);
                }
                return DartProblemsPresentationHelper.this.shouldShowProblem((DartProblem)entry.getModel().getItem(entry.getIdentifier()));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsPresentationHelper$1", "include"));
            }
        };
    }

    public void resetAllFilters() {
        this.mySettings.showErrors = true;
        this.mySettings.showWarnings = true;
        this.mySettings.showHints = true;
        this.mySettings.fileFilterMode = DartProblemsViewSettings.FILE_FILTER_MODE_DEFAULT;
        assert (!this.areFiltersApplied());
    }

    public void updateFromUI(@NotNull DartProblemsFilterForm form) {
        if (form == null) {
            DartProblemsPresentationHelper.$$$reportNull$$$0(3);
        }
        this.mySettings.showErrors = form.isShowErrors();
        this.mySettings.showWarnings = form.isShowWarnings();
        this.mySettings.showHints = form.isShowHints();
        this.mySettings.fileFilterMode = form.getFileFilterMode();
    }

    public boolean areFiltersApplied() {
        if (!this.mySettings.showErrors) {
            return true;
        }
        if (!this.mySettings.showWarnings) {
            return true;
        }
        if (!this.mySettings.showHints) {
            return true;
        }
        return this.mySettings.fileFilterMode != DartProblemsViewSettings.FILE_FILTER_MODE_DEFAULT;
    }

    public boolean setCurrentFile(@Nullable VirtualFile file) {
        if (Comparing.equal((Object)this.myCurrentFile, (Object)file)) {
            return false;
        }
        this.myCurrentFile = file;
        this.myDartPackageRootUpToDate = false;
        this.myContentRootUpToDate = false;
        return true;
    }

    public boolean isAutoScrollToSource() {
        return this.mySettings.autoScrollToSource;
    }

    public void setAutoScrollToSource(boolean autoScroll) {
        this.mySettings.autoScrollToSource = autoScroll;
    }

    public boolean isGroupBySeverity() {
        return this.mySettings.groupBySeverity;
    }

    public void setGroupBySeverity(boolean groupBySeverity) {
        this.mySettings.groupBySeverity = groupBySeverity;
    }

    public boolean isShowErrors() {
        return this.mySettings.showErrors;
    }

    public boolean isShowWarnings() {
        return this.mySettings.showWarnings;
    }

    public boolean isShowHints() {
        return this.mySettings.showHints;
    }

    public DartProblemsViewSettings.FileFilterMode getFileFilterMode() {
        return this.mySettings.fileFilterMode;
    }

    public boolean shouldShowProblem(@NotNull DartProblem problem) {
        if (problem == null) {
            DartProblemsPresentationHelper.$$$reportNull$$$0(4);
        }
        if (!this.isShowErrors() && "ERROR".equals(problem.getSeverity())) {
            return false;
        }
        if (!this.isShowWarnings() && "WARNING".equals(problem.getSeverity())) {
            return false;
        }
        if (!this.isShowHints() && "INFO".equals(problem.getSeverity())) {
            return false;
        }
        if (!(this.getFileFilterMode() != DartProblemsViewSettings.FileFilterMode.File || this.myCurrentFile != null && this.myCurrentFile.equals(problem.getFile()))) {
            return false;
        }
        if (this.getFileFilterMode() == DartProblemsViewSettings.FileFilterMode.Directory) {
            if (this.myCurrentFile == null) {
                return false;
            }
            VirtualFile parent = this.myCurrentFile.getParent();
            VirtualFile child = problem.getFile();
            if (child != null && parent != null && !child.getPath().startsWith(parent.getPath() + "/")) {
                return false;
            }
        }
        if (this.getFileFilterMode() == DartProblemsViewSettings.FileFilterMode.DartPackage) {
            this.ensurePackageRootUpToDate();
            if (this.myCurrentDartPackageRoot == null || !this.myCurrentDartPackageRoot.equals(problem.getPackageRoot())) {
                return false;
            }
        }
        if (this.getFileFilterMode() == DartProblemsViewSettings.FileFilterMode.ContentRoot) {
            this.ensureContentRootUpToDate();
            if (this.myCurrentContentRoot == null || !this.myCurrentContentRoot.equals(problem.getContentRoot())) {
                return false;
            }
        }
        return true;
    }

    private void ensurePackageRootUpToDate() {
        VirtualFile packageRoot;
        if (this.myDartPackageRootUpToDate) {
            return;
        }
        if (this.myCurrentFile == null) {
            packageRoot = null;
        } else {
            VirtualFile pubspec = Registry.is((String)"dart.projects.without.pubspec", (boolean)false) ? DartBuildFileUtil.findPackageRootBuildFile(this.myProject, this.myCurrentFile) : PubspecYamlUtil.findPubspecYamlFile(this.myProject, this.myCurrentFile);
            packageRoot = pubspec == null ? ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myCurrentFile, false) : pubspec.getParent();
        }
        this.myCurrentDartPackageRoot = packageRoot;
        this.myDartPackageRootUpToDate = true;
    }

    private void ensureContentRootUpToDate() {
        if (this.myContentRootUpToDate) {
            return;
        }
        this.myCurrentContentRoot = this.myCurrentFile == null ? null : ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myCurrentFile, false);
        this.myContentRootUpToDate = true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsPresentationHelper";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "form";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "problem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblemsPresentationHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSettings";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setSettings";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateFromUI";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "shouldShowProblem";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

