/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.util.DartBuildFileUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.io.File;
import org.dartlang.analysis.server.protocol.AnalysisError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblem {
    @NotNull
    private final Project myProject;
    @NotNull
    private final AnalysisError myAnalysisError;
    private String mySystemIndependentPath;
    @Nullable
    private VirtualFile myFile;
    @Nullable
    private VirtualFile myPackageRoot;
    @Nullable
    private VirtualFile myContentRoot;
    private String myPresentableLocationWithoutLineNumber;

    public DartProblem(@NotNull Project project, @NotNull AnalysisError error) {
        if (project == null) {
            DartProblem.$$$reportNull$$$0(0);
        }
        if (error == null) {
            DartProblem.$$$reportNull$$$0(1);
        }
        this.myProject = project;
        this.myAnalysisError = error;
    }

    @NotNull
    public String getErrorMessage() {
        String string = this.myAnalysisError.getMessage();
        if (string == null) {
            DartProblem.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getCorrectionMessage() {
        String string = StringUtil.notNullize((String)this.myAnalysisError.getCorrection());
        if (string == null) {
            DartProblem.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getCode() {
        String string = StringUtil.notNullize((String)this.myAnalysisError.getCode());
        if (string == null) {
            DartProblem.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getSeverity() {
        return this.myAnalysisError.getSeverity();
    }

    public int getLineNumber() {
        return this.myAnalysisError.getLocation().getStartLine();
    }

    public int getOffset() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.mySystemIndependentPath);
        return DartAnalysisServerService.getInstance(this.myProject).getConvertedOffset(file, this.myAnalysisError.getLocation().getOffset());
    }

    @NotNull
    public String getSystemIndependentPath() {
        if (this.mySystemIndependentPath == null) {
            this.mySystemIndependentPath = FileUtil.toSystemIndependentName((String)this.myAnalysisError.getLocation().getFile());
        }
        String string = this.mySystemIndependentPath;
        if (string == null) {
            DartProblem.$$$reportNull$$$0(5);
        }
        return string;
    }

    private void ensureInitialized() {
        String presentableFilePath;
        VirtualFile contentRoot;
        VirtualFile packageRoot;
        String dartPackageName;
        if (this.myPresentableLocationWithoutLineNumber != null) {
            return;
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(this.getSystemIndependentPath());
        if (file == null) {
            dartPackageName = null;
            packageRoot = null;
            contentRoot = null;
            presentableFilePath = this.myAnalysisError.getLocation().getFile();
        } else {
            VirtualFile pubspec;
            contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(file, false);
            VirtualFile virtualFile = pubspec = Registry.is((String)"dart.projects.without.pubspec", (boolean)false) ? DartBuildFileUtil.findPackageRootBuildFile(this.myProject, file) : PubspecYamlUtil.findPubspecYamlFile(this.myProject, file);
            if (pubspec == null) {
                dartPackageName = null;
                if (contentRoot == null) {
                    packageRoot = null;
                    presentableFilePath = this.myAnalysisError.getLocation().getFile();
                } else {
                    packageRoot = contentRoot;
                    String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)contentRoot, (char)File.separatorChar);
                    presentableFilePath = relativePath != null ? relativePath : this.myAnalysisError.getLocation().getFile();
                }
            } else {
                String projectName = Registry.is((String)"dart.projects.without.pubspec", (boolean)false) ? DartBuildFileUtil.getDartProjectName(pubspec) : PubspecYamlUtil.getDartProjectName(pubspec);
                dartPackageName = projectName != null ? projectName : "%unnamed%";
                packageRoot = pubspec.getParent();
                String relativePath = VfsUtilCore.getRelativePath((VirtualFile)file, (VirtualFile)pubspec.getParent(), (char)File.separatorChar);
                presentableFilePath = relativePath != null ? relativePath : this.myAnalysisError.getLocation().getFile();
            }
        }
        this.myFile = file;
        this.myPackageRoot = packageRoot;
        this.myContentRoot = contentRoot;
        this.myPresentableLocationWithoutLineNumber = dartPackageName == null ? presentableFilePath : "[" + dartPackageName + "] " + presentableFilePath;
    }

    @NotNull
    public String getPresentableLocationWithoutLineNumber() {
        this.ensureInitialized();
        String string = this.myPresentableLocationWithoutLineNumber;
        if (string == null) {
            DartProblem.$$$reportNull$$$0(6);
        }
        return string;
    }

    @NotNull
    public String getPresentableLocation() {
        String string = this.getPresentableLocationWithoutLineNumber() + ":" + this.getLineNumber();
        if (string == null) {
            DartProblem.$$$reportNull$$$0(7);
        }
        return string;
    }

    @Nullable
    public VirtualFile getFile() {
        this.ensureInitialized();
        return this.myFile;
    }

    @Nullable
    public VirtualFile getPackageRoot() {
        this.ensureInitialized();
        return this.myPackageRoot;
    }

    @Nullable
    public VirtualFile getContentRoot() {
        this.ensureInitialized();
        return this.myContentRoot;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblem";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartProblem";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getErrorMessage";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCorrectionMessage";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCode";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocationWithoutLineNumber";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentableLocation";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

