/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.notification.Notification;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.impl.NotificationsManagerImpl;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.BalloonLayout;
import com.intellij.ui.BalloonLayoutData;
import com.intellij.ui.JBColor;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DartFeedbackBuilder {
    public static final int MAX_URL_LENGTH = 1900;
    private static final NotificationGroup NOTIFICATION_GROUP = new NotificationGroup("Dart Analyzer Error", NotificationDisplayType.NONE, true);
    private static final ExtensionPointName<DartFeedbackBuilder> EP_NAME = ExtensionPointName.create((String)"Dart.feedbackBuilder");

    @NotNull
    public static DartFeedbackBuilder getFeedbackBuilder() {
        DartFeedbackBuilder[] builders = (DartFeedbackBuilder[])EP_NAME.getExtensions();
        assert (builders.length > 0);
        DartFeedbackBuilder dartFeedbackBuilder = builders[0];
        if (dartFeedbackBuilder == null) {
            DartFeedbackBuilder.$$$reportNull$$$0(0);
        }
        return dartFeedbackBuilder;
    }

    public String title() {
        return "Open Browser";
    }

    public abstract String prompt();

    public String label() {
        return "Send feedback";
    }

    public abstract void sendFeedback(@NotNull Project var1, @Nullable String var2, @Nullable String var3);

    public void showNotification(@NotNull String message, final @NotNull Project project, final @Nullable String errorMessage, final @Nullable String debugLog) {
        if (message == null) {
            DartFeedbackBuilder.$$$reportNull$$$0(1);
        }
        if (project == null) {
            DartFeedbackBuilder.$$$reportNull$$$0(2);
        }
        String content = message + "<br><a href=\"\">" + this.prompt() + "</a>";
        NotificationListener.Adapter listener = new NotificationListener.Adapter(){

            protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                if (notification == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                notification.expire();
                DartFeedbackBuilder.this.sendFeedback(project, errorMessage, debugLog);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "notification";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "e";
                        break;
                    }
                }
                objectArray[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder$1";
                objectArray[2] = "hyperlinkActivated";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Notification notification = NOTIFICATION_GROUP.createNotification(NOTIFICATION_GROUP.getDisplayId(), content, NotificationType.ERROR, (NotificationListener)listener);
        notification.notify(project);
        ApplicationManager.getApplication().invokeLater(() -> {
            if (project == null) {
                DartFeedbackBuilder.$$$reportNull$$$0(5);
            }
            DartFeedbackBuilder.showErrorNotification(notification, project);
        }, ModalityState.NON_MODAL, project.getDisposed());
    }

    private static void showErrorNotification(@NotNull Notification notification, @NotNull Project project) {
        if (notification == null) {
            DartFeedbackBuilder.$$$reportNull$$$0(3);
        }
        if (project == null) {
            DartFeedbackBuilder.$$$reportNull$$$0(4);
        }
        IdeFrame myFrame = WindowManager.getInstance().getIdeFrame(project);
        BalloonLayout layout = myFrame.getBalloonLayout();
        assert (layout != null);
        BalloonLayoutData layoutData = BalloonLayoutData.createEmpty();
        layoutData.fadeoutTime = 5000L;
        layoutData.fillColor = new JBColor(16115431, 5848385);
        layoutData.borderColor = new JBColor(14723241, 7554379);
        Balloon balloon = NotificationsManagerImpl.createBalloon((IdeFrame)myFrame, (Notification)notification, (boolean)false, (boolean)false, (Ref)new Ref((Object)layoutData), (Disposable)project);
        layout.add(balloon);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "notification";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getFeedbackBuilder";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/errorTreeView/DartFeedbackBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "showNotification";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorNotification";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "lambda$showNotification$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

