/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindowManager;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.ide.errorTreeView.DartFeedbackBuilder;
import com.jetbrains.lang.dart.ide.errorTreeView.DartProblemsView;
import icons.DartIcons;
import org.jetbrains.annotations.Nullable;

public class AnalysisServerFeedbackAction
extends DumbAwareAction {
    public AnalysisServerFeedbackAction() {
        super(DartBundle.message("analysis.server.status.good.text", new Object[0]), null, DartIcons.Feedback);
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DartFeedbackBuilder builder = DartFeedbackBuilder.getFeedbackBuilder();
        builder.sendFeedback(project, null, null);
    }

    public void update(AnActionEvent e) {
        Presentation presentation = e.getPresentation();
        Project project = e.getProject();
        if (AnalysisServerFeedbackAction.isApplicable(project)) {
            presentation.setEnabledAndVisible(true);
        } else {
            presentation.setEnabledAndVisible(false);
        }
    }

    private static boolean isApplicable(@Nullable Project project) {
        return project != null && ToolWindowManager.getInstance((Project)project).getToolWindow(DartProblemsView.TOOLWINDOW_ID) != null;
    }
}

