/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.errorTreeView;

import com.google.dart.server.GetServerPortConsumer;
import com.intellij.ide.BrowserUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import org.dartlang.analysis.server.protocol.RequestError;

public class AnalysisServerDiagnosticsAction
extends DumbAwareAction {
    private static final String GROUP_DISPLAY_ID = "Dart Analysis Server";

    public AnalysisServerDiagnosticsAction() {
        super(DartBundle.message("analysis.server.show.diagnostics.text", new Object[0]));
    }

    public void actionPerformed(AnActionEvent e) {
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        DartAnalysisServerService server = DartAnalysisServerService.getInstance(project);
        server.diagnostic_getServerPort(new GetServerPortConsumer(){

            @Override
            public void computedServerPort(int port) {
                BrowserUtil.browse((String)("http://localhost:" + port + "/status"));
            }

            @Override
            public void onError(RequestError requestError) {
                Notification notification = new Notification(AnalysisServerDiagnosticsAction.GROUP_DISPLAY_ID, DartBundle.message("analysis.server.show.diagnostics.error", new Object[0]), requestError.getMessage(), NotificationType.ERROR);
                Notifications.Bus.notify((Notification)notification);
            }
        });
    }
}

