/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.wordSelection.AbstractWordSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.ide.editor.DartSelectionFilter;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DartWordSelectionHandler
extends AbstractWordSelectioner {
    public boolean canSelect(PsiElement e) {
        return e.getLanguage() == DartLanguage.INSTANCE;
    }

    public List<TextRange> select(@NotNull PsiElement psiElement, @NotNull CharSequence editorText, int cursorOffset, @NotNull Editor editor) {
        if (psiElement == null) {
            DartWordSelectionHandler.$$$reportNull$$$0(0);
        }
        if (editorText == null) {
            DartWordSelectionHandler.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            DartWordSelectionHandler.$$$reportNull$$$0(2);
        }
        List ranges = super.select(psiElement, editorText, cursorOffset, editor);
        PsiElement semicolon = DartSelectionFilter.getSiblingSemicolonIfExpression(psiElement);
        if (semicolon != null) {
            DartWordSelectionHandler.includeSemicolonInRanges(ranges, psiElement.getTextRange(), semicolon.getTextRange().getEndOffset());
        }
        return ranges;
    }

    private static void includeSemicolonInRanges(@NotNull List<TextRange> ranges, @NotNull TextRange elementWithoutSemicolonRange, int semicolonEndOffset) {
        if (ranges == null) {
            DartWordSelectionHandler.$$$reportNull$$$0(3);
        }
        if (elementWithoutSemicolonRange == null) {
            DartWordSelectionHandler.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < ranges.size(); ++i) {
            TextRange range = ranges.get(i);
            if (range.getStartOffset() > elementWithoutSemicolonRange.getStartOffset() || range.getEndOffset() != elementWithoutSemicolonRange.getEndOffset()) continue;
            ranges.set(i, TextRange.create((int)range.getStartOffset(), (int)semicolonEndOffset));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editorText";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementWithoutSemicolonRange";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/editor/DartWordSelectionHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "select";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "includeSemicolonInRanges";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

