/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.editorActions.TypedHandler;
import com.intellij.codeInsight.editorActions.TypedHandlerDelegate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.psi.DartComponentName;
import com.jetbrains.lang.dart.psi.DartDefaultCase;
import com.jetbrains.lang.dart.psi.DartLazyParseableBlock;
import com.jetbrains.lang.dart.psi.DartSwitchCase;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartTypeHandler
extends TypedHandlerDelegate {
    private boolean myAfterTypeOrComponentName = false;
    private boolean myAfterDollarInStringInterpolation = false;
    private static final TokenSet INVALID_INSIDE_REFERENCE = TokenSet.create((IElementType[])new IElementType[]{DartTokenTypes.SEMICOLON, DartTokenTypes.LBRACE, DartTokenTypes.RBRACE});

    public TypedHandlerDelegate.Result beforeCharTyped(char c, Project project, Editor editor, PsiFile file, FileType fileType) {
        this.myAfterTypeOrComponentName = false;
        this.myAfterDollarInStringInterpolation = false;
        if (fileType != DartFileType.INSTANCE) {
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '<' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            TypedHandler.commitDocumentIfCurrentCaretIsNotTheFirstOne((Editor)editor, (Project)project);
            this.myAfterTypeOrComponentName = DartTypeHandler.isAfterTypeOrComponentName(file, editor.getCaretModel().getOffset());
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '>' && CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            if (DartTypeHandler.handleDartGT(editor, DartTokenTypes.LT, DartTokenTypes.GT, INVALID_INSIDE_REFERENCE)) {
                return TypedHandlerDelegate.Result.STOP;
            }
            return TypedHandlerDelegate.Result.CONTINUE;
        }
        if (c == '{') {
            PsiElement nextLeaf;
            TypedHandler.commitDocumentIfCurrentCaretIsNotTheFirstOne((Editor)editor, (Project)project);
            PsiElement element = file.findElementAt(editor.getCaretModel().getOffset() - 1);
            if (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET && DartTypeHandler.isAfterDollarInStringInterpolation(element)) {
                this.myAfterDollarInStringInterpolation = true;
                return TypedHandlerDelegate.Result.CONTINUE;
            }
            PsiElement psiElement = nextLeaf = element == null ? null : PsiTreeUtil.nextLeaf((PsiElement)element);
            if (nextLeaf instanceof PsiWhiteSpace) {
                nextLeaf = PsiTreeUtil.nextLeaf((PsiElement)nextLeaf);
            }
            if (PsiTreeUtil.getParentOfType((PsiElement)element, DartLazyParseableBlock.class, (boolean)false) != null || nextLeaf != null && nextLeaf.getText().equals("=>")) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"{");
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    public TypedHandlerDelegate.Result charTyped(char c, Project project, @NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            DartTypeHandler.$$$reportNull$$$0(0);
        }
        if (file == null) {
            DartTypeHandler.$$$reportNull$$$0(1);
        }
        if (c == '<' && this.myAfterTypeOrComponentName) {
            this.myAfterTypeOrComponentName = false;
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)">", (boolean)false, (int)0);
            return TypedHandlerDelegate.Result.STOP;
        }
        if (c == '{' && this.myAfterDollarInStringInterpolation) {
            this.myAfterDollarInStringInterpolation = false;
            if (editor.getDocument().getCharsSequence().charAt(editor.getCaretModel().getOffset()) != '}') {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)"}", (boolean)false, (int)0);
                return TypedHandlerDelegate.Result.STOP;
            }
        }
        if (c == ':' && DartTypeHandler.autoIndentCase(editor, project, file)) {
            return TypedHandlerDelegate.Result.STOP;
        }
        return TypedHandlerDelegate.Result.CONTINUE;
    }

    private static boolean isAfterTypeOrComponentName(@NotNull PsiFile file, int offset) {
        if (file == null) {
            DartTypeHandler.$$$reportNull$$$0(2);
        }
        PsiElement element = file.findElementAt(offset - 1);
        PsiElement previousElement = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpacesAndComments(element, false);
        return PsiTreeUtil.getParentOfType((PsiElement)previousElement, (Class[])new Class[]{DartType.class, DartComponentName.class}) != null;
    }

    private static boolean isAfterDollarInStringInterpolation(@Nullable PsiElement elementAtOffsetMinusOne) {
        return elementAtOffsetMinusOne != null && elementAtOffsetMinusOne.getNode().getElementType() == DartTokenTypes.SHORT_TEMPLATE_ENTRY_START;
    }

    private static boolean autoIndentCase(Editor editor, Project project, PsiFile file) {
        PsiElement parent;
        int offset = editor.getCaretModel().getOffset();
        PsiDocumentManager.getInstance((Project)project).commitDocument(editor.getDocument());
        PsiElement currElement = file.findElementAt(offset - 1);
        if (currElement != null && ((parent = currElement.getParent()) != null && parent instanceof DartSwitchCase || parent instanceof DartDefaultCase)) {
            CodeStyleManager.getInstance((Project)project).adjustLineIndent(file, parent.getTextRange().getStartOffset());
            return true;
        }
        return false;
    }

    private static boolean handleDartGT(Editor editor, IElementType lt, IElementType gt, TokenSet invalidInsideReference) {
        if (!CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET) {
            return false;
        }
        int offset = editor.getCaretModel().getOffset();
        if (offset == editor.getDocument().getTextLength()) {
            return false;
        }
        HighlighterIterator iterator = ((EditorEx)editor).getHighlighter().createIterator(offset);
        if (iterator.getTokenType() != gt) {
            return false;
        }
        while (!iterator.atEnd() && !invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.advance();
        }
        if (!iterator.atEnd() && invalidInsideReference.contains(iterator.getTokenType())) {
            iterator.retreat();
        }
        int balance = 0;
        while (!iterator.atEnd() && balance >= 0) {
            IElementType tokenType = iterator.getTokenType();
            if (tokenType == lt) {
                --balance;
            } else if (tokenType == gt) {
                ++balance;
            } else if (invalidInsideReference.contains(tokenType)) break;
            iterator.retreat();
        }
        if (balance == 0) {
            EditorModificationUtil.moveCaretRelatively((Editor)editor, (int)1);
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/editor/DartTypeHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "charTyped";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "isAfterTypeOrComponentName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

