/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.SimpleTokenSetQuoteHandler;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.psi.tree.IElementType;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;

public class DartQuoteHandler
extends SimpleTokenSetQuoteHandler {
    public DartQuoteHandler() {
        super(DartTokenTypesSets.STRINGS);
    }

    public boolean isOpeningQuote(HighlighterIterator iterator, int offset) {
        IElementType type = iterator.getTokenType();
        if (type == DartTokenTypes.OPEN_QUOTE) {
            return true;
        }
        return type == DartTokenTypes.RAW_SINGLE_QUOTED_STRING && offset == iterator.getStart() + 1;
    }

    public boolean isClosingQuote(HighlighterIterator iterator, int offset) {
        IElementType type = iterator.getTokenType();
        if (type == DartTokenTypes.CLOSING_QUOTE) {
            return true;
        }
        if (type == DartTokenTypes.RAW_SINGLE_QUOTED_STRING) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            if (end - start > 2 && offset == end - 1) {
                CharSequence chars = iterator.getDocument().getCharsSequence();
                return chars.charAt(start + 1) == chars.charAt(end - 1);
            }
        }
        return false;
    }

    protected boolean isNonClosedLiteral(HighlighterIterator iterator, CharSequence chars) {
        if (iterator.getTokenType() == DartTokenTypes.RAW_SINGLE_QUOTED_STRING) {
            int start = iterator.getStart();
            int end = iterator.getEnd();
            return end - start <= 2 || chars.charAt(end - 1) != chars.charAt(start + 1);
        }
        return super.isNonClosedLiteral(iterator, chars);
    }
}

