/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.tree.IElementType;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartEnterInStringHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        String openingQuoteText;
        int psiOffset;
        if (file == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvanceRef == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(4);
        }
        if (file.getLanguage() != DartLanguage.INSTANCE && !HtmlUtil.isHtmlFile((PsiElement)file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        if (psiAtOffset == null || (psiOffset = psiAtOffset.getTextRange().getStartOffset()) > caretOffset) {
            return EnterHandlerDelegate.Result.Continue;
        }
        ASTNode node = psiAtOffset.getNode();
        IElementType nodeType = node.getElementType();
        if ((nodeType == DartTokenTypes.SHORT_TEMPLATE_ENTRY_START || nodeType == DartTokenTypes.LONG_TEMPLATE_ENTRY_START) && caretOffset == psiOffset) {
            node = node.getTreeParent();
            nodeType = node.getElementType();
        }
        if (nodeType == DartTokenTypes.RAW_TRIPLE_QUOTED_STRING && caretOffset >= psiOffset + "r'''".length()) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        if (nodeType == DartTokenTypes.RAW_SINGLE_QUOTED_STRING && caretOffset >= psiOffset + "r'".length()) {
            char quote = node.getText().charAt(1);
            DartEnterInStringHandler.breakString("r" + quote, String.valueOf(quote), caretOffsetRef, caretAdvanceRef, editor.getDocument());
            return EnterHandlerDelegate.Result.Default;
        }
        if ((nodeType == DartTokenTypes.REGULAR_STRING_PART || nodeType == DartTokenTypes.CLOSING_QUOTE || nodeType == DartTokenTypes.SHORT_TEMPLATE_ENTRY || nodeType == DartTokenTypes.LONG_TEMPLATE_ENTRY) && (openingQuoteText = DartEnterInStringHandler.getOpeningQuoteText(node)) != null) {
            if (openingQuoteText.length() == 1) {
                DartEnterInStringHandler.breakString(openingQuoteText, openingQuoteText, caretOffsetRef, caretAdvanceRef, editor.getDocument());
                return EnterHandlerDelegate.Result.Default;
            }
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    @Nullable
    private static String getOpeningQuoteText(@NotNull ASTNode node) {
        if (node == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(5);
        }
        for (ASTNode prev = node.getTreePrev(); prev != null; prev = prev.getTreePrev()) {
            if (prev.getElementType() != DartTokenTypes.OPEN_QUOTE) continue;
            return prev.getText();
        }
        return null;
    }

    private static void breakString(@NotNull String startQuote, @NotNull String endQuote, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvanceRef, @NotNull Document document) {
        if (startQuote == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(6);
        }
        if (endQuote == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(7);
        }
        if (caretOffsetRef == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(8);
        }
        if (caretAdvanceRef == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(9);
        }
        if (document == null) {
            DartEnterInStringHandler.$$$reportNull$$$0(10);
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        int caretAdvance = (Integer)caretAdvanceRef.get();
        document.insertString(caretOffset, (CharSequence)(endQuote + startQuote));
        caretOffsetRef.set((Object)(caretOffset += endQuote.length()));
        caretAdvanceRef.set((Object)(caretAdvance += startQuote.length()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretOffsetRef";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caretAdvanceRef";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startQuote";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endQuote";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/editor/DartEnterInStringHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "preprocessEnter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "getOpeningQuoteText";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "breakString";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

