/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.xml.util.HtmlUtil;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import org.jetbrains.annotations.NotNull;

public class DartEnterInDocLineCommentHandler
extends EnterHandlerDelegateAdapter {
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Ref<Integer> caretOffsetRef, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        PsiElement probablyDocComment;
        if (file == null) {
            DartEnterInDocLineCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DartEnterInDocLineCommentHandler.$$$reportNull$$$0(1);
        }
        if (caretOffsetRef == null) {
            DartEnterInDocLineCommentHandler.$$$reportNull$$$0(2);
        }
        if (caretAdvance == null) {
            DartEnterInDocLineCommentHandler.$$$reportNull$$$0(3);
        }
        if (dataContext == null) {
            DartEnterInDocLineCommentHandler.$$$reportNull$$$0(4);
        }
        if (file.getLanguage() != DartLanguage.INSTANCE && !HtmlUtil.isHtmlFile((PsiElement)file)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        int caretOffset = (Integer)caretOffsetRef.get();
        Document document = editor.getDocument();
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(editor.getDocument());
        PsiElement psiAtOffset = file.findElementAt(caretOffset);
        PsiElement psiElement = psiAtOffset instanceof PsiWhiteSpace && psiAtOffset.getText().startsWith("\n") ? psiAtOffset.getPrevSibling() : (probablyDocComment = psiAtOffset == null && caretOffset > 0 && caretOffset == document.getTextLength() ? file.findElementAt(caretOffset - 1) : psiAtOffset);
        if (probablyDocComment != null && probablyDocComment.getTextRange().getStartOffset() < caretOffset && probablyDocComment.getNode().getElementType() == DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) {
            int offset;
            CharSequence text = document.getCharsSequence();
            if (StringUtil.startsWith((CharSequence)text, (int)(offset = CharArrayUtil.shiftForward((CharSequence)text, (int)caretOffset, (String)" \t")), (CharSequence)"///")) {
                caretOffsetRef.set((Object)offset);
            } else {
                String docText = StringUtil.trimStart((String)probablyDocComment.getText(), (String)"///");
                int spacesBeforeText = StringUtil.isEmptyOrSpaces((String)docText) ? 1 : StringUtil.countChars((CharSequence)docText, (char)' ', (int)0, (boolean)true);
                int spacesToAdd = Math.max(0, spacesBeforeText - StringUtil.countChars((CharSequence)text, (char)' ', (int)caretOffset, (boolean)true));
                document.insertString(caretOffset, (CharSequence)("///" + StringUtil.repeatSymbol((char)' ', (int)spacesToAdd)));
                caretAdvance.set((Object)spacesBeforeText);
            }
            return EnterHandlerDelegate.Result.Default;
        }
        return EnterHandlerDelegate.Result.Continue;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "file";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "editor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "caretOffsetRef";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "caretAdvance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "dataContext";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/lang/dart/ide/editor/DartEnterInDocLineCommentHandler";
        objectArray[2] = "preprocessEnter";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

