/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.editor;

import com.intellij.codeInsight.editorActions.CopyPastePostProcessor;
import com.intellij.codeInsight.editorActions.TextBlockTransferableData;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartFileType;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.ide.codeInsight.DartCodeInsightSettings;
import com.jetbrains.lang.dart.psi.DartFile;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.dartlang.analysis.server.protocol.ImportedElements;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;

public class DartCopyPasteProcessor
extends CopyPastePostProcessor<DartImportsTransferableData> {
    private static final DataFlavor FLAVOR = new DataFlavor(DartImportsTransferableData.class, "Dart imports");

    @NotNull
    public List<DartImportsTransferableData> collectTransferableData(@NotNull PsiFile psiFile, @NotNull Editor editor, @NotNull int[] startOffsets, @NotNull int[] endOffsets) {
        if (psiFile == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(1);
        }
        if (startOffsets == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(2);
        }
        if (endOffsets == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(3);
        }
        if (!(psiFile instanceof DartFile)) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(4);
            }
            return list;
        }
        Project project = psiFile.getProject();
        VirtualFile vFile = DartResolveUtil.getRealVirtualFile(psiFile);
        if (!DartAnalysisServerService.isLocalAnalyzableFile(vFile)) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(5);
            }
            return list;
        }
        if (DartCodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 2) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(6);
            }
            return list;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
        if (module == null || !DartSdkLibUtil.isDartSdkEnabled(module)) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(7);
            }
            return list;
        }
        if (!ProjectFileIndex.getInstance((Project)project).isInContent(vFile)) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(8);
            }
            return list;
        }
        DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
        if (!das.serverReadyForRequest(project)) {
            List<DartImportsTransferableData> list = Collections.emptyList();
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(9);
            }
            return list;
        }
        das.updateFilesContent();
        SmartList importedElements = new SmartList();
        for (int i = 0; i < startOffsets.length; ++i) {
            int offset = startOffsets[i];
            int length = endOffsets[i] - startOffsets[i];
            List<ImportedElements> elements = das.analysis_getImportedElements(vFile, offset, length);
            if (elements == null) continue;
            importedElements.addAll(elements);
        }
        List<DartImportsTransferableData> list = !importedElements.isEmpty() ? Collections.singletonList(new DartImportsTransferableData((List<ImportedElements>)importedElements)) : Collections.emptyList();
        if (list == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public List<DartImportsTransferableData> extractTransferableData(@NotNull Transferable content) {
        block5: {
            List<DartImportsTransferableData> list;
            if (content == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(11);
            }
            try {
                Object data = content.getTransferData(FLAVOR);
                if (!(data instanceof DartImportsTransferableData)) break block5;
                list = Collections.singletonList((DartImportsTransferableData)data);
            }
            catch (UnsupportedFlavorException | IOException exception) {
                // empty catch block
            }
            if (list == null) {
                DartCopyPasteProcessor.$$$reportNull$$$0(12);
            }
            return list;
        }
        List<DartImportsTransferableData> list = Collections.emptyList();
        if (list == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(13);
        }
        return list;
    }

    public void processTransferableData(@NotNull Project project, @NotNull Editor editor, @NotNull RangeMarker bounds, int caretOffset, @NotNull Ref<Boolean> indented, @NotNull List<DartImportsTransferableData> values) {
        DartImportsTransferableData data;
        if (project == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(14);
        }
        if (editor == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(15);
        }
        if (bounds == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(16);
        }
        if (indented == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(17);
        }
        if (values == null) {
            DartCopyPasteProcessor.$$$reportNull$$$0(18);
        }
        if ((data = (DartImportsTransferableData)ContainerUtil.getFirstItem(values)) == null) {
            return;
        }
        VirtualFile file = FileDocumentManager.getInstance().getFile(editor.getDocument());
        if (file == null || file.getFileType() != DartFileType.INSTANCE || !DartAnalysisServerService.isLocalAnalyzableFile(file)) {
            return;
        }
        if (DartCodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 2) {
            return;
        }
        SourceFileEdit edit = DartAnalysisServerService.getInstance(project).edit_importElements(file, data.getImportedElements());
        if (edit != null && edit.getEdits() != null && !edit.getEdits().isEmpty()) {
            if (DartCodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE == 3 && !ApplicationManager.getApplication().isUnitTestMode()) {
                String message = DartBundle.message("dialog.paste.on.import.text", new Object[0]);
                String title = DartBundle.message("dialog.paste.on.import.title", new Object[0]);
                DialogWrapper.DoNotAskOption.Adapter doNotAskOption = new DialogWrapper.DoNotAskOption.Adapter(){

                    public boolean shouldSaveOptionsOnCancel() {
                        return true;
                    }

                    public void rememberChoice(boolean isSelected, int exitCode) {
                        if (!isSelected) {
                            return;
                        }
                        if (exitCode == 0) {
                            DartCodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE = 1;
                        } else if (exitCode == 1) {
                            DartCodeInsightSettings.getInstance().ADD_IMPORTS_ON_PASTE = 2;
                        }
                    }
                };
                if (Messages.showYesNoDialog((Project)project, (String)message, (String)title, (Icon)Messages.getQuestionIcon(), (DialogWrapper.DoNotAskOption)doNotAskOption) != 0) {
                    return;
                }
            }
            WriteAction.run(() -> {
                if (project == null) {
                    DartCopyPasteProcessor.$$$reportNull$$$0(19);
                }
                AssistUtils.applyFileEdit(project, edit);
            });
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startOffsets";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "endOffsets";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/editor/DartCopyPasteProcessor";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 14: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bounds";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indented";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/editor/DartCopyPasteProcessor";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "collectTransferableData";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "extractTransferableData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "collectTransferableData";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "extractTransferableData";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "processTransferableData";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processTransferableData$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartImportsTransferableData
    implements TextBlockTransferableData {
        @NotNull
        private final List<ImportedElements> myImportedElements;

        public DartImportsTransferableData(@NotNull List<ImportedElements> importedElements) {
            if (importedElements == null) {
                DartImportsTransferableData.$$$reportNull$$$0(0);
            }
            this.myImportedElements = importedElements;
        }

        @NotNull
        public List<ImportedElements> getImportedElements() {
            List<ImportedElements> list = this.myImportedElements;
            if (list == null) {
                DartImportsTransferableData.$$$reportNull$$$0(1);
            }
            return list;
        }

        public DataFlavor getFlavor() {
            return FLAVOR;
        }

        public int getOffsetCount() {
            return 0;
        }

        public int getOffsets(int[] offsets, int index) {
            return index;
        }

        public int setOffsets(int[] offsets, int index) {
            return index;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "importedElements";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/editor/DartCopyPasteProcessor$DartImportsTransferableData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/editor/DartCopyPasteProcessor$DartImportsTransferableData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getImportedElements";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

