/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.documentation;

import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.completion.DartLookupObject;
import com.jetbrains.lang.dart.ide.documentation.DartDocUtil;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartId;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.DartUrlResolver;
import java.util.Collections;
import java.util.List;
import org.dartlang.analysis.server.protocol.HoverInformation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartDocumentationProvider
implements DocumentationProvider {
    private static final String BASE_DART_DOC_URL = "https://api.dartlang.org/stable/";

    public String generateDoc(@NotNull PsiElement element, @Nullable PsiElement originalElement) {
        PsiElement elementForDocs;
        HoverInformation hover;
        if (element == null) {
            DartDocumentationProvider.$$$reportNull$$$0(0);
        }
        if ((hover = DartDocumentationProvider.getSingleHover(elementForDocs = DartDocumentationProvider.resolvesTo(originalElement, element) ? originalElement : element)) != null) {
            return DartDocumentationProvider.generateDocServer(hover);
        }
        return DartDocUtil.generateDoc(element);
    }

    private static boolean resolvesTo(@Nullable PsiElement originalElement, @NotNull PsiElement target) {
        PsiReference reference;
        if (target == null) {
            DartDocumentationProvider.$$$reportNull$$$0(1);
        }
        if (originalElement instanceof PsiReference) {
            reference = (PsiReference)originalElement;
        } else {
            PsiElement parentParent;
            PsiElement parent = originalElement == null ? null : originalElement.getParent();
            PsiElement psiElement = parentParent = parent instanceof DartId ? parent.getParent() : null;
            if (parentParent == null) {
                return false;
            }
            if (parentParent == target) {
                return true;
            }
            if (!parentParent.getText().equals(target.getText())) {
                return false;
            }
            reference = parentParent.getReference();
        }
        return reference != null && reference.resolve() == target;
    }

    public PsiElement getDocumentationElementForLink(PsiManager psiManager, String link, PsiElement context) {
        return null;
    }

    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        return object instanceof DartLookupObject ? ((DartLookupObject)object).findPsiElement() : null;
    }

    public String getQuickNavigateInfo(PsiElement element, PsiElement originalElement) {
        PsiElement elementForInfo = DartDocumentationProvider.resolvesTo(originalElement, element) ? originalElement : element;
        HoverInformation hover = DartDocumentationProvider.getSingleHover(elementForInfo);
        if (hover != null) {
            return DartDocumentationProvider.buildHoverTextServer(hover);
        }
        return DartDocUtil.getSignature(element);
    }

    @Nullable
    public List<String> getUrlFor(PsiElement element, PsiElement originalElement) {
        if (!(element instanceof DartComponent) && !(element.getParent() instanceof DartComponent)) {
            return null;
        }
        DartComponent component = (DartComponent)(element instanceof DartComponent ? element : element.getParent());
        if (!component.isPublic()) {
            return null;
        }
        String docUrl = DartDocumentationProvider.constructDocUrl(component);
        return docUrl == null ? null : Collections.singletonList(docUrl);
    }

    @NotNull
    public static String buildHoverTextServer(@NotNull HoverInformation hover) {
        String elementDescription;
        if (hover == null) {
            DartDocumentationProvider.$$$reportNull$$$0(2);
        }
        String staticType = (elementDescription = hover.getElementDescription()) == null || elementDescription.equals(hover.getStaticType()) ? null : hover.getStaticType();
        String propagatedType = elementDescription == null || elementDescription.equals(hover.getPropagatedType()) ? null : hover.getPropagatedType();
        String string = DartDocUtil.generateDoc(elementDescription, false, null, null, null, staticType, propagatedType, true);
        if (string == null) {
            DartDocumentationProvider.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public static String generateDocServer(@NotNull HoverInformation hover) {
        if (hover == null) {
            DartDocumentationProvider.$$$reportNull$$$0(4);
        }
        String elementDescription = hover.getElementDescription();
        String containingLibraryName = hover.getContainingLibraryName();
        String containingClassDescription = hover.getContainingClassDescription();
        String staticType = hover.getStaticType();
        String propagatedType = hover.getPropagatedType();
        String docText = hover.getDartdoc();
        String string = DartDocUtil.generateDoc(elementDescription, false, docText, containingLibraryName, containingClassDescription, staticType, propagatedType, false);
        if (string == null) {
            DartDocumentationProvider.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Nullable
    public static HoverInformation getSingleHover(@NotNull PsiFile psiFile, int offset) {
        List<HoverInformation> hoverList;
        if (psiFile == null) {
            DartDocumentationProvider.$$$reportNull$$$0(6);
        }
        if ((hoverList = DartAnalysisServerService.getInstance(psiFile.getProject()).analysis_getHover(psiFile.getVirtualFile(), offset)).isEmpty()) {
            return null;
        }
        return hoverList.get(0);
    }

    @Nullable
    private static String constructDocUrl(@NotNull DartComponent component) {
        if (component == null) {
            DartDocumentationProvider.$$$reportNull$$$0(7);
        }
        String libRelatedUrlPart = DartDocumentationProvider.getLibRelatedUrlPart((PsiElement)component);
        String name = component.getName();
        if (libRelatedUrlPart == null || name == null) {
            return null;
        }
        String baseUrl = BASE_DART_DOC_URL + libRelatedUrlPart + "/";
        if (component instanceof DartClass) {
            return baseUrl + name + "-class.html";
        }
        DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)component, DartClass.class, (boolean)true);
        if (component instanceof DartNamedConstructorDeclaration) {
            assert (dartClass != null);
            return baseUrl + dartClass.getName() + "/" + StringUtil.join(((DartNamedConstructorDeclaration)component).getComponentNameList(), NavigationItem::getName, (String)".") + ".html";
        }
        if (component instanceof DartFactoryConstructorDeclaration) {
            assert (dartClass != null);
            return baseUrl + dartClass.getName() + "/" + StringUtil.join(((DartFactoryConstructorDeclaration)component).getComponentNameList(), NavigationItem::getName, (String)".") + ".html";
        }
        if (dartClass != null) {
            return baseUrl + dartClass.getName() + "/" + name + ".html";
        }
        return baseUrl + name + ".html";
    }

    @Nullable
    private static String getLibRelatedUrlPart(@NotNull PsiElement element) {
        if (element == null) {
            DartDocumentationProvider.$$$reportNull$$$0(8);
        }
        for (VirtualFile libFile : DartResolveUtil.findLibrary(element.getContainingFile())) {
            DartUrlResolver urlResolver = DartUrlResolver.getInstance(element.getProject(), libFile);
            String dartUrl = urlResolver.getDartUrlForFile(libFile);
            if (!dartUrl.startsWith("dart:")) continue;
            return "dart-" + dartUrl.substring("dart:".length());
        }
        return null;
    }

    @Nullable
    private static HoverInformation getSingleHover(PsiElement element) {
        if (element != null) {
            PsiFile psiFile = element.getContainingFile();
            int offset = element.getTextOffset();
            return DartDocumentationProvider.getSingleHover(psiFile, offset);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hover";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/documentation/DartDocumentationProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "buildHoverTextServer";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "generateDocServer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateDoc";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "resolvesTo";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildHoverTextServer";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "generateDocServer";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getSingleHover";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "constructDocUrl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getLibRelatedUrlPart";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

