/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.documentation;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.psi.DartClass;
import com.jetbrains.lang.dart.psi.DartClassMembers;
import com.jetbrains.lang.dart.psi.DartComponent;
import com.jetbrains.lang.dart.psi.DartDocComment;
import com.jetbrains.lang.dart.psi.DartEnumConstantDeclaration;
import com.jetbrains.lang.dart.psi.DartEnumDefinition;
import com.jetbrains.lang.dart.psi.DartFactoryConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartFunctionDeclarationWithBodyOrNative;
import com.jetbrains.lang.dart.psi.DartFunctionTypeAlias;
import com.jetbrains.lang.dart.psi.DartGetterDeclaration;
import com.jetbrains.lang.dart.psi.DartMethodDeclaration;
import com.jetbrains.lang.dart.psi.DartNamedConstructorDeclaration;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartReturnType;
import com.jetbrains.lang.dart.psi.DartSetterDeclaration;
import com.jetbrains.lang.dart.psi.DartType;
import com.jetbrains.lang.dart.psi.DartTypeArguments;
import com.jetbrains.lang.dart.psi.DartTypeList;
import com.jetbrains.lang.dart.psi.DartTypeParameter;
import com.jetbrains.lang.dart.psi.DartTypeParameters;
import com.jetbrains.lang.dart.psi.DartVarAccessDeclaration;
import com.jetbrains.lang.dart.util.DartGenericSpecialization;
import com.jetbrains.lang.dart.util.DartPresentableUtil;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.UsefulPsiTreeUtil;
import com.petebevin.markdown.MarkdownProcessor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartDocUtil {
    public static final String SINGLE_LINE_DOC_COMMENT = "///";

    public static String generateDoc(PsiElement element) {
        String containingClassDescription;
        if (!(element instanceof DartComponent) && !(element.getParent() instanceof DartComponent)) {
            return null;
        }
        DartComponent namedComponent = (DartComponent)(element instanceof DartComponent ? element : element.getParent());
        StringBuilder builder = new StringBuilder();
        DartDocUtil.appendSignature(namedComponent, builder);
        String signatureHtml = builder.toString();
        PsiFile file = element.getContainingFile();
        String containingLibraryName = file != null ? DartResolveUtil.getLibraryName(file) : null;
        DartClass dartClass = (DartClass)PsiTreeUtil.getParentOfType((PsiElement)namedComponent, DartClass.class);
        if (dartClass != null) {
            StringBuilder builder2 = new StringBuilder();
            builder2.append(dartClass.getName());
            DartDocUtil.appendTypeParams(builder2, dartClass.getTypeParameters());
            containingClassDescription = builder2.toString();
        } else {
            containingClassDescription = null;
        }
        String docText = DartDocUtil.getDocumentationText(namedComponent);
        return DartDocUtil.generateDoc(signatureHtml, true, docText, containingLibraryName, containingClassDescription, null, null, false);
    }

    public static String generateDoc(@Nullable String signature, boolean signatureIsHtml, @Nullable String docText, @Nullable String containingLibraryName, @Nullable String containingClassDescription, @Nullable String staticType, @Nullable String propagatedType, boolean compactPresentation) {
        boolean hasContainingLibraryName = !StringUtil.isEmpty((String)containingLibraryName);
        boolean hasContainingClassDescription = !StringUtil.isEmpty((String)containingClassDescription);
        boolean hasStaticType = !StringUtil.isEmpty((String)staticType);
        boolean hasPropagatedType = !StringUtil.isEmpty((String)propagatedType);
        StringBuilder builder = new StringBuilder();
        builder.append("<code>");
        if (signature != null) {
            if (signatureIsHtml) {
                builder.append(signature);
            } else {
                builder.append(StringUtil.escapeXml((String)signature));
            }
            builder.append("<br>");
        }
        if (hasContainingLibraryName || hasContainingClassDescription) {
            builder.append("<br>");
            if (hasContainingLibraryName) {
                builder.append("<b>Containing library:</b> ");
                builder.append(StringUtil.escapeXml((String)containingLibraryName));
                builder.append("<br>");
            }
            if (hasContainingClassDescription) {
                builder.append("<b>Containing class:</b> ");
                builder.append(StringUtil.escapeXml((String)containingClassDescription));
                builder.append("<br>");
            }
        }
        if (hasStaticType || hasPropagatedType) {
            if (!compactPresentation) {
                builder.append("<br>");
            }
            if (hasStaticType) {
                builder.append("<b>Static type:</b> ");
                builder.append(StringUtil.escapeXml((String)staticType));
                builder.append("<br>");
            }
            if (hasPropagatedType) {
                builder.append("<b>Propagated type:</b> ");
                builder.append(StringUtil.escapeXml((String)propagatedType));
                builder.append("<br>");
            }
        }
        builder.append("</code>\n");
        if (docText != null) {
            MarkdownProcessor processor = new MarkdownProcessor();
            builder.append(processor.markdown(docText.trim()));
        }
        return builder.toString().trim();
    }

    @Nullable
    public static String getSignature(@NotNull PsiElement element) {
        if (element == null) {
            DartDocUtil.$$$reportNull$$$0(0);
        }
        if (!(element instanceof DartComponent)) {
            element = element.getParent();
        }
        if (element instanceof DartComponent) {
            StringBuilder sb = new StringBuilder();
            DartDocUtil.appendSignature((DartComponent)element, sb);
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    private static void appendSignature(DartComponent namedComponent, StringBuilder builder) {
        if (namedComponent instanceof DartClass) {
            DartDocUtil.appendClassSignature(builder, (DartClass)namedComponent);
        } else if (namedComponent instanceof DartFunctionDeclarationWithBodyOrNative) {
            DartDocUtil.appendFunctionSignature(builder, namedComponent, ((DartFunctionDeclarationWithBodyOrNative)namedComponent).getReturnType());
        } else if (namedComponent instanceof DartFunctionTypeAlias) {
            builder.append("typedef ");
            DartDocUtil.appendFunctionSignature(builder, namedComponent, ((DartFunctionTypeAlias)namedComponent).getReturnType());
        } else if (namedComponent.isConstructor()) {
            DartDocUtil.appendConstructorSignature(builder, namedComponent, (DartClass)PsiTreeUtil.getParentOfType((PsiElement)namedComponent, DartClass.class));
        } else if (namedComponent instanceof DartMethodDeclaration) {
            DartDocUtil.appendFunctionSignature(builder, namedComponent, ((DartMethodDeclaration)namedComponent).getReturnType());
        } else if (namedComponent instanceof DartVarAccessDeclaration) {
            DartDocUtil.appendVariableSignature(builder, namedComponent, ((DartVarAccessDeclaration)namedComponent).getType());
        } else if (namedComponent instanceof DartGetterDeclaration) {
            builder.append("get ");
            DartDocUtil.appendFunctionSignature(builder, namedComponent, ((DartGetterDeclaration)namedComponent).getReturnType());
        } else if (namedComponent instanceof DartSetterDeclaration) {
            builder.append("set ");
            DartDocUtil.appendFunctionSignature(builder, namedComponent, ((DartSetterDeclaration)namedComponent).getReturnType());
        } else if (namedComponent instanceof DartEnumConstantDeclaration) {
            builder.append(((DartEnumDefinition)namedComponent.getParent()).getName()).append(" ");
            builder.append("<b>").append(namedComponent.getName()).append("</b>");
        }
    }

    @Nullable
    private static String getDocumentationText(DartComponent dartComponent) {
        String docText;
        DartDocComment multilineComment = (DartDocComment)PsiTreeUtil.getChildOfType((PsiElement)dartComponent, DartDocComment.class);
        if (multilineComment != null) {
            return DartDocUtil.getMultilineDocCommentText(multilineComment);
        }
        PsiComment[] childComments = (PsiComment[])PsiTreeUtil.getChildrenOfType((PsiElement)dartComponent, PsiComment.class);
        if (childComments != null && (docText = DartDocUtil.getSingleLineDocCommentsText(childComments)) != null) {
            return docText;
        }
        DartComponent anchorElement = dartComponent;
        PsiElement parent = dartComponent.getParent();
        if (parent instanceof DartClassMembers && parent.getFirstChild() == dartComponent || dartComponent instanceof DartVarAccessDeclaration) {
            anchorElement = parent;
        }
        ArrayList<PsiComment> siblingComments = new ArrayList<PsiComment>();
        DartComponent previous = anchorElement;
        while ((previous = UsefulPsiTreeUtil.getPrevSiblingSkipWhiteSpaces((PsiElement)previous, true)) instanceof PsiComment) {
            if (previous instanceof DartDocComment) {
                return DartDocUtil.getMultilineDocCommentText((DartDocComment)((Object)previous));
            }
            siblingComments.add(0, (PsiComment)previous);
        }
        if (!siblingComments.isEmpty()) {
            return DartDocUtil.getSingleLineDocCommentsText(siblingComments.toArray(new PsiComment[siblingComments.size()]));
        }
        return null;
    }

    @NotNull
    private static String getMultilineDocCommentText(@NotNull DartDocComment docComment) {
        if (docComment == null) {
            DartDocUtil.$$$reportNull$$$0(1);
        }
        StringBuilder buf = new StringBuilder();
        boolean afterAsterisk = false;
        for (PsiElement child = docComment.getFirstChild(); child != null; child = child.getNextSibling()) {
            IElementType elementType = child.getNode().getElementType();
            String text = child.getText();
            if (elementType != DartTokenTypesSets.MULTI_LINE_DOC_COMMENT_START && elementType != DartTokenTypesSets.DOC_COMMENT_LEADING_ASTERISK && elementType != DartTokenTypesSets.MULTI_LINE_COMMENT_END) {
                int newLinesCount;
                if (child instanceof PsiWhiteSpace && (newLinesCount = StringUtil.countNewLines((CharSequence)text)) > 0) {
                    buf.append(StringUtil.repeatSymbol((char)'\n', (int)newLinesCount));
                } else if (afterAsterisk && text.startsWith(" ")) {
                    buf.append(text.substring(1));
                } else {
                    buf.append(text);
                }
            }
            afterAsterisk = elementType == DartTokenTypesSets.DOC_COMMENT_LEADING_ASTERISK;
        }
        String string = buf.toString();
        if (string == null) {
            DartDocUtil.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Nullable
    private static String getSingleLineDocCommentsText(@NotNull PsiComment[] comments) {
        if (comments == null) {
            DartDocUtil.$$$reportNull$$$0(3);
        }
        StringBuilder buf = null;
        for (PsiComment comment : comments) {
            if (comment.getNode().getElementType() != DartTokenTypesSets.SINGLE_LINE_DOC_COMMENT) continue;
            if (buf == null) {
                buf = new StringBuilder();
            } else {
                buf.append('\n');
            }
            String text = comment.getText();
            if (text.startsWith("/// ")) {
                buf.append(StringUtil.trimStart((String)text, (String)"/// "));
                continue;
            }
            buf.append(StringUtil.trimStart((String)text, (String)SINGLE_LINE_DOC_COMMENT));
        }
        return buf == null ? null : buf.toString();
    }

    private static void appendConstructorSignature(StringBuilder builder, DartComponent component, DartClass dartClass) {
        if (component instanceof DartNamedConstructorDeclaration || component instanceof DartFactoryConstructorDeclaration) {
            builder.append("<b>").append(dartClass.getName()).append(".</b>");
        }
        DartDocUtil.appendFunctionSignature(builder, component, dartClass.getName());
    }

    private static void appendVariableSignature(@NotNull StringBuilder builder, @NotNull DartComponent component, @Nullable DartType type) {
        if (builder == null) {
            DartDocUtil.$$$reportNull$$$0(4);
        }
        if (component == null) {
            DartDocUtil.$$$reportNull$$$0(5);
        }
        if (type == null) {
            builder.append("var ");
        } else {
            DartDocUtil.appendDartType(builder, type);
            builder.append(" ");
        }
        builder.append("<b>").append(component.getName()).append("</b>");
    }

    private static void appendDartType(@NotNull StringBuilder builder, @NotNull DartType type) {
        DartReferenceExpression expression;
        if (builder == null) {
            DartDocUtil.$$$reportNull$$$0(6);
        }
        if (type == null) {
            DartDocUtil.$$$reportNull$$$0(7);
        }
        if ((expression = type.getReferenceExpression()) != null) {
            builder.append(StringUtil.escapeXml((String)expression.getText()));
            DartDocUtil.appendTypeArguments(builder, type);
        } else {
            builder.append("Function");
        }
    }

    private static void appendTypeArguments(@NotNull StringBuilder builder, @NotNull DartType type) {
        DartTypeList typeList;
        List<DartType> children;
        DartTypeArguments typeArguments;
        if (builder == null) {
            DartDocUtil.$$$reportNull$$$0(8);
        }
        if (type == null) {
            DartDocUtil.$$$reportNull$$$0(9);
        }
        if ((typeArguments = type.getTypeArguments()) != null && !(children = (typeList = typeArguments.getTypeList()).getTypeList()).isEmpty()) {
            builder.append("&lt;");
            DartDocUtil.appendDartTypeList(builder, children);
            builder.append("&gt;");
        }
    }

    private static void appendClassSignature(StringBuilder builder, DartClass dartClass) {
        List<DartType> implementsList;
        if (dartClass.isEnum()) {
            builder.append("enum <b>").append(dartClass.getName()).append("</b>");
            return;
        }
        if (dartClass.isAbstract()) {
            builder.append("abstract ");
        }
        builder.append("class <b>").append(dartClass.getName()).append("</b>");
        DartDocUtil.appendTypeParams(builder, dartClass.getTypeParameters());
        List<DartType> mixins = dartClass.getMixinsList();
        DartType superClass = dartClass.getSuperClass();
        if (superClass != null) {
            builder.append(" extends ").append(StringUtil.escapeXml((String)superClass.getText()));
        }
        if (!mixins.isEmpty()) {
            builder.append(" with ");
            DartDocUtil.appendDartTypeList(builder, mixins);
        }
        if (!(implementsList = dartClass.getImplementsList()).isEmpty()) {
            builder.append(" implements ");
            DartDocUtil.appendDartTypeList(builder, implementsList);
        }
    }

    private static void appendDartTypeList(StringBuilder builder, List<DartType> dartTypes) {
        Iterator<DartType> iter = dartTypes.iterator();
        while (iter.hasNext()) {
            DartDocUtil.appendDartType(builder, iter.next());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
    }

    private static void appendTypeParams(StringBuilder builder, DartTypeParameters typeParameters) {
        List<DartTypeParameter> parameters;
        if (typeParameters != null && !(parameters = typeParameters.getTypeParameterList()).isEmpty()) {
            builder.append("&lt;");
            Iterator<DartTypeParameter> iter = parameters.iterator();
            while (iter.hasNext()) {
                builder.append(iter.next().getText());
                if (!iter.hasNext()) continue;
                builder.append(", ");
            }
            builder.append("&gt;");
        }
    }

    private static void appendFunctionSignature(StringBuilder builder, DartComponent function, DartReturnType returnType) {
        String returnString = returnType == null ? "dynamic" : StringUtil.escapeXml((String)DartPresentableUtil.buildTypeText(null, returnType, null));
        DartDocUtil.appendFunctionSignature(builder, function, returnString);
    }

    private static void appendFunctionSignature(StringBuilder builder, DartComponent function, String returnType) {
        builder.append("<b>").append(function.getName()).append("</b>");
        if (!function.isGetter()) {
            builder.append('(');
            builder.append(StringUtil.escapeXml((String)DartPresentableUtil.getPresentableParameterList(function, new DartGenericSpecialization(), true, true, false)));
            builder.append(')');
        }
        builder.append(' ');
        builder.append(DartPresentableUtil.RIGHT_ARROW);
        builder.append(' ');
        builder.append(returnType);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/documentation/DartDocUtil";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comments";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/documentation/DartDocUtil";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getMultilineDocCommentText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getSignature";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getMultilineDocCommentText";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSingleLineDocCommentsText";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendVariableSignature";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "appendDartType";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendTypeArguments";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

