/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.completion;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.assists.AssistUtils;
import com.jetbrains.lang.dart.assists.DartSourceEditException;
import org.dartlang.analysis.server.protocol.Position;
import org.dartlang.analysis.server.protocol.SourceChange;
import org.dartlang.analysis.server.protocol.SourceEdit;
import org.dartlang.analysis.server.protocol.SourceFileEdit;
import org.jetbrains.annotations.NotNull;

public class DartServerStatementCompletionProcessor
extends SmartEnterProcessor {
    public boolean process(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile psiFile) {
        if (project == null) {
            DartServerStatementCompletionProcessor.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            DartServerStatementCompletionProcessor.$$$reportNull$$$0(1);
        }
        if (psiFile == null) {
            DartServerStatementCompletionProcessor.$$$reportNull$$$0(2);
        }
        int offset = editor.getCaretModel().getOffset();
        DartAnalysisServerService service = DartAnalysisServerService.getInstance(psiFile.getProject());
        service.updateFilesContent();
        SourceChange sourceChange = service.edit_getStatementCompletion(psiFile.getVirtualFile(), offset);
        if (sourceChange != null && !DartServerStatementCompletionProcessor.isNoop(sourceChange)) {
            try {
                AssistUtils.applySourceChange(project, sourceChange, true);
                Position position = sourceChange.getSelection();
                if (position != null) {
                    editor.getCaretModel().moveToOffset(service.getConvertedOffset(psiFile.getVirtualFile(), position.getOffset()));
                }
            }
            catch (DartSourceEditException e) {
                CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)CommonBundle.getErrorTitle(), null);
            }
            return true;
        }
        return false;
    }

    private static boolean isNoop(@NotNull SourceChange sourceChange) {
        if (sourceChange == null) {
            DartServerStatementCompletionProcessor.$$$reportNull$$$0(3);
        }
        for (SourceFileEdit fileEdit : sourceChange.getEdits()) {
            for (SourceEdit edit : fileEdit.getEdits()) {
                if (edit.getLength() == 0 && edit.getReplacement().isEmpty()) continue;
                return false;
            }
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceChange";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/lang/dart/ide/completion/DartServerStatementCompletionProcessor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "isNoop";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

