/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.completion.CompletionContributor;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.completion.CompletionSorter;
import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.codeInsight.lookup.LookupElementWeigher;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.TemplateBuilderFactory;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.codeInsight.template.impl.TextExpression;
import com.intellij.icons.AllIcons;
import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.html.HTMLLanguage;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import com.intellij.ui.LayeredIcon;
import com.intellij.ui.RowIcon;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ProcessingContext;
import com.jetbrains.lang.dart.DartLanguage;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.ide.codeInsight.DartCodeInsightSettings;
import com.jetbrains.lang.dart.ide.completion.DartCompletionExtension;
import com.jetbrains.lang.dart.ide.completion.DartLookupObject;
import com.jetbrains.lang.dart.psi.DartNewExpression;
import com.jetbrains.lang.dart.psi.DartParenthesizedExpression;
import com.jetbrains.lang.dart.psi.DartReferenceExpression;
import com.jetbrains.lang.dart.psi.DartStringLiteralExpression;
import com.jetbrains.lang.dart.psi.DartUriElement;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.util.DartResolveUtil;
import com.jetbrains.lang.dart.util.PubspecYamlUtil;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang3.StringUtils;
import org.dartlang.analysis.server.protocol.CompletionSuggestion;
import org.dartlang.analysis.server.protocol.Element;
import org.dartlang.analysis.server.protocol.Location;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartServerCompletionContributor
extends CompletionContributor {
    public DartServerCompletionContributor() {
        this.extend(CompletionType.BASIC, StandardPatterns.or((ElementPattern[])new ElementPattern[]{PlatformPatterns.psiElement().withLanguage(DartLanguage.INSTANCE), PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withLanguage((Language)HTMLLanguage.INSTANCE)), PlatformPatterns.psiElement().inFile((ElementPattern)PlatformPatterns.psiFile().withName(".analysis_options"))}), (CompletionProvider)new CompletionProvider<CompletionParameters>(){

            protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet originalResultSet) {
                VirtualFile file;
                if (parameters == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (context == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (originalResultSet == null) {
                    1.$$$reportNull$$$0(2);
                }
                if ((file = DartResolveUtil.getRealVirtualFile(parameters.getOriginalFile())) instanceof VirtualFileWindow) {
                    file = ((VirtualFileWindow)file).getDelegate();
                }
                if (file == null) {
                    return;
                }
                Project project = parameters.getOriginalFile().getProject();
                if (file.getFileType() == HtmlFileType.INSTANCE && PubspecYamlUtil.findPubspecYamlFile(project, file) == null && !Registry.is((String)"dart.projects.without.pubspec", (boolean)false)) {
                    return;
                }
                DartSdk sdk = DartSdk.getDartSdk(project);
                if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
                    return;
                }
                DartAnalysisServerService das = DartAnalysisServerService.getInstance(project);
                das.updateFilesContent();
                int offset = InjectedLanguageManager.getInstance((Project)project).injectedToHost((PsiElement)parameters.getOriginalFile(), parameters.getOffset());
                String completionId = das.completion_getSuggestions(file, offset);
                if (completionId == null) {
                    return;
                }
                CompletionSorter sorter = DartServerCompletionContributor.createSorter(parameters, originalResultSet.getPrefixMatcher());
                String uriPrefix = DartServerCompletionContributor.getPrefixIfCompletingUri(parameters);
                CompletionResultSet resultSet = uriPrefix != null ? originalResultSet.withRelevanceSorter(sorter).withPrefixMatcher(uriPrefix) : originalResultSet.withRelevanceSorter(sorter);
                das.addCompletions(file, completionId, (int replacementOffset, int replacementLength, CompletionSuggestion suggestion) -> {
                    DartCompletionExtension extension;
                    String specialPrefix;
                    if (parameters == null) {
                        1.$$$reportNull$$$0(3);
                    }
                    CompletionResultSet updatedResultSet = uriPrefix != null ? resultSet : ((specialPrefix = DartServerCompletionContributor.getPrefixForSpecialCases(parameters, replacementOffset)) != null ? resultSet.withPrefixMatcher(specialPrefix) : resultSet);
                    LookupElementBuilder lookupElement = null;
                    DartCompletionExtension[] dartCompletionExtensionArray = DartCompletionExtension.getExtensions();
                    int n = dartCompletionExtensionArray.length;
                    for (int i = 0; i < n && (lookupElement = (extension = dartCompletionExtensionArray[i]).createLookupElement(project, suggestion)) == null; ++i) {
                    }
                    if (lookupElement == null) {
                        lookupElement = DartServerCompletionContributor.createLookupElement(project, suggestion);
                    }
                    updatedResultSet.addElement(lookupElement);
                });
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "parameters";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "context";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "originalResultSet";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "addCompletions";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "lambda$addCompletions$0";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static CompletionSorter createSorter(@NotNull CompletionParameters parameters, @NotNull PrefixMatcher prefixMatcher) {
        if (parameters == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(0);
        }
        if (prefixMatcher == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(1);
        }
        LookupElementWeigher dartWeigher = new LookupElementWeigher("dartRelevance", true, false){

            public Integer weigh(@NotNull LookupElement element) {
                Object lookupObject;
                if (element == null) {
                    2.$$$reportNull$$$0(0);
                }
                return (lookupObject = element.getObject()) instanceof DartLookupObject ? ((DartLookupObject)lookupObject).getRelevance() : 0;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor$2", "weigh"));
            }
        };
        CompletionSorter defaultSorter = CompletionSorter.defaultSorter((CompletionParameters)parameters, (PrefixMatcher)prefixMatcher);
        return defaultSorter.weighBefore("liftShorter", new LookupElementWeigher[]{dartWeigher});
    }

    @Nullable
    private static String getPrefixIfCompletingUri(@NotNull CompletionParameters parameters) {
        PsiElement parentParent;
        PsiElement psiElement;
        if (parameters == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(2);
        }
        PsiElement parent = (psiElement = parameters.getOriginalPosition()) != null ? psiElement.getParent() : null;
        PsiElement psiElement2 = parentParent = parent instanceof DartStringLiteralExpression ? parent.getParent() : null;
        if (parentParent instanceof DartUriElement) {
            int uriStringOffset = ((TextRange)((DartUriElement)parentParent).getUriStringAndItsRange().second).getStartOffset();
            if (parameters.getOffset() >= parentParent.getTextRange().getStartOffset() + uriStringOffset) {
                return parentParent.getText().substring(uriStringOffset, parameters.getOffset() - parentParent.getTextRange().getStartOffset());
            }
        }
        return null;
    }

    @Nullable
    private static String getPrefixForSpecialCases(@NotNull CompletionParameters parameters, int replacementOffset) {
        PsiElement psiElement;
        if (parameters == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(3);
        }
        if ((psiElement = parameters.getOriginalPosition()) == null) {
            return null;
        }
        PsiElement parent = psiElement.getParent();
        Language language = psiElement.getContainingFile().getLanguage();
        if (parent instanceof DartStringLiteralExpression || language.isKindOf((Language)XMLLanguage.INSTANCE)) {
            return DartServerCompletionContributor.getPrefixUsingServerData(parameters, replacementOffset);
        }
        return null;
    }

    @Nullable
    private static String getPrefixUsingServerData(@NotNull CompletionParameters parameters, int replacementOffset) {
        int elementStartOffset;
        TextRange range;
        PsiFile injectedContext;
        PsiElement element;
        if (parameters == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(4);
        }
        if ((element = parameters.getOriginalPosition()) == null) {
            return null;
        }
        InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)element.getProject());
        int completionOffset = manager.injectedToHost((PsiElement)(injectedContext = parameters.getOriginalFile()), parameters.getOffset());
        if (completionOffset < (range = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange())).getStartOffset() || completionOffset > range.getEndOffset()) {
            return null;
        }
        if (replacementOffset > completionOffset) {
            return null;
        }
        while (element != null && (elementStartOffset = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange().getStartOffset())) > replacementOffset) {
            element = element.getParent();
        }
        if (element != null) {
            int startOffset = manager.injectedToHost((PsiElement)injectedContext, element.getTextRange().getStartOffset());
            return element.getText().substring(replacementOffset - startOffset, completionOffset - startOffset);
        }
        return null;
    }

    public void beforeCompletion(@NotNull CompletionInitializationContext context) {
        PsiElement psiElement;
        PsiElement parent;
        if (context == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(5);
        }
        PsiElement psiElement2 = parent = (psiElement = context.getFile().findElementAt(context.getStartOffset())) != null ? psiElement.getParent() : null;
        if (parent instanceof DartStringLiteralExpression) {
            PsiElement parentParent = parent.getParent();
            if (parentParent instanceof DartUriElement) {
                Pair<String, TextRange> uriAndRange = ((DartUriElement)parentParent).getUriStringAndItsRange();
                context.setReplacementOffset(parentParent.getTextRange().getStartOffset() + ((TextRange)uriAndRange.second).getEndOffset());
            } else {
                context.setReplacementOffset(context.getReplacementOffset());
            }
        } else {
            PsiElement lastChild;
            PsiElement firstChild;
            PsiReference reference = context.getFile().findReferenceAt(context.getStartOffset());
            if (reference instanceof PsiMultiReference && ((PsiMultiReference)reference).getReferences().length > 0) {
                reference.getRangeInElement();
                reference = ((PsiMultiReference)reference).getReferences()[0];
            }
            if (reference instanceof DartNewExpression || reference instanceof DartParenthesizedExpression) {
                context.setReplacementOffset(context.getStartOffset());
            }
            if (reference instanceof DartReferenceExpression && (firstChild = ((DartReferenceExpression)reference).getFirstChild()) != (lastChild = ((DartReferenceExpression)reference).getLastChild()) && lastChild instanceof PsiErrorElement && context.getStartOffset() <= firstChild.getTextRange().getEndOffset()) {
                context.setReplacementOffset(firstChild.getTextRange().getEndOffset());
            }
        }
    }

    private static Icon applyOverlay(Icon base, boolean condition, Icon overlay) {
        if (condition) {
            return new LayeredIcon(new Icon[]{base, overlay});
        }
        return base;
    }

    @NotNull
    public static LookupElementBuilder createLookupElement(@NotNull Project project, @NotNull CompletionSuggestion suggestion) {
        int dotIndex;
        Element element;
        if (project == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(6);
        }
        if (suggestion == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(7);
        }
        Location location = (element = suggestion.getElement()) == null ? null : element.getLocation();
        DartLookupObject lookupObject = new DartLookupObject(project, location, suggestion.getRelevance());
        String lookupString = suggestion.getCompletion();
        LookupElementBuilder lookup = LookupElementBuilder.create((Object)lookupObject, (String)lookupString);
        if (suggestion.getDisplayText() != null) {
            lookup = lookup.withPresentableText(suggestion.getDisplayText());
        }
        if (suggestion.getKind().equals("KEYWORD")) {
            lookup = lookup.bold();
        }
        if ((dotIndex = lookupString.indexOf(46)) > 0 && dotIndex < lookupString.length() - 1 && StringUtil.isJavaIdentifier((String)lookupString.substring(0, dotIndex)) && StringUtil.isJavaIdentifier((String)lookupString.substring(dotIndex + 1))) {
            lookup = lookup.withLookupString(lookupString.substring(dotIndex + 1));
        }
        boolean shouldSetSelection = true;
        if (element != null) {
            Icon icon;
            String returnType;
            if (element.isDeprecated()) {
                lookup = lookup.strikeout();
            }
            if (StringUtil.isEmpty((String)suggestion.getDisplayText())) {
                String parameters;
                String typeParameters = element.getTypeParameters();
                if (typeParameters != null) {
                    lookup = lookup.appendTailText(typeParameters, false);
                }
                if ((parameters = element.getParameters()) != null) {
                    lookup = lookup.appendTailText(parameters, false);
                }
            }
            if (!StringUtils.isEmpty((CharSequence)(returnType = element.getReturnType()))) {
                lookup = lookup.withTypeText(returnType, true);
            }
            if ((icon = DartServerCompletionContributor.getBaseImage(element)) != null) {
                if (suggestion.getKind().equals("OVERRIDE")) {
                    icon = new RowIcon(new Icon[]{icon, AllIcons.Gutter.OverridingMethod});
                } else {
                    icon = new RowIcon(new Icon[]{icon, element.isPrivate() ? PlatformIcons.PRIVATE_ICON : PlatformIcons.PUBLIC_ICON});
                    icon = DartServerCompletionContributor.applyOverlay(icon, element.isFinal(), AllIcons.Nodes.FinalMark);
                    icon = DartServerCompletionContributor.applyOverlay(icon, element.isConst(), AllIcons.Nodes.FinalMark);
                }
                lookup = lookup.withIcon(icon);
            }
            if ("INVOCATION".equals(suggestion.getKind())) {
                shouldSetSelection = false;
                List<String> parameterNames = suggestion.getParameterNames();
                if (parameterNames != null) {
                    lookup = lookup.withInsertHandler((context, item) -> {
                        boolean needRightParenth;
                        if (suggestion == null) {
                            DartServerCompletionContributor.$$$reportNull$$$0(10);
                        }
                        if (project == null) {
                            DartServerCompletionContributor.$$$reportNull$$$0(11);
                        }
                        boolean bl = needRightParenth = CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || parameterNames.isEmpty() && context.getCompletionChar() != '(';
                        if (parameterNames.isEmpty()) {
                            ParenthesesInsertHandler handler = ParenthesesInsertHandler.getInstance((boolean)false, (boolean)false, (boolean)false, (boolean)needRightParenth, (boolean)false);
                            handler.handleInsert(context, item);
                        } else {
                            String argumentListString;
                            ParenthesesInsertHandler handler = ParenthesesInsertHandler.getInstance((boolean)true, (boolean)false, (boolean)false, (boolean)needRightParenth, (boolean)false);
                            handler.handleInsert(context, item);
                            Editor editor = context.getEditor();
                            if (DartCodeInsightSettings.getInstance().INSERT_DEFAULT_ARG_VALUES && (argumentListString = suggestion.getDefaultArgumentListString()) != null) {
                                Document document = editor.getDocument();
                                int offset = editor.getCaretModel().getOffset();
                                CharSequence text = document.getCharsSequence();
                                if (text.charAt(offset - 1) == '(' && text.charAt(offset) == ')') {
                                    document.insertString(offset, (CharSequence)argumentListString);
                                    PsiDocumentManager.getInstance((Project)project).commitDocument(document);
                                    TemplateBuilderImpl builder = (TemplateBuilderImpl)TemplateBuilderFactory.getInstance().createTemplateBuilder((PsiElement)context.getFile());
                                    int[] ranges = suggestion.getDefaultArgumentListTextRanges();
                                    if (ranges != null && (ranges.length & 1) == 0) {
                                        int index = 0;
                                        while (index < ranges.length) {
                                            int start = ranges[index];
                                            int length = ranges[index + 1];
                                            String arg = argumentListString.substring(start, start + length);
                                            TextExpression expression = new TextExpression(arg);
                                            TextRange range = new TextRange(offset + start, offset + start + length);
                                            builder.replaceRange(range, "group_" + ((index += 2) - 1), (Expression)expression, true);
                                        }
                                        builder.run(editor, true);
                                    }
                                }
                            }
                            AutoPopupController.getInstance((Project)project).autoPopupParameterInfo(editor, lookupObject.findPsiElement());
                        }
                    });
                }
            }
        }
        if (shouldSetSelection) {
            lookup = lookup.withInsertHandler((context, item) -> {
                if (suggestion == null) {
                    DartServerCompletionContributor.$$$reportNull$$$0(9);
                }
                Editor editor = context.getEditor();
                int startOffset = context.getStartOffset() + suggestion.getSelectionOffset();
                int endOffset = startOffset + suggestion.getSelectionLength();
                editor.getCaretModel().moveToOffset(startOffset);
                if (endOffset > startOffset) {
                    editor.getSelectionModel().setSelection(startOffset, endOffset);
                }
            });
        }
        LookupElementBuilder lookupElementBuilder = lookup;
        if (lookupElementBuilder == null) {
            DartServerCompletionContributor.$$$reportNull$$$0(8);
        }
        return lookupElementBuilder;
    }

    private static Icon getBaseImage(Element element) {
        String elementKind = element.getKind();
        if (elementKind.equals("CLASS") || elementKind.equals("CLASS_TYPE_ALIAS")) {
            if (element.isAbstract()) {
                return AllIcons.Nodes.AbstractClass;
            }
            return AllIcons.Nodes.Class;
        }
        if (elementKind.equals("ENUM")) {
            return AllIcons.Nodes.Enum;
        }
        if (elementKind.equals("ENUM_CONSTANT") || elementKind.equals("FIELD")) {
            return AllIcons.Nodes.Field;
        }
        if (elementKind.equals("COMPILATION_UNIT")) {
            return PlatformIcons.FILE_ICON;
        }
        if (elementKind.equals("CONSTRUCTOR")) {
            return AllIcons.Nodes.ClassInitializer;
        }
        if (elementKind.equals("GETTER")) {
            return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyReadStatic : AllIcons.Nodes.PropertyRead;
        }
        if (elementKind.equals("SETTER")) {
            return element.isTopLevelOrStatic() ? AllIcons.Nodes.PropertyWriteStatic : AllIcons.Nodes.PropertyWrite;
        }
        if (elementKind.equals("METHOD")) {
            if (element.isAbstract()) {
                return AllIcons.Nodes.AbstractMethod;
            }
            return AllIcons.Nodes.Method;
        }
        if (elementKind.equals("FUNCTION")) {
            return AllIcons.Nodes.Function;
        }
        if (elementKind.equals("FUNCTION_TYPE_ALIAS")) {
            return AllIcons.Nodes.Annotationtype;
        }
        if (elementKind.equals("TOP_LEVEL_VARIABLE")) {
            return AllIcons.Nodes.Variable;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameters";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefixMatcher";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 6: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suggestion";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/completion/DartServerCompletionContributor";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createLookupElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createSorter";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixIfCompletingUri";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixForSpecialCases";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getPrefixUsingServerData";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "beforeCompletion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createLookupElement";
                break;
            }
            case 8: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLookupElement$1";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "lambda$createLookupElement$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

