/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressableProblemGroup;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import java.util.Locale;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartProblemGroup
implements SuppressableProblemGroup {
    @NotNull
    private String myErrorCode;
    @NotNull
    private String myErrorSeverity;

    public DartProblemGroup(@NotNull String errorCode, @NotNull String errorSeverity) {
        if (errorCode == null) {
            DartProblemGroup.$$$reportNull$$$0(0);
        }
        if (errorSeverity == null) {
            DartProblemGroup.$$$reportNull$$$0(1);
        }
        this.myErrorCode = errorCode;
        this.myErrorSeverity = errorSeverity;
    }

    @NotNull
    public SuppressIntentionAction[] getSuppressActions(@Nullable PsiElement element) {
        SuppressIntentionAction[] suppressIntentionActionArray = new SuppressIntentionAction[]{new DartSuppressAction(this.myErrorCode, this.myErrorSeverity, false), new DartSuppressAction(this.myErrorCode, this.myErrorSeverity, true)};
        if (suppressIntentionActionArray == null) {
            DartProblemGroup.$$$reportNull$$$0(2);
        }
        return suppressIntentionActionArray;
    }

    @Nullable
    public String getProblemName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorCode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorSeverity";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSuppressActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class DartSuppressAction
    extends SuppressIntentionAction
    implements Comparable<IntentionAction> {
        public static final String IGNORE_PREFIX = "ignore:";
        @NotNull
        private final String myErrorCode;
        private final boolean myEolComment;

        public DartSuppressAction(@NotNull String errorCode, @NotNull String errorSeverity, boolean eolComment) {
            if (errorCode == null) {
                DartSuppressAction.$$$reportNull$$$0(0);
            }
            if (errorSeverity == null) {
                DartSuppressAction.$$$reportNull$$$0(1);
            }
            this.myErrorCode = errorCode;
            this.myEolComment = eolComment;
            this.setText("Suppress " + errorSeverity.toLowerCase(Locale.US) + (eolComment ? " with EOL comment" : " with comment"));
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Suppress errors and warnings in Dart code" == null) {
                DartSuppressAction.$$$reportNull$$$0(2);
            }
            return "Suppress errors and warnings in Dart code";
        }

        @Override
        public int compareTo(IntentionAction o) {
            if (o instanceof DartSuppressAction) {
                return ((DartSuppressAction)o).myEolComment ? -1 : 1;
            }
            return 0;
        }

        public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
            if (project == null) {
                DartSuppressAction.$$$reportNull$$$0(3);
            }
            if (element == null) {
                DartSuppressAction.$$$reportNull$$$0(4);
            }
            if (editor == null) {
                return false;
            }
            Document document = editor.getDocument();
            int line = document.getLineNumber(element.getTextRange().getStartOffset());
            if (this.myEolComment) {
                return !DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line) || DartSuppressAction.hasEolIgnoreComment(document, line);
            }
            return !DartSuppressAction.hasEolIgnoreComment(document, line) || DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line);
        }

        private static boolean hasEolIgnoreComment(@NotNull Document document, int line) {
            CharSequence lineText;
            if (document == null) {
                DartSuppressAction.$$$reportNull$$$0(5);
            }
            if (!StringUtil.contains((CharSequence)(lineText = document.getCharsSequence().subSequence(document.getLineStartOffset(line), document.getLineEndOffset(line))), (CharSequence)IGNORE_PREFIX)) {
                return false;
            }
            int index = lineText.toString().lastIndexOf(IGNORE_PREFIX);
            block4: while (index > 0) {
                char ch = lineText.charAt(--index);
                switch (ch) {
                    case ' ': {
                        continue block4;
                    }
                    case '/': {
                        return index >= 2 && lineText.charAt(index - 1) == '/' && lineText.charAt(index - 2) != '/';
                    }
                }
                return false;
            }
            return false;
        }

        private static boolean hasIgnoreCommentOnPrevLine(@NotNull Document document, int line) {
            if (document == null) {
                DartSuppressAction.$$$reportNull$$$0(6);
            }
            if (line == 0) {
                return false;
            }
            CharSequence prevLine = document.getCharsSequence().subSequence(document.getLineStartOffset(line - 1), document.getLineEndOffset(line - 1));
            int index = -1;
            block4: while (++index < prevLine.length()) {
                char ch = prevLine.charAt(index);
                switch (ch) {
                    case ' ': {
                        continue block4;
                    }
                    case '/': {
                        String comment;
                        return prevLine.length() > index + 1 && prevLine.charAt(index + 1) == '/' && StringUtil.trimLeading((String)(comment = prevLine.subSequence(index + 2, prevLine.length()).toString()), (char)' ').startsWith(IGNORE_PREFIX);
                    }
                }
                return false;
            }
            return false;
        }

        public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
            if (project == null) {
                DartSuppressAction.$$$reportNull$$$0(7);
            }
            if (element == null) {
                DartSuppressAction.$$$reportNull$$$0(8);
            }
            if (editor == null) {
                return;
            }
            Document document = editor.getDocument();
            int line = document.getLineNumber(element.getTextRange().getStartOffset());
            if (this.myEolComment) {
                if (DartSuppressAction.hasEolIgnoreComment(document, line)) {
                    DartSuppressAction.appendErrorCode(document, line, this.myErrorCode);
                } else {
                    DartSuppressAction.addEolComment(document, line, this.myErrorCode);
                }
            } else if (DartSuppressAction.hasIgnoreCommentOnPrevLine(document, line)) {
                DartSuppressAction.appendErrorCode(document, line - 1, this.myErrorCode);
            } else {
                DartSuppressAction.addCommentOnPrevLine(document, line, this.myErrorCode);
            }
        }

        private static void appendErrorCode(@NotNull Document document, int line, @NotNull String errorCode) {
            int index;
            if (document == null) {
                DartSuppressAction.$$$reportNull$$$0(9);
            }
            if (errorCode == null) {
                DartSuppressAction.$$$reportNull$$$0(10);
            }
            int lineEndOffset = document.getLineEndOffset(line);
            for (index = lineEndOffset - 1; index >= 0 && document.getCharsSequence().charAt(index) == ' '; --index) {
            }
            document.replaceString(index + 1, lineEndOffset, (CharSequence)(", " + errorCode));
        }

        private static void addEolComment(@NotNull Document document, int line, @NotNull String errorCode) {
            if (document == null) {
                DartSuppressAction.$$$reportNull$$$0(11);
            }
            if (errorCode == null) {
                DartSuppressAction.$$$reportNull$$$0(12);
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int lineEndOffset = document.getLineEndOffset(line);
            CharSequence lineText = document.getCharsSequence().subSequence(lineStartOffset, lineEndOffset);
            int commentIndex = StringUtil.indexOf((CharSequence)lineText, (CharSequence)"//");
            if (commentIndex >= 0) {
                document.insertString(lineStartOffset + commentIndex, (CharSequence)("// ignore: " + errorCode + ", "));
            } else {
                int index;
                for (index = lineEndOffset - 1; index >= 0 && document.getCharsSequence().charAt(index) == ' '; --index) {
                }
                document.replaceString(index + 1, lineEndOffset, (CharSequence)(" // ignore: " + errorCode));
            }
        }

        private static void addCommentOnPrevLine(@NotNull Document document, int line, @NotNull String errorCode) {
            if (document == null) {
                DartSuppressAction.$$$reportNull$$$0(13);
            }
            if (errorCode == null) {
                DartSuppressAction.$$$reportNull$$$0(14);
            }
            int lineStartOffset = document.getLineStartOffset(line);
            int offset = 0;
            while (document.getCharsSequence().charAt(lineStartOffset + offset) == ' ') {
                ++offset;
            }
            document.insertString(lineStartOffset, (CharSequence)(StringUtil.repeat((String)" ", (int)offset) + "// ignore: " + errorCode + "\n"));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorCode";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "errorSeverity";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction";
                    break;
                }
                case 3: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 4: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 5: 
                case 6: 
                case 9: 
                case 11: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "document";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/lang/dart/ide/annotator/DartProblemGroup$DartSuppressAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFamilyName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "isAvailable";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "hasEolIgnoreComment";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasIgnoreCommentOnPrevLine";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "invoke";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "appendErrorCode";
                    break;
                }
                case 11: 
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "addEolComment";
                    break;
                }
                case 13: 
                case 14: {
                    objectArray = objectArray;
                    objectArray[2] = "addCommentOnPrevLine";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

