/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.lang.dart.ide.annotator;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.jetbrains.lang.dart.DartBundle;
import com.jetbrains.lang.dart.DartTokenTypes;
import com.jetbrains.lang.dart.DartTokenTypesSets;
import com.jetbrains.lang.dart.analyzer.DartAnalysisServerService;
import com.jetbrains.lang.dart.analyzer.DartServerData;
import com.jetbrains.lang.dart.fixes.DartQuickFixSet;
import com.jetbrains.lang.dart.highlight.DartSyntaxHighlighterColors;
import com.jetbrains.lang.dart.ide.annotator.DartProblemGroup;
import com.jetbrains.lang.dart.psi.DartSymbolLiteralExpression;
import com.jetbrains.lang.dart.psi.DartTernaryExpression;
import com.jetbrains.lang.dart.sdk.DartSdk;
import com.jetbrains.lang.dart.sdk.DartSdkLibUtil;
import gnu.trove.THashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DartAnnotator
implements Annotator {
    private static final Key<Boolean> DART_SERVER_DATA_HANDLED = Key.create((String)"DART_SERVER_DATA_HANDLED");
    private static final Map<String, String> HIGHLIGHTING_TYPE_MAP = new THashMap();

    @Contract(value="_, null -> false")
    private static boolean canBeAnalyzedByServer(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            DartAnnotator.$$$reportNull$$$0(0);
        }
        if (!DartAnalysisServerService.isLocalAnalyzableFile(file)) {
            return false;
        }
        DartSdk sdk = DartSdk.getDartSdk(project);
        if (sdk == null || !DartAnalysisServerService.isDartSdkVersionSufficient(sdk)) {
            return false;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        if (fileIndex.isInLibraryClasses(file)) {
            return true;
        }
        Module module = fileIndex.getModuleForFile(file);
        return module != null && DartSdkLibUtil.isDartSdkEnabled(module);
    }

    public static boolean shouldIgnoreMessageFromDartAnalyzer(@NotNull String filePath, @NotNull String analysisErrorFileSD) {
        if (filePath == null) {
            DartAnnotator.$$$reportNull$$$0(1);
        }
        if (analysisErrorFileSD == null) {
            DartAnnotator.$$$reportNull$$$0(2);
        }
        return !filePath.equals(FileUtil.toSystemIndependentName((String)analysisErrorFileSD));
    }

    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder) {
        ASTNode previous;
        if (element == null) {
            DartAnnotator.$$$reportNull$$$0(3);
        }
        if (holder == null) {
            DartAnnotator.$$$reportNull$$$0(4);
        }
        if (holder.isBatchMode()) {
            return;
        }
        AnnotationSession session = holder.getCurrentAnnotationSession();
        if (session.getUserData(DART_SERVER_DATA_HANDLED) != Boolean.TRUE) {
            session.putUserData(DART_SERVER_DATA_HANDLED, (Object)Boolean.TRUE);
            VirtualFile vFile = element.getContainingFile().getVirtualFile();
            DartAnalysisServerService service = DartAnalysisServerService.getInstance(element.getProject());
            if (DartAnnotator.canBeAnalyzedByServer(element.getProject(), vFile) && service.serverReadyForRequest(element.getProject())) {
                service.updateFilesContent();
                if (ApplicationManager.getApplication().isUnitTestMode()) {
                    service.waitForAnalysisToComplete_TESTS_ONLY(vFile);
                }
                DartAnnotator.applyServerHighlighting(vFile, holder);
            }
        }
        if (DartTokenTypes.COLON == element.getNode().getElementType() && element.getParent() instanceof DartTernaryExpression) {
            holder.createInfoAnnotation(element, null).setTextAttributes(DartSyntaxHighlighterColors.OPERATION_SIGN);
            return;
        }
        if (DartTokenTypesSets.BUILT_IN_IDENTIFIERS.contains(element.getNode().getElementType()) && element.getNode().getTreeParent().getElementType() != DartTokenTypes.ID) {
            holder.createInfoAnnotation(element, null).setTextAttributes(DartSyntaxHighlighterColors.KEYWORD);
            return;
        }
        if (DartTokenTypes.MUL == element.getNode().getElementType() && (previous = element.getNode().getTreePrev()) != null && (previous.getElementType() == DartTokenTypes.SYNC || previous.getElementType() == DartTokenTypes.ASYNC || previous.getElementType() == DartTokenTypes.YIELD)) {
            holder.createInfoAnnotation(element, null).setTextAttributes(DartSyntaxHighlighterColors.KEYWORD);
        }
        if (element.getNode().getElementType() == DartTokenTypes.REGULAR_STRING_PART) {
            DartAnnotator.highlightEscapeSequences(element, holder);
            return;
        }
        if (element instanceof DartSymbolLiteralExpression) {
            holder.createInfoAnnotation(element, null).setTextAttributes(DartSyntaxHighlighterColors.SYMBOL_LITERAL);
            return;
        }
    }

    private static void applyServerHighlighting(@NotNull VirtualFile file, @NotNull AnnotationHolder holder) {
        if (file == null) {
            DartAnnotator.$$$reportNull$$$0(5);
        }
        if (holder == null) {
            DartAnnotator.$$$reportNull$$$0(6);
        }
        PsiFile psiFile = holder.getCurrentAnnotationSession().getFile();
        DartAnalysisServerService das = DartAnalysisServerService.getInstance(psiFile.getProject());
        for (DartServerData.DartError error : das.getErrors(file)) {
            Annotation annotation;
            if (DartAnnotator.shouldIgnoreMessageFromDartAnalyzer(file.getPath(), error.getAnalysisErrorFileSD()) || (annotation = DartAnnotator.createAnnotation(holder, error, psiFile.getTextLength())) == null) continue;
            DartQuickFixSet quickFixSet = new DartQuickFixSet(psiFile.getManager(), file, error.getOffset(), error.getCode(), error.getSeverity());
            for (IntentionAction intentionAction : quickFixSet.getQuickFixes()) {
                annotation.registerFix(intentionAction);
            }
            if (error.getCode() == null) continue;
            annotation.setProblemGroup((ProblemGroup)new DartProblemGroup(error.getCode(), error.getSeverity()));
        }
        for (DartServerData.DartHighlightRegion region : das.getHighlight(file)) {
            String attributeKey = HIGHLIGHTING_TYPE_MAP.get(region.getType());
            if (attributeKey == null) continue;
            TextRange textRange = new TextRange(region.getOffset(), region.getOffset() + region.getLength());
            holder.createInfoAnnotation(textRange, null).setTextAttributes(TextAttributesKey.find((String)attributeKey));
        }
    }

    @Nullable
    private static Annotation createAnnotation(@NotNull AnnotationHolder holder, @NotNull DartServerData.DartError error, int fileTextLength) {
        Annotation annotation;
        if (holder == null) {
            DartAnnotator.$$$reportNull$$$0(7);
        }
        if (error == null) {
            DartAnnotator.$$$reportNull$$$0(8);
        }
        int highlightingStart = error.getOffset();
        int highlightingEnd = error.getOffset() + error.getLength();
        if (highlightingEnd > fileTextLength) {
            highlightingEnd = fileTextLength;
        }
        if (highlightingStart > 0 && highlightingStart >= highlightingEnd) {
            highlightingStart = highlightingEnd - 1;
        }
        TextRange textRange = new TextRange(highlightingStart, highlightingEnd);
        String severity = error.getSeverity();
        String message = StringUtil.notNullize((String)error.getMessage());
        ProblemHighlightType specialHighlightType = DartAnnotator.getSpecialHighlightType(message);
        if ("INFO".equals(severity) && specialHighlightType == null) {
            annotation = holder.createWeakWarningAnnotation(textRange, message);
            annotation.setTextAttributes(DartSyntaxHighlighterColors.HINT);
        } else if ("WARNING".equals(severity) || "INFO".equals(severity) && specialHighlightType != null) {
            annotation = holder.createWarningAnnotation(textRange, message);
            annotation.setTextAttributes(DartSyntaxHighlighterColors.WARNING);
        } else if ("ERROR".equals(severity)) {
            annotation = holder.createErrorAnnotation(textRange, message);
            annotation.setTextAttributes(DartSyntaxHighlighterColors.ERROR);
        } else {
            annotation = null;
        }
        if (annotation != null && specialHighlightType != null) {
            annotation.setTextAttributes(null);
            annotation.setHighlightType(specialHighlightType);
        }
        return annotation;
    }

    @Nullable
    private static ProblemHighlightType getSpecialHighlightType(@NotNull String errorMessage) {
        if (errorMessage == null) {
            DartAnnotator.$$$reportNull$$$0(9);
        }
        if (errorMessage.startsWith("Unused import") || errorMessage.startsWith("Duplicate import") || errorMessage.contains(" is not used") || errorMessage.contains(" isn't used") || errorMessage.startsWith("Dead code")) {
            return ProblemHighlightType.LIKE_UNUSED_SYMBOL;
        }
        if (errorMessage.contains(" is deprecated")) {
            return ProblemHighlightType.LIKE_DEPRECATED;
        }
        return null;
    }

    private static void highlightEscapeSequences(PsiElement node, AnnotationHolder holder) {
        List<Pair<TextRange, Boolean>> escapeSequenceRangesAndValidity = DartAnnotator.getEscapeSequenceRangesAndValidity(node.getText());
        for (Pair<TextRange, Boolean> rangeAndValidity : escapeSequenceRangesAndValidity) {
            TextAttributesKey attribute;
            TextRange range = ((TextRange)rangeAndValidity.first).shiftRight(node.getTextRange().getStartOffset());
            TextAttributesKey textAttributesKey = attribute = (Boolean)rangeAndValidity.second != false ? DartSyntaxHighlighterColors.VALID_STRING_ESCAPE : DartSyntaxHighlighterColors.INVALID_STRING_ESCAPE;
            if (((Boolean)rangeAndValidity.second).booleanValue()) {
                holder.createInfoAnnotation(range, null).setTextAttributes(attribute);
                continue;
            }
            holder.createErrorAnnotation(range, DartBundle.message("dart.color.settings.description.invalid.string.escape", new Object[0])).setTextAttributes(attribute);
        }
    }

    @NotNull
    private static List<Pair<TextRange, Boolean>> getEscapeSequenceRangesAndValidity(@Nullable String text) {
        if (StringUtil.isEmpty((String)text)) {
            List<Pair<TextRange, Boolean>> list = Collections.emptyList();
            if (list == null) {
                DartAnnotator.$$$reportNull$$$0(10);
            }
            return list;
        }
        ArrayList<Pair<TextRange, Boolean>> result = new ArrayList<Pair<TextRange, Boolean>>();
        int currentIndex = -1;
        while ((currentIndex = text.indexOf(92, currentIndex)) != -1) {
            char nextChar;
            int startIndex = currentIndex;
            if (text.length() <= currentIndex + 1) {
                result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, text.length()), (Object)false));
                break;
            }
            if ((nextChar = text.charAt(++currentIndex)) == 'x') {
                if (text.length() <= currentIndex + 2) {
                    result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, text.length()), (Object)false));
                    break;
                }
                char hexChar1 = text.charAt(++currentIndex);
                char hexChar2 = text.charAt(++currentIndex);
                boolean valid = StringUtil.isHexDigit((char)hexChar1) && StringUtil.isHexDigit((char)hexChar2);
                result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, ++currentIndex), (Object)valid));
                continue;
            }
            if (nextChar == 'u') {
                char hexOrBraceChar1;
                if (text.length() <= currentIndex + 1) {
                    result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, text.length()), (Object)false));
                    break;
                }
                if ((hexOrBraceChar1 = text.charAt(++currentIndex)) == '{') {
                    int closingBraceIndex;
                    if ((closingBraceIndex = text.indexOf(125, ++currentIndex)) == -1) {
                        result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, currentIndex), (Object)false));
                        continue;
                    }
                    String textInBrackets = text.substring(currentIndex, closingBraceIndex);
                    currentIndex = closingBraceIndex + 1;
                    boolean valid = textInBrackets.length() > 0 && textInBrackets.length() <= 6 && DartAnnotator.isHexString(textInBrackets);
                    result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, currentIndex), (Object)valid));
                    continue;
                }
                char hexChar1 = hexOrBraceChar1;
                if (text.length() <= currentIndex + 3) {
                    result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, text.length()), (Object)false));
                    break;
                }
                char hexChar2 = text.charAt(++currentIndex);
                char hexChar3 = text.charAt(++currentIndex);
                char hexChar4 = text.charAt(++currentIndex);
                boolean valid = StringUtil.isHexDigit((char)hexChar1) && StringUtil.isHexDigit((char)hexChar2) && StringUtil.isHexDigit((char)hexChar3) && StringUtil.isHexDigit((char)hexChar4);
                result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, ++currentIndex), (Object)valid));
                continue;
            }
            result.add((Pair<TextRange, Boolean>)Pair.create((Object)new TextRange(startIndex, ++currentIndex), (Object)true));
        }
        ArrayList<Pair<TextRange, Boolean>> arrayList = result;
        if (arrayList == null) {
            DartAnnotator.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private static boolean isHexString(String text) {
        if (StringUtil.isEmpty((String)text)) {
            return false;
        }
        for (int i = 0; i < text.length(); ++i) {
            if (StringUtil.isHexDigit((char)text.charAt(i))) continue;
            return false;
        }
        return true;
    }

    static {
        HIGHLIGHTING_TYPE_MAP.put("ANNOTATION", "DART_ANNOTATION");
        HIGHLIGHTING_TYPE_MAP.put("CLASS", "DART_CLASS");
        HIGHLIGHTING_TYPE_MAP.put("CONSTRUCTOR", "DART_CONSTRUCTOR");
        HIGHLIGHTING_TYPE_MAP.put("DYNAMIC_LOCAL_VARIABLE_DECLARATION", "DART_DYNAMIC_LOCAL_VARIABLE_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("DYNAMIC_LOCAL_VARIABLE_REFERENCE", "DART_DYNAMIC_LOCAL_VARIABLE_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("DYNAMIC_PARAMETER_DECLARATION", "DART_DYNAMIC_PARAMETER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("DYNAMIC_PARAMETER_REFERENCE", "DART_DYNAMIC_PARAMETER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("ENUM", "DART_ENUM");
        HIGHLIGHTING_TYPE_MAP.put("ENUM_CONSTANT", "DART_ENUM_CONSTANT");
        HIGHLIGHTING_TYPE_MAP.put("FUNCTION_TYPE_ALIAS", "DART_FUNCTION_TYPE_ALIAS");
        HIGHLIGHTING_TYPE_MAP.put("IDENTIFIER_DEFAULT", "DART_IDENTIFIER");
        HIGHLIGHTING_TYPE_MAP.put("IMPORT_PREFIX", "DART_IMPORT_PREFIX");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_FIELD_DECLARATION", "DART_INSTANCE_FIELD_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_FIELD_REFERENCE", "DART_INSTANCE_FIELD_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_GETTER_DECLARATION", "DART_INSTANCE_GETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_GETTER_REFERENCE", "DART_INSTANCE_GETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_METHOD_DECLARATION", "DART_INSTANCE_METHOD_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_METHOD_REFERENCE", "DART_INSTANCE_METHOD_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_SETTER_DECLARATION", "DART_INSTANCE_SETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("INSTANCE_SETTER_REFERENCE", "DART_INSTANCE_SETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("LABEL", "DART_LABEL");
        HIGHLIGHTING_TYPE_MAP.put("LIBRARY_NAME", "DART_LIBRARY_NAME");
        HIGHLIGHTING_TYPE_MAP.put("LOCAL_FUNCTION_DECLARATION", "DART_LOCAL_FUNCTION_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("LOCAL_FUNCTION_REFERENCE", "DART_LOCAL_FUNCTION_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("LOCAL_VARIABLE_DECLARATION", "DART_LOCAL_VARIABLE_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("LOCAL_VARIABLE_REFERENCE", "DART_LOCAL_VARIABLE_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("PARAMETER_DECLARATION", "DART_PARAMETER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("PARAMETER_REFERENCE", "DART_PARAMETER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_FIELD_DECLARATION", "DART_STATIC_FIELD_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_GETTER_DECLARATION", "DART_STATIC_GETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_GETTER_REFERENCE", "DART_STATIC_GETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_METHOD_DECLARATION", "DART_STATIC_METHOD_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_METHOD_REFERENCE", "DART_STATIC_METHOD_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_SETTER_DECLARATION", "DART_STATIC_SETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("STATIC_SETTER_REFERENCE", "DART_STATIC_SETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_FUNCTION_DECLARATION", "DART_TOP_LEVEL_FUNCTION_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_FUNCTION_REFERENCE", "DART_TOP_LEVEL_FUNCTION_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_GETTER_DECLARATION", "DART_TOP_LEVEL_GETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_GETTER_REFERENCE", "DART_TOP_LEVEL_GETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_SETTER_DECLARATION", "DART_TOP_LEVEL_SETTER_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_SETTER_REFERENCE", "DART_TOP_LEVEL_SETTER_REFERENCE");
        HIGHLIGHTING_TYPE_MAP.put("TOP_LEVEL_VARIABLE_DECLARATION", "DART_TOP_LEVEL_VARIABLE_DECLARATION");
        HIGHLIGHTING_TYPE_MAP.put("TYPE_NAME_DYNAMIC", "DART_TYPE_NAME_DYNAMIC");
        HIGHLIGHTING_TYPE_MAP.put("TYPE_PARAMETER", "DART_TYPE_PARAMETER");
        HIGHLIGHTING_TYPE_MAP.put("UNRESOLVED_INSTANCE_MEMBER_REFERENCE", "DART_UNRESOLVED_INSTANCE_MEMBER_REFERENCE");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "analysisErrorFileSD";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/lang/dart/ide/annotator/DartAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/lang/dart/ide/annotator/DartAnnotator";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getEscapeSequenceRangesAndValidity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "canBeAnalyzedByServer";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreMessageFromDartAnalyzer";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "annotate";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "applyServerHighlighting";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotation";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getSpecialHighlightType";
                break;
            }
            case 10: 
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

